/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.grid;

import javax.annotation.Nullable;
import ucar.nc2.calendar.CalendarDate;
import ucar.nc2.grid.Grid;
import ucar.nc2.grid.GridAxis;
import ucar.nc2.grid.GridAxisPoint;
import ucar.nc2.grid.GridCoordinateSystem;
import ucar.nc2.grid.GridDataset;
import ucar.nc2.grid.GridTimeCoordinateSystem;
import ucar.nc2.grid.MaterializedCoordinateSystem;
import ucar.ui.util.NamedObject;
import ucar.unidata.geoloc.ProjectionRect;

class DataState {
    GridDataset gridDataset;
    Grid grid;
    GridCoordinateSystem gcs;
    GridTimeCoordinateSystem tcs;
    MaterializedCoordinateSystem mcs;
    @Nullable
    GridAxisPoint rtaxis;
    @Nullable
    GridAxis<?> toaxis;
    @Nullable
    GridAxis<?> zaxis;
    @Nullable
    GridAxisPoint ensaxis;
    RuntimeNamedObject runtimeCoord;
    Object timeCoord;
    Object vertCoord;
    Double ensCoord;
    int horizStride = 1;
    ProjectionRect projRect;
    int[] index = null;
    Grid lastGrid;
    Object lastRuntime;
    Object lastTime;
    Object lastVert;
    Object lastEnsemble;
    int lastStride;
    ProjectionRect lastProjRect;

    public DataState(GridDataset gridDataset, Grid grid) {
        this.gridDataset = gridDataset;
        this.grid = grid;
        this.gcs = grid.getCoordinateSystem();
        this.tcs = grid.getCoordinateSystem().getTimeCoordinateSystem();
        if (this.tcs != null) {
            this.toaxis = this.tcs.getTimeOffsetAxis(0);
            this.rtaxis = this.tcs.getRunTimeAxis();
        }
        this.zaxis = this.gcs.getVerticalAxis();
        this.ensaxis = this.gcs.getEnsembleAxis();
    }

    boolean setRuntimeCoord(@Nullable Object coord) {
        boolean changed = coord != null && !coord.equals(this.runtimeCoord);
        this.runtimeCoord = (RuntimeNamedObject)coord;
        return changed;
    }

    boolean setTimeCoord(@Nullable Object coord) {
        boolean changed = coord != null && !coord.equals(this.timeCoord);
        this.timeCoord = coord;
        return changed;
    }

    boolean setVertCoord(@Nullable Object coord) {
        boolean changed = coord != null && !coord.equals(this.vertCoord);
        this.vertCoord = coord;
        return changed;
    }

    boolean setEnsCoord(@Nullable Object coord) {
        boolean changed = coord != null && !coord.equals(this.ensCoord);
        this.ensCoord = (Double)coord;
        return changed;
    }

    boolean setProjRect(@Nullable ProjectionRect projRect) {
        boolean changed;
        boolean bl = changed = projRect == null != (this.projRect == null);
        if (projRect != null && this.projRect != null) {
            changed = !projRect.nearlyEquals(this.projRect);
        }
        this.projRect = projRect;
        return changed;
    }

    void saveState() {
        this.lastGrid = this.grid;
        this.lastRuntime = this.runtimeCoord;
        this.lastTime = this.timeCoord;
        this.lastVert = this.vertCoord;
        this.lastEnsemble = this.ensCoord;
        this.lastStride = this.horizStride;
        this.lastProjRect = this.projRect;
    }

    boolean hasChanged() {
        if (this.grid != null && !this.grid.equals(this.lastGrid)) {
            return true;
        }
        if (this.runtimeCoord != null && !this.runtimeCoord.equals(this.lastRuntime)) {
            return true;
        }
        if (this.timeCoord != null && !this.timeCoord.equals(this.lastTime)) {
            return true;
        }
        if (this.vertCoord != null && !this.vertCoord.equals(this.lastVert)) {
            return true;
        }
        if (this.ensCoord != null && !this.ensCoord.equals(this.lastEnsemble)) {
            return true;
        }
        if (this.horizStride != this.lastStride) {
            return true;
        }
        return this.projRect != this.lastProjRect;
    }

    public String toString() {
        return "DataState{grid=" + this.grid + "}";
    }

    static class RuntimeNamedObject
    implements NamedObject {
        final int runtimeIdx;
        final CalendarDate runtime;

        public RuntimeNamedObject(int runtimeIdx, CalendarDate runtime) {
            this.runtimeIdx = runtimeIdx;
            this.runtime = runtime;
        }

        public String getName() {
            return this.runtime.toString();
        }

        public String getDescription() {
            return this.runtime.toString();
        }

        public Object getValue() {
            return this;
        }
    }
}

