/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.grid;

import java.awt.Component;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.util.Formatter;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import javax.swing.RootPaneContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.grid.GridDataset;
import ucar.nc2.grid.GridDatasetFactory;
import ucar.ui.OpPanel;
import ucar.ui.gis.shapefile.ShapeFileBean;
import ucar.ui.gis.worldmap.WorldMapBean;
import ucar.ui.grid.GridNewTable;
import ucar.ui.grid.GridViewer;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.IndependentWindow;
import ucar.util.prefs.PreferencesExt;

public class GridNewPanel
extends OpPanel {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String GRIDNEW_VIEW_FRAME_SIZE = "GridNewViewerWindowSize";
    private final GridNewTable gridNewTable;
    private GridViewer gridViewer;
    private IndependentWindow viewerWindow;
    private GridDataset gridDataset;

    public GridNewPanel(PreferencesExt prefs) {
        super(prefs, "dataset:", true, false);
        this.gridNewTable = new GridNewTable(prefs);
        this.add((Component)this.gridNewTable, "Center");
        AbstractButton viewButton = BAMutil.makeButtcon((String)"alien", (String)"Grid Viewer", (boolean)false);
        viewButton.addActionListener(e -> {
            GridDataset gridDataset = this.gridNewTable.getGridCollection();
            if (gridDataset == null) {
                return;
            }
            if (this.gridViewer == null) {
                this.makeDisplay();
            }
            this.gridViewer.setGridCollection(gridDataset);
            this.viewerWindow.show();
        });
        this.buttPanel.add(viewButton);
        AbstractButton infoButton = BAMutil.makeButtcon((String)"Information", (String)"Show Info", (boolean)false);
        infoButton.addActionListener(e -> {
            Formatter f = new Formatter();
            this.gridNewTable.showInfo(f);
            this.detailTA.setText(f.toString());
            this.detailTA.gotoTop();
            this.detailWindow.show();
        });
        this.buttPanel.add(infoButton);
    }

    private void makeDisplay() {
        this.viewerWindow = new IndependentWindow("Grid2 Viewer", BAMutil.getImage((String)"nj22/NetcdfUI"));
        this.gridViewer = new GridViewer((PreferencesExt)this.prefs.node("CoverageDisplay"), (RootPaneContainer)this.viewerWindow, fileChooser, 800);
        this.gridViewer.addMapBean(new WorldMapBean());
        this.gridViewer.addMapBean(new ShapeFileBean("WorldDetailMap", "Global Detailed Map", "nj22/WorldDetailMap", "/resources/ui/maps/Countries.shp"));
        this.gridViewer.addMapBean(new ShapeFileBean("USDetailMap", "US Detailed Map", "nj22/USMap", "/resources/ui/maps/us_state.shp"));
        this.viewerWindow.setComponent((Component)this.gridViewer);
        Rectangle bounds = (Rectangle)this.prefs.getBean(GRIDNEW_VIEW_FRAME_SIZE, (Object)new Rectangle(77, 22, 700, 900));
        this.viewerWindow.setBounds(bounds);
    }

    @Override
    public boolean process(Object o) {
        String command = (String)o;
        boolean err = false;
        try {
            this.closeOpenFiles();
        }
        catch (IOException ioe) {
            logger.warn("close failed");
        }
        try {
            Formatter errLog = new Formatter();
            this.gridDataset = GridDatasetFactory.openGridDataset((String)command, (Formatter)errLog);
            if (this.gridDataset == null) {
                JOptionPane.showMessageDialog(null, errLog.toString());
                return false;
            }
            this.gridNewTable.setGridDataset(this.gridDataset);
            this.setSelectedItem(command);
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, String.format("GridPanel cant open %s err=%s", command, e.getMessage()));
        }
        catch (Throwable ioe) {
            ioe.printStackTrace();
            StringWriter sw = new StringWriter(5000);
            ioe.printStackTrace(new PrintWriter(sw));
            this.detailTA.setText(sw.toString());
            this.detailWindow.show();
            err = true;
        }
        return !err;
    }

    public void setDataset(GridDataset fd) {
        if (fd == null) {
            return;
        }
        try {
            this.closeOpenFiles();
        }
        catch (IOException ioe) {
            logger.warn("close failed");
        }
        this.gridNewTable.setGridDataset(fd);
        this.setSelectedItem(fd.getLocation());
    }

    public void setNetcdfDataset(NetcdfDataset ncd) {
        if (ncd == null) {
            return;
        }
        try {
            this.closeOpenFiles();
            GridDataset fd = GridDatasetFactory.wrapGridDataset((NetcdfDataset)ncd, (Formatter)new Formatter()).orElse(null);
            this.gridNewTable.setGridDataset(fd);
            this.setSelectedItem(fd.getLocation());
        }
        catch (IOException ioe) {
            logger.warn("close failed");
        }
    }

    @Override
    public void closeOpenFiles() throws IOException {
        if (this.gridDataset != null) {
            this.gridDataset.close();
        }
        this.gridDataset = null;
        this.gridNewTable.clear();
    }

    @Override
    public void save() {
        super.save();
        this.gridNewTable.save();
        if (this.viewerWindow != null) {
            this.prefs.putBeanObject(GRIDNEW_VIEW_FRAME_SIZE, (Object)this.viewerWindow.getBounds());
        }
    }
}

