/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.grid;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Formatter;
import java.util.Optional;
import ucar.array.Array;
import ucar.array.Arrays;
import ucar.array.InvalidRangeException;
import ucar.array.IsMissingEvaluator;
import ucar.array.MinMax;
import ucar.nc2.grid.CoordInterval;
import ucar.nc2.grid.Grid;
import ucar.nc2.grid.GridAxis;
import ucar.nc2.grid.GridAxisPoint;
import ucar.nc2.grid.GridDataset;
import ucar.nc2.grid.GridHorizCoordinateSystem;
import ucar.nc2.grid.GridHorizCurvilinear;
import ucar.nc2.grid.GridReader;
import ucar.nc2.grid.GridReferencedArray;
import ucar.nc2.grid.Grids;
import ucar.nc2.grid.MaterializedCoordinateSystem;
import ucar.ui.grid.ColorScale;
import ucar.ui.grid.DataState;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.util.Format;

public class GridRenderer {
    private static final Color selectionColor = Color.MAGENTA;
    private final boolean drawGrid = true;
    private boolean drawGridLines = true;
    private boolean drawContours;
    private boolean isNewField = true;
    private ColorScale colorScale;
    private ColorScale.MinMaxType dataMinMaxType = ColorScale.MinMaxType.horiz;
    private Projection dataProjection;
    private DataState dataState;
    private GridReferencedArray geodata;
    private ProjectionRect geoSelection;

    public ColorScale getColorScale() {
        return this.colorScale;
    }

    public void setColorScale(ColorScale cs) {
        this.colorScale = cs;
    }

    public void setDataMinMaxType(ColorScale.MinMaxType type) {
        if (type != this.dataMinMaxType) {
            this.dataMinMaxType = type;
        }
    }

    public DataState setGrid(GridDataset gridDataset, Grid grid) {
        this.dataState = new DataState(gridDataset, grid);
        this.isNewField = true;
        return this.dataState;
    }

    void setDataProjection(Projection dataProjection) {
        this.dataProjection = dataProjection;
    }

    public void setGeoSelectionMode(boolean geoSelectionMode) {
        if (!geoSelectionMode) {
            this.geoSelection = null;
            this.dataState.setProjRect(null);
        }
    }

    public void setDrawGridLines(boolean drawGrid) {
        this.drawGridLines = drawGrid;
    }

    public void setDrawContours(boolean drawContours) {
        this.drawContours = drawContours;
    }

    public void setDrawContourLabels(boolean drawContourLabels) {
    }

    public void setGeoSelection(ProjectionRect geoSelection) {
        this.geoSelection = geoSelection;
        this.dataState.setProjRect(geoSelection);
    }

    public String getXYvalueStr(ProjectionPoint loc) {
        if (this.dataState.grid == null || this.geodata == null || this.dataState.mcs == null) {
            return "";
        }
        GridHorizCoordinateSystem hcs = this.dataState.mcs.getHorizCoordinateSystem();
        Optional opt = hcs.findXYindexFromCoord(loc.getX(), loc.getY(), this.dataState.index);
        if (opt.isEmpty()) {
            return "outside data grid";
        }
        GridHorizCoordinateSystem.CoordReturn cr = (GridHorizCoordinateSystem.CoordReturn)opt.get();
        try {
            Array array = Arrays.reduce((Array)this.geodata.data());
            if (!array.contains(new int[]{cr.yindex, cr.xindex})) {
                return String.format("invalid index (%d,%d)", cr.yindex, cr.xindex);
            }
            double dataValue = ((Number)array.get(new int[]{cr.yindex, cr.xindex})).doubleValue();
            this.dataState.index = new int[]{cr.yindex, cr.xindex};
            return this.makeXYZvalueStr(dataValue, cr);
        }
        catch (Exception e) {
            return e.getMessage() + " error on " + cr;
        }
    }

    private String makeXYZvalueStr(double value, GridHorizCoordinateSystem.CoordReturn cr) {
        String val = this.dataState.grid.isMissing(value) ? "missing value" : Format.d((double)value, (int)6);
        Formatter sbuff = new Formatter();
        sbuff.format("%s %s", val, this.dataState.grid.getUnits());
        sbuff.format(" @ (%f,%f)", cr.xcoord, cr.ycoord);
        sbuff.format("  [%d,%d]", cr.xindex, cr.yindex);
        return sbuff.toString();
    }

    private GridReferencedArray readHSlice() throws IOException, InvalidRangeException {
        if (!this.dataState.hasChanged()) {
            return this.geodata;
        }
        GridReader reader = this.dataState.grid.getReader();
        if (this.dataState.vertCoord != null) {
            reader.setVertCoord(this.dataState.vertCoord);
        }
        if (this.dataState.timeCoord != null) {
            reader.setTimeOffsetCoord(this.dataState.timeCoord);
        }
        if (this.dataState.runtimeCoord != null) {
            reader.setRunTime(this.dataState.runtimeCoord.runtime);
        }
        if (this.dataState.ensCoord != null) {
            reader.setEnsCoord((Object)this.dataState.ensCoord);
        }
        if (this.dataState.projRect != null) {
            reader.setProjectionBoundingBox(this.dataState.projRect);
        }
        if (this.dataState.horizStride != 1) {
            reader.setHorizStride(this.dataState.horizStride);
        }
        this.geodata = reader.read();
        this.dataState.saveState();
        this.dataState.mcs = this.geodata.getMaterializedCoordinateSystem();
        System.out.printf("readHSlice %s done%n", this.dataState.grid.getName());
        return this.geodata;
    }

    private void setColorScaleParams() throws IOException, InvalidRangeException {
        if (this.dataMinMaxType == ColorScale.MinMaxType.hold && !this.isNewField) {
            return;
        }
        this.isNewField = false;
        GridReferencedArray dataArr = this.readHSlice();
        if (dataArr != null) {
            MinMax minmax = Arrays.getMinMaxSkipMissingData((Array)dataArr.data(), (IsMissingEvaluator)this.dataState.grid);
            this.colorScale.setMinMax(minmax.min(), minmax.max());
            this.colorScale.setGeoGrid((IsMissingEvaluator)this.dataState.grid);
        }
    }

    public void renderPlanView(Graphics2D g, AffineTransform dFromN) throws IOException, InvalidRangeException {
        if (this.dataState.grid == null || this.colorScale == null) {
            return;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        GridReferencedArray dataArr = this.readHSlice();
        if (dataArr == null) {
            return;
        }
        this.setColorScaleParams();
        GridHorizCoordinateSystem hcs = this.dataState.gcs.getHorizCoordinateSystem();
        if (!hcs.isCurvilinear()) {
            this.drawGridHoriz(g, dataArr);
        } else {
            this.drawGridCurvilinear(g, dataArr);
        }
        if (this.drawGridLines) {
            hcs = dataArr.getMaterializedCoordinateSystem().getHorizCoordinateSystem();
            if (hcs.isCurvilinear()) {
                this.drawGridLinesCurvilinear(g, (GridHorizCurvilinear)hcs);
            } else {
                this.drawGridLines(g, hcs);
            }
        }
        if (this.geoSelection != null) {
            this.drawProjectionRect(g, selectionColor, this.geoSelection);
        }
    }

    private void drawProjectionRect(Graphics2D g, Color color, ProjectionRect projRect) {
        g.setColor(color);
        Rectangle2D.Double rect = new Rectangle2D.Double(projRect.getMinX(), projRect.getMinY(), projRect.getWidth(), projRect.getHeight());
        g.draw(rect);
    }

    private void drawLatlonRect(Graphics2D g, Color color, LatLonRect latLonRect) {
        g.setColor(color);
        Rectangle2D.Double rect = new Rectangle2D.Double(latLonRect.getLonMin(), latLonRect.getLatMin(), latLonRect.getWidth(), latLonRect.getHeight());
        g.draw(rect);
    }

    private void drawGridHoriz(Graphics2D g, GridReferencedArray referencedArray) {
        MaterializedCoordinateSystem msys = referencedArray.getMaterializedCoordinateSystem();
        Array data = referencedArray.data();
        data = Arrays.reduce((Array)data);
        GridAxisPoint xaxis = msys.getXHorizAxis();
        GridAxisPoint yaxis = msys.getYHorizAxis();
        if (data.getRank() != 2) {
            System.out.printf("drawGridHorizRegular Rank equals %d, must be 2%n", data.getRank());
            return;
        }
        int nx = xaxis.getNominalSize();
        int ny = yaxis.getNominalSize();
        this.colorScale.resetHist();
        for (Number number : data) {
            this.colorScale.getIndexFromValue(number.doubleValue());
        }
        int modeColor = this.colorScale.getHistMax();
        MinMax xminmax = Grids.getCoordEdgeMinMax((GridAxis)xaxis);
        MinMax yminmax = Grids.getCoordEdgeMinMax((GridAxis)yaxis);
        this.drawRect(g, this.colorScale.getColor(modeColor), xminmax.min(), xminmax.max(), yminmax.min(), yminmax.max(), this.dataProjection.isLatLon());
        for (int y = 0; y < ny; ++y) {
            CoordInterval yintv = yaxis.getCoordInterval(y);
            double ybeg = yintv.start();
            double yend = yintv.end();
            int lastColor = 0;
            int run = 0;
            int xbeg = 0;
            for (int x = 0; x < nx; ++x) {
                double val = ((Number)data.get(new int[]{y, x})).doubleValue();
                int thisColor = this.colorScale.getIndexFromValue(val);
                if (run == 0 || lastColor == thisColor) {
                    ++run;
                } else {
                    if (lastColor != modeColor) {
                        this.drawRect(g, this.colorScale.getColor(lastColor), xaxis.getCoordInterval(xbeg).start(), xaxis.getCoordInterval(x).end(), ybeg, yend, this.dataProjection.isLatLon());
                    }
                    xbeg = x;
                }
                lastColor = thisColor;
            }
            if (lastColor == modeColor) continue;
            this.drawRect(g, this.colorScale.getColor(lastColor), xaxis.getCoordInterval(xbeg).start(), xaxis.getCoordInterval(xaxis.getNominalSize() - 1).end(), ybeg, yend, this.dataProjection.isLatLon());
        }
    }

    private int drawRect(Graphics2D g, Color color, double w1, double w2, double h1, double h2, boolean useLatlon) {
        if (useLatlon) {
            return this.drawRectLatLon(g, color, w1, h1, w2, h2);
        }
        g.setColor(color);
        double wmin = Math.min(w1, w2);
        double hmin = Math.min(h1, h2);
        double width = Math.abs(w1 - w2);
        double height = Math.abs(h1 - h2);
        Rectangle2D.Double rect = new Rectangle2D.Double(wmin, hmin, width, height);
        g.fill(rect);
        return 1;
    }

    private int drawRectLatLon(Graphics2D g, Color color, double lon1, double lat1, double lon2, double lat2) {
        g.setColor(color);
        LatLonProjection projectll = (LatLonProjection)this.dataProjection;
        int count = 0;
        ProjectionRect[] rects = projectll.latLonToProjRect(lat1, lon1, lat2, lon2);
        for (int i = 0; i < 2; ++i) {
            if (null == rects[i]) continue;
            ProjectionRect r2 = rects[i];
            Rectangle2D.Double r = new Rectangle2D.Double(r2.getMinX(), r2.getMinY(), r2.getWidth(), r2.getHeight());
            g.fill(r);
            ++count;
        }
        return count;
    }

    private void drawGridCurvilinear(Graphics2D g, GridReferencedArray referencedArray) {
        GridHorizCoordinateSystem hcsys2D = referencedArray.getMaterializedCoordinateSystem().getHorizCoordinateSystem();
        Array data = referencedArray.data();
        data = Arrays.reduce((Array)data);
        GeneralPath gp = new GeneralPath(0, 5);
        for (GridHorizCoordinateSystem.CellBounds edge : hcsys2D.cells()) {
            gp.reset();
            gp.moveTo((float)edge.ll.xcoord, (float)edge.ll.ycoord);
            gp.lineTo((float)edge.lr.xcoord, (float)edge.lr.ycoord);
            gp.lineTo((float)edge.ur.xcoord, (float)edge.ur.ycoord);
            gp.lineTo((float)edge.ul.xcoord, (float)edge.ul.ycoord);
            double val = ((Number)data.get(new int[]{edge.yindex, edge.xindex})).doubleValue();
            int colorIndex = this.colorScale.getIndexFromValue(val);
            g.setColor(this.colorScale.getColor(colorIndex));
            g.fill(gp);
        }
    }

    private void drawGridLinesCurvilinear(Graphics2D g, GridHorizCurvilinear hcs) {
        int x;
        int y;
        Array latEdge = hcs.getLatEdges();
        Array lonEdge = hcs.getLonEdges();
        GeneralPath gp = new GeneralPath(0, 100);
        g.setColor(Color.BLACK);
        int[] shape = latEdge.getShape();
        int nrows = shape[0];
        int ncols = shape[1];
        for (y = 0; y < nrows; y += 10) {
            gp.reset();
            for (int x2 = 0; x2 < ncols; ++x2) {
                if (x2 == 0) {
                    gp.moveTo(((Double)lonEdge.get(new int[]{y, x2})).floatValue(), ((Double)latEdge.get(new int[]{y, x2})).floatValue());
                    continue;
                }
                gp.lineTo(((Double)lonEdge.get(new int[]{y, x2})).floatValue(), ((Double)latEdge.get(new int[]{y, x2})).floatValue());
            }
            g.draw(gp);
        }
        gp.reset();
        for (x = 0; x < ncols; ++x) {
            if (x == 0) {
                gp.moveTo(((Double)lonEdge.get(new int[]{nrows - 1, x})).floatValue(), ((Double)latEdge.get(new int[]{nrows - 1, x})).floatValue());
                continue;
            }
            gp.lineTo(((Double)lonEdge.get(new int[]{nrows - 1, x})).floatValue(), ((Double)latEdge.get(new int[]{nrows - 1, x})).floatValue());
        }
        g.draw(gp);
        for (x = 0; x < ncols; x += 10) {
            gp.reset();
            for (int y2 = 0; y2 < nrows; ++y2) {
                if (y2 == 0) {
                    gp.moveTo(((Double)lonEdge.get(new int[]{y2, x})).floatValue(), ((Double)latEdge.get(new int[]{y2, x})).floatValue());
                    continue;
                }
                gp.lineTo(((Double)lonEdge.get(new int[]{y2, x})).floatValue(), ((Double)latEdge.get(new int[]{y2, x})).floatValue());
            }
            g.draw(gp);
        }
        gp.reset();
        for (y = 0; y < nrows; ++y) {
            if (y == 0) {
                gp.moveTo(((Double)lonEdge.get(new int[]{y, ncols - 1})).floatValue(), ((Double)latEdge.get(new int[]{y, ncols - 1})).floatValue());
                continue;
            }
            gp.lineTo(((Double)lonEdge.get(new int[]{y, ncols - 1})).floatValue(), ((Double)latEdge.get(new int[]{y, ncols - 1})).floatValue());
        }
        g.draw(gp);
    }

    private void drawGridLines(Graphics2D g, GridHorizCoordinateSystem hcs) {
        int x;
        GridAxisPoint xaxis = hcs.getXHorizAxis();
        GridAxisPoint yaxis = hcs.getYHorizAxis();
        GeneralPath gp = new GeneralPath(0, 100);
        g.setColor(Color.BLACK);
        int ny = yaxis.getNominalSize();
        int nx = xaxis.getNominalSize();
        for (int y = 0; y < ny; y += 10) {
            gp.reset();
            CoordInterval yintv = yaxis.getCoordInterval(y);
            for (int x2 = 0; x2 < nx; ++x2) {
                CoordInterval xintv = xaxis.getCoordInterval(x2);
                if (x2 == 0) {
                    gp.moveTo(xintv.start(), yintv.start());
                } else {
                    gp.lineTo(xintv.start(), yintv.start());
                }
                if (x2 != nx - 1) continue;
                gp.lineTo(xintv.end(), yintv.start());
            }
            g.draw(gp);
        }
        gp.reset();
        CoordInterval yintvLast = yaxis.getCoordInterval(ny - 1);
        for (x = 0; x < nx; ++x) {
            CoordInterval xintv = xaxis.getCoordInterval(x);
            if (x == 0) {
                gp.moveTo(xintv.start(), yintvLast.end());
            } else {
                gp.lineTo(xintv.start(), yintvLast.end());
            }
            if (x != nx - 1) continue;
            gp.lineTo(xintv.end(), yintvLast.end());
        }
        g.draw(gp);
        for (x = 0; x < nx; x += 10) {
            gp.reset();
            CoordInterval xintv = xaxis.getCoordInterval(x);
            for (int y = 0; y < ny; ++y) {
                CoordInterval yintv = yaxis.getCoordInterval(y);
                if (y == 0) {
                    gp.moveTo(xintv.start(), yintv.start());
                } else {
                    gp.lineTo(xintv.start(), yintv.start());
                }
                if (y != ny - 1) continue;
                gp.lineTo(xintv.start(), yintv.end());
            }
            g.draw(gp);
        }
        gp.reset();
        CoordInterval xintvLast = xaxis.getCoordInterval(nx - 1);
        for (int y = 0; y < ny; ++y) {
            CoordInterval yintv = yaxis.getCoordInterval(y);
            if (y == 0) {
                gp.moveTo(xintvLast.end(), yintv.start());
            } else {
                gp.lineTo(xintvLast.end(), yintv.start());
            }
            if (y != ny - 1) continue;
            gp.lineTo(xintvLast.end(), yintv.end());
        }
        g.draw(gp);
    }
}

