/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.grid;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.annotation.Nullable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EtchedBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.array.InvalidRangeException;
import ucar.nc2.calendar.CalendarDate;
import ucar.nc2.grid.Grid;
import ucar.nc2.grid.GridAxis;
import ucar.nc2.grid.GridAxisPoint;
import ucar.nc2.grid.GridDataset;
import ucar.nc2.grid.GridHorizCoordinateSystem;
import ucar.nc2.grid.GridTimeCoordinateSystem;
import ucar.ui.event.ActionCoordinator;
import ucar.ui.event.ActionSourceListener;
import ucar.ui.event.ActionValueEvent;
import ucar.ui.geoloc.NavigatedPanel;
import ucar.ui.gis.MapBean;
import ucar.ui.grid.ColorScale;
import ucar.ui.grid.DataState;
import ucar.ui.grid.GridNewTable;
import ucar.ui.grid.GridRenderer;
import ucar.ui.prefs.Debug;
import ucar.ui.util.NamedObject;
import ucar.ui.util.NamedObjects;
import ucar.ui.util.Renderer;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.FileManager;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.MFlowLayout;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.SuperComboBox;
import ucar.ui.widget.TextHistoryPane;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.util.prefs.PreferencesExt;

public class GridViewer
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(GridViewer.class);
    private static final int DELAY_DRAW_AFTER_DATA_EVENT = 250;
    private static final String LastMapAreaName = "LastMapArea";
    private static final String LastProjectionName = "LastProjection";
    private static final String ColorScaleName = "ColorScale";
    private final PreferencesExt store;
    private ColorScale colorScale;
    private ColorScale.Panel colorScalePanel;
    private List<Chooser> choosers;
    private SuperComboBox fieldChooser;
    private SuperComboBox levelChooser;
    private SuperComboBox timeChooser;
    private SuperComboBox ensembleChooser;
    private SuperComboBox runtimeChooser;
    private JLabel dataValueLabel;
    private NavigatedPanel navPanel;
    private TextHistoryPane datasetInfoTA;
    private JPanel drawingPanel;
    private JComboBox<ColorScale.MinMaxType> csDataMinMax;
    private PopupMenu mapBeanMenu;
    private JSpinner strideSpinner;
    private final JLabel datasetNameLabel = new JLabel();
    private IndependentWindow infoWindow;
    private JPanel fieldPanel;
    private JPanel toolPanel;
    private JToolBar navToolbar;
    private JToolBar moveToolbar;
    private AbstractAction navToolbarAction;
    private AbstractAction moveToolbarAction;
    private AbstractAction redrawAction;
    private AbstractAction showDatasetInfoAction;
    private AbstractAction minmaxHorizAction;
    private AbstractAction minmaxLogAction;
    private AbstractAction minmaxHoldAction;
    private AbstractAction fieldLoopAction;
    private AbstractAction levelLoopAction;
    private AbstractAction timeLoopAction;
    private AbstractAction runtimeLoopAction;
    private AbstractAction dataProjectionAction;
    private AbstractAction drawBBAction;
    private AbstractAction showGridAction;
    private AbstractAction showContoursAction;
    private AbstractAction showContourLabelsAction;
    private AbstractAction drawHorizAction;
    private AbstractAction drawVertAction;
    private DataState dataState;
    private GridDataset gridDataset;
    private Grid currentField;
    private List<NamedObject> timeNames;
    private boolean drawHorizOn = true;
    private boolean drawVertOn;
    private boolean eventsOK = true;
    private final Color mapColor = Color.black;
    private int mapBeanCount;
    private final AffineTransform atI = new AffineTransform();
    private Renderer mapRenderer;
    private GridRenderer gridRenderer;
    private Timer redrawTimer;
    private boolean startOK = true;

    public GridViewer(PreferencesExt pstore, RootPaneContainer root, FileManager fileChooser, int defaultHeight) {
        this.store = pstore;
        try {
            this.choosers = new ArrayList<Chooser>();
            this.fieldChooser = new SuperComboBox(root, "field", true, null);
            this.choosers.add(new Chooser("field", this.fieldChooser, true));
            this.runtimeChooser = new SuperComboBox(root, "runtime", false, null);
            this.choosers.add(new Chooser("runtime", this.runtimeChooser, false));
            this.timeChooser = new SuperComboBox(root, "time", false, null);
            this.choosers.add(new Chooser("time", this.timeChooser, false));
            this.levelChooser = new SuperComboBox(root, "level", false, null);
            this.choosers.add(new Chooser("level", this.levelChooser, false));
            this.ensembleChooser = new SuperComboBox(root, "ensemble", false, null);
            this.choosers.add(new Chooser("ensemble", this.ensembleChooser, false));
            Object bean = this.store.getBean(ColorScaleName, null);
            this.colorScale = !(bean instanceof ColorScale) ? new ColorScale("default") : (ColorScale)this.store.getBean(ColorScaleName, null);
            this.colorScalePanel = new ColorScale.Panel(this, this.colorScale);
            this.csDataMinMax = new JComboBox<ColorScale.MinMaxType>(ColorScale.MinMaxType.values());
            this.csDataMinMax.setToolTipText("ColorScale Min/Max setting");
            this.csDataMinMax.addActionListener(e -> {
                this.gridRenderer.setDataMinMaxType((ColorScale.MinMaxType)((Object)((Object)this.csDataMinMax.getSelectedItem())));
                this.redrawLater();
            });
            this.gridRenderer = new GridRenderer();
            this.gridRenderer.setColorScale(this.colorScale);
            this.strideSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 100, 1));
            this.strideSpinner.addChangeListener(e -> {
                this.dataState.horizStride = (Integer)this.strideSpinner.getValue();
            });
            this.makeActionsDataset();
            this.makeActionsToolbars();
            this.makeActions();
            this.makeEventManagement();
            this.toolPanel = new JPanel();
            this.toolPanel.setBorder(new EtchedBorder());
            this.toolPanel.setLayout((LayoutManager)new MFlowLayout(0, 0, 0));
            JMenu dataMenu = new JMenu("Dataset");
            dataMenu.setMnemonic('D');
            JMenu configMenu = new JMenu("Configure");
            configMenu.setMnemonic('C');
            JMenu toolMenu = new JMenu("Controls");
            toolMenu.setMnemonic('T');
            JMenuBar menuBar = new JMenuBar();
            menuBar.add(dataMenu);
            menuBar.add(configMenu);
            menuBar.add(toolMenu);
            this.toolPanel.add(menuBar);
            this.fieldPanel = new JPanel();
            this.fieldPanel.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.fieldPanel.setLayout(new FlowLayout(0, 0, 0));
            this.toolPanel.add(this.fieldPanel);
            this.toolPanel.add(this.strideSpinner);
            BAMutil.addActionToContainer((Container)this.toolPanel, (Action)this.drawHorizAction);
            BAMutil.addActionToContainer((Container)this.toolPanel, (Action)this.drawVertAction);
            this.mapBeanMenu = MapBean.makeMapSelectButton();
            this.toolPanel.add(this.mapBeanMenu.getParentComponent());
            this.navPanel = new NavigatedPanel();
            this.navPanel.setLayout(new FlowLayout());
            ProjectionRect ma = (ProjectionRect)this.store.getBean(LastMapAreaName, null);
            if (ma != null) {
                this.navPanel.setMapArea(ma);
            }
            this.navToolbar = this.navPanel.getNavToolBar();
            this.moveToolbar = this.navPanel.getMoveToolBar();
            if (((Boolean)this.navToolbarAction.getValue("state")).booleanValue()) {
                this.toolPanel.add(this.navToolbar);
            }
            if (((Boolean)this.moveToolbarAction.getValue("state")).booleanValue()) {
                this.toolPanel.add(this.moveToolbar);
            }
            this.makeNavPanelWiring();
            this.addActionsToMenus(dataMenu, configMenu, toolMenu);
            BAMutil.addActionToContainer((Container)this.toolPanel, (Action)this.navPanel.setReferenceAction);
            BAMutil.addActionToContainer((Container)this.toolPanel, (Action)this.showGridAction);
            BAMutil.addActionToContainer((Container)this.toolPanel, (Action)this.drawBBAction);
            BAMutil.addActionToContainer((Container)this.toolPanel, (Action)this.redrawAction);
            this.drawingPanel = new JPanel(new BorderLayout());
            JPanel statusPanel = new JPanel(new BorderLayout());
            statusPanel.setBorder(new EtchedBorder());
            JLabel positionLabel = new JLabel("position");
            positionLabel.setToolTipText("position at cursor");
            this.dataValueLabel = new JLabel("data value", 0);
            this.dataValueLabel.setToolTipText("data value (double click on grid)");
            statusPanel.add((Component)positionLabel, "West");
            statusPanel.add((Component)this.dataValueLabel, "Center");
            this.navPanel.setPositionLabel(positionLabel);
            JPanel westPanel = new JPanel(new BorderLayout());
            westPanel.add((Component)this.colorScalePanel, "Center");
            westPanel.add(this.csDataMinMax, "North");
            JPanel northPanel = new JPanel();
            northPanel.setLayout(new BorderLayout());
            northPanel.add((Component)this.datasetNameLabel, "North");
            northPanel.add((Component)this.toolPanel, "South");
            this.setLayout(new BorderLayout());
            this.add((Component)northPanel, "North");
            this.add((Component)statusPanel, "South");
            this.add((Component)westPanel, "West");
            this.add((Component)this.drawingPanel, "Center");
            this.setDrawHorizAndVert(this.drawHorizOn, this.drawVertOn);
            this.redrawTimer = new Timer(0, e -> {
                SwingUtilities.invokeLater(() -> this.draw(false));
                this.redrawTimer.stop();
            });
            this.redrawTimer.setInitialDelay(250);
            this.redrawTimer.setRepeats(false);
        }
        catch (Exception e2) {
            System.out.println("UI creation failed");
            e2.printStackTrace();
        }
    }

    private void makeActionsDataset() {
        this.redrawAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GridViewer.this.repaint();
                GridViewer.this.start(true);
                GridViewer.this.draw(true);
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.redrawAction, (String)"alien", (String)"RedRaw", (boolean)false, (int)87, (int)0);
        this.showDatasetInfoAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GridViewer.this.infoWindow == null) {
                    GridViewer.this.datasetInfoTA = new TextHistoryPane();
                    GridViewer.this.infoWindow = new IndependentWindow("Dataset Information", BAMutil.getImage((String)"nj22/GDVs"), (Component)GridViewer.this.datasetInfoTA);
                    GridViewer.this.infoWindow.setSize(700, 700);
                    GridViewer.this.infoWindow.setLocation(100, 100);
                }
                GridViewer.this.datasetInfoTA.clear();
                if (GridViewer.this.gridDataset != null) {
                    Formatter f = new Formatter();
                    GridViewer.this.gridDataset.toString(f);
                    GridViewer.this.datasetInfoTA.appendLine(f.toString());
                } else {
                    GridViewer.this.datasetInfoTA.appendLine("No coverageDataset loaded");
                }
                GridViewer.this.datasetInfoTA.gotoTop();
                GridViewer.this.infoWindow.show();
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.showDatasetInfoAction, (String)"Information", (String)"Show info...", (boolean)false, (int)83, (int)-1);
        this.minmaxHorizAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GridViewer.this.csDataMinMax.setSelectedItem((Object)ColorScale.MinMaxType.horiz);
                GridViewer.this.setDataMinMaxType(ColorScale.MinMaxType.horiz);
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.minmaxHorizAction, null, (String)"Horizontal plane", (boolean)false, (int)72, (int)0);
        this.minmaxLogAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GridViewer.this.csDataMinMax.setSelectedItem((Object)ColorScale.MinMaxType.log);
                GridViewer.this.setDataMinMaxType(ColorScale.MinMaxType.log);
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.minmaxLogAction, null, (String)"log horiz plane", (boolean)false, (int)86, (int)0);
        this.minmaxHoldAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GridViewer.this.csDataMinMax.setSelectedItem((Object)ColorScale.MinMaxType.hold);
                GridViewer.this.setDataMinMaxType(ColorScale.MinMaxType.hold);
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.minmaxHoldAction, null, (String)"Hold scale constant", (boolean)false, (int)67, (int)0);
        this.fieldLoopAction = new LoopControlAction(this.fieldChooser);
        this.levelLoopAction = new LoopControlAction(this.levelChooser);
        this.timeLoopAction = new LoopControlAction(this.timeChooser);
        this.runtimeLoopAction = new LoopControlAction(this.runtimeChooser);
    }

    private void makeActionsToolbars() {
        this.navToolbarAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                if (state.booleanValue()) {
                    GridViewer.this.toolPanel.add(GridViewer.this.navToolbar);
                } else {
                    GridViewer.this.toolPanel.remove(GridViewer.this.navToolbar);
                }
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.navToolbarAction, (String)"MagnifyPlus", (String)"show Navigate toolbar", (boolean)true, (int)77, (int)0);
        this.navToolbarAction.putValue("state", this.store.getBoolean("navToolbarAction", true));
        this.moveToolbarAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                if (state.booleanValue()) {
                    GridViewer.this.toolPanel.add(GridViewer.this.moveToolbar);
                } else {
                    GridViewer.this.toolPanel.remove(GridViewer.this.moveToolbar);
                }
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.moveToolbarAction, (String)"Up", (String)"show Move toolbar", (boolean)true, (int)77, (int)0);
        this.moveToolbarAction.putValue("state", this.store.getBoolean("moveToolbarAction", true));
    }

    private void makeActions() {
        this.drawBBAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                GridViewer.this.navPanel.setGeoSelectionMode(state);
                GridViewer.this.gridRenderer.setGeoSelectionMode(state);
                GridViewer.this.draw(true);
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.drawBBAction, (String)"nj22/Geoselect", (String)"select bounding box", (boolean)true, (int)66, (int)0);
        this.drawBBAction.putValue("state", false);
        this.drawHorizAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GridViewer.this.drawHorizOn = (Boolean)this.getValue("state");
                GridViewer.this.setDrawHorizAndVert(GridViewer.this.drawHorizOn, GridViewer.this.drawVertOn);
                GridViewer.this.draw(false);
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.drawHorizAction, (String)"nj22/DrawHoriz", (String)"draw horizontal", (boolean)true, (int)72, (int)0);
        boolean state = this.store.getBoolean("drawHorizAction", true);
        this.drawHorizAction.putValue("state", state);
        this.drawHorizOn = state;
        this.drawVertAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GridViewer.this.drawVertOn = (Boolean)this.getValue("state");
                GridViewer.this.setDrawHorizAndVert(GridViewer.this.drawHorizOn, GridViewer.this.drawVertOn);
                GridViewer.this.draw(false);
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.drawVertAction, (String)"nj22/DrawVert", (String)"draw vertical", (boolean)true, (int)86, (int)0);
        state = this.store.getBoolean("drawVertAction", false);
        this.drawVertAction.putValue("state", state);
        this.drawVertOn = state;
        this.showGridAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                GridViewer.this.gridRenderer.setDrawGridLines(state);
                GridViewer.this.draw(false);
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.showGridAction, (String)"nj22/Grid", (String)"show grid lines", (boolean)true, (int)71, (int)0);
        state = this.store.getBoolean("showGridAction", false);
        this.showGridAction.putValue("state", state);
        this.gridRenderer.setDrawGridLines(state);
        this.showContoursAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                GridViewer.this.gridRenderer.setDrawContours(state);
                GridViewer.this.draw(false);
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.showContoursAction, (String)"nj22/Contours", (String)"show contours", (boolean)true, (int)67, (int)0);
        state = this.store.getBoolean("showContoursAction", false);
        this.showContoursAction.putValue("state", state);
        this.gridRenderer.setDrawContours(state);
        this.showContourLabelsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                GridViewer.this.gridRenderer.setDrawContourLabels(state);
                GridViewer.this.draw(false);
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.showContourLabelsAction, (String)"nj22/ContourLabels", (String)"show contour labels", (boolean)true, (int)76, (int)0);
        state = this.store.getBoolean("showContourLabelsAction", false);
        this.showContourLabelsAction.putValue("state", state);
        this.gridRenderer.setDrawContourLabels(state);
    }

    private void makeEventManagement() {
        String actionName = "field";
        ActionCoordinator fieldCoordinator = new ActionCoordinator(actionName);
        fieldCoordinator.addActionSourceListener(this.fieldChooser.getActionSourceListener());
        ActionSourceListener fieldSource = new ActionSourceListener(actionName){

            public void actionPerformed(ActionValueEvent e) {
                if (GridViewer.this.setField(e.getValue())) {
                    if (e.getActionCommand().equals("redrawImmediate")) {
                        GridViewer.this.draw(true);
                    } else {
                        GridViewer.this.redrawLater();
                    }
                }
            }
        };
        fieldCoordinator.addActionSourceListener(fieldSource);
        actionName = "level";
        ActionCoordinator levelCoordinator = new ActionCoordinator(actionName);
        levelCoordinator.addActionSourceListener(this.levelChooser.getActionSourceListener());
        ActionSourceListener levelSource = new ActionSourceListener(actionName){

            public void actionPerformed(ActionValueEvent e) {
                NamedObject selected = (NamedObject)GridViewer.this.levelChooser.getSelectedObject();
                if (selected != null && GridViewer.this.dataState.setVertCoord(selected.getValue())) {
                    if (e.getActionCommand().equals("redrawImmediate")) {
                        GridViewer.this.draw(true);
                    } else {
                        GridViewer.this.redrawLater();
                    }
                }
            }
        };
        levelCoordinator.addActionSourceListener(levelSource);
        actionName = "time";
        ActionCoordinator timeCoordinator = new ActionCoordinator(actionName);
        timeCoordinator.addActionSourceListener(this.timeChooser.getActionSourceListener());
        ActionSourceListener timeSource = new ActionSourceListener(actionName){

            public void actionPerformed(ActionValueEvent e) {
                NamedObject selected = (NamedObject)GridViewer.this.timeChooser.getSelectedObject();
                if (GridViewer.this.dataState.setTimeCoord(selected.getValue()) && selected != null) {
                    if (e.getActionCommand().equals("redrawImmediate")) {
                        GridViewer.this.draw(true);
                    } else {
                        GridViewer.this.redrawLater();
                    }
                }
            }
        };
        timeCoordinator.addActionSourceListener(timeSource);
        actionName = "runtime";
        ActionCoordinator runtimeCoordinator = new ActionCoordinator(actionName);
        runtimeCoordinator.addActionSourceListener(this.runtimeChooser.getActionSourceListener());
        ActionSourceListener runtimeSource = new ActionSourceListener(actionName){

            public void actionPerformed(ActionValueEvent e) {
                NamedObject selected = (NamedObject)GridViewer.this.runtimeChooser.getSelectedObject();
                if (selected != null && GridViewer.this.dataState.setRuntimeCoord(selected.getValue())) {
                    if (GridViewer.this.dataState.tcs != null) {
                        GridViewer.this.dataState.toaxis = GridViewer.this.dataState.tcs.getTimeOffsetAxis(GridViewer.this.dataState.runtimeCoord.runtimeIdx);
                        GridViewer.this.timeNames = NamedObjects.getCoordNames(GridViewer.this.dataState.toaxis);
                        GridViewer.this.timeChooser.setCollection(GridViewer.this.timeNames.iterator(), true);
                        NamedObject no = GridViewer.this.findNamedObject(GridViewer.this.timeNames, GridViewer.this.dataState.timeCoord);
                        if (no == null) {
                            GridViewer.this.dataState.setTimeCoord(GridViewer.this.timeNames.get(0).getValue());
                            GridViewer.this.timeChooser.setSelectedByIndex(0);
                        } else {
                            GridViewer.this.timeChooser.setSelectedByValue((Object)no);
                        }
                    }
                    if (e.getActionCommand().equals("redrawImmediate")) {
                        GridViewer.this.draw(true);
                    } else {
                        GridViewer.this.redrawLater();
                    }
                }
            }
        };
        runtimeCoordinator.addActionSourceListener(runtimeSource);
        actionName = "ensemble";
        ActionCoordinator ensembleCoordinator = new ActionCoordinator(actionName);
        ensembleCoordinator.addActionSourceListener(this.ensembleChooser.getActionSourceListener());
        ActionSourceListener ensembleSource = new ActionSourceListener(actionName){

            public void actionPerformed(ActionValueEvent e) {
                NamedObject selected = (NamedObject)GridViewer.this.ensembleChooser.getSelectedObject();
                if (selected != null && GridViewer.this.dataState.setEnsCoord(selected.getValue())) {
                    if (e.getActionCommand().equals("redrawImmediate")) {
                        GridViewer.this.draw(true);
                    } else {
                        GridViewer.this.redrawLater();
                    }
                }
            }
        };
        ensembleCoordinator.addActionSourceListener(ensembleSource);
    }

    private void makeNavPanelWiring() {
        this.navPanel.addNewProjectionListener(e -> {
            if (this.eventsOK && this.mapRenderer != null) {
                this.mapRenderer.setProjection(e.getProjection());
                this.gridRenderer.setDataProjection(e.getProjection());
                this.drawH(false);
            }
        });
        this.navPanel.addNewMapAreaListener(e -> {
            if (Debug.isSet((String)"event/NewMapArea")) {
                System.out.println("Controller got NewMapAreaEvent " + this.navPanel.getMapArea());
            }
            this.drawH(false);
        });
        this.navPanel.addCursorMoveEventListener(e -> {
            String valueS = this.gridRenderer.getXYvalueStr(e.getLocation());
            this.dataValueLabel.setText(valueS);
        });
        this.navPanel.addGeoSelectionListener(e -> {
            this.gridRenderer.setGeoSelection(e.getProjectionRect());
            this.drawH(false);
        });
    }

    private int findIndexFromName(List<NamedObject> list, String name) {
        for (int idx = 0; idx < list.size(); ++idx) {
            NamedObject no = list.get(idx);
            if (!name.equals(no.getName())) continue;
            return idx;
        }
        log.error("findIndexFromName cant find " + name);
        return -1;
    }

    public void save() {
        this.store.putBoolean("navToolbarAction", ((Boolean)this.navToolbarAction.getValue("state")).booleanValue());
        this.store.putBoolean("moveToolbarAction", ((Boolean)this.moveToolbarAction.getValue("state")).booleanValue());
        this.store.putBeanObject(LastMapAreaName, (Object)this.navPanel.getMapArea());
        this.store.putBeanObject(LastProjectionName, (Object)this.navPanel.getProjectionImpl());
        this.store.putBeanObject(ColorScaleName, (Object)this.colorScale);
        this.store.putBoolean("showGridAction", ((Boolean)this.showGridAction.getValue("state")).booleanValue());
        this.store.putBoolean("showContoursAction", ((Boolean)this.showContoursAction.getValue("state")).booleanValue());
        this.store.putBoolean("showContourLabelsAction", ((Boolean)this.showContourLabelsAction.getValue("state")).booleanValue());
    }

    public void addMapBean(MapBean mb) {
        this.mapBeanMenu.addAction(mb.getActionDesc(), mb.getIcon(), mb.getAction());
        if (this.mapBeanCount == 0) {
            this.setMapRenderer(mb.getRenderer());
        }
        ++this.mapBeanCount;
        mb.addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("Renderer")) {
                this.setMapRenderer((Renderer)e.getNewValue());
            }
        });
    }

    void setMapRenderer(Renderer mapRenderer) {
        this.mapRenderer = mapRenderer;
        mapRenderer.setProjection(this.navPanel.getProjectionImpl());
        mapRenderer.setColor(this.mapColor);
        this.redrawLater();
    }

    void showDataset() {
        this.eventsOK = false;
        this.currentField = (Grid)this.gridDataset.getGrids().get(0);
        this.dataState = this.gridRenderer.setGrid(this.gridDataset, this.currentField);
        this.setField(this.currentField);
        GridHorizCoordinateSystem hcs = this.currentField.getCoordinateSystem().getHorizCoordinateSystem();
        this.setProjection(hcs);
        this.redrawLater();
        this.eventsOK = true;
    }

    private void setProjection(GridHorizCoordinateSystem hcs) {
        Projection p = hcs.getProjection();
        ProjectionRect bb = hcs.getBoundingBox();
        double centerlon = 0.0;
        if (bb != null) {
            this.navPanel.setMapArea(bb);
            this.navPanel.setMapAreaHome(bb);
            centerlon = bb.getCenterX();
        }
        if (hcs.isLatLon() || hcs.isCurvilinear()) {
            p = new LatLonProjection("LatLon", null, centerlon);
        }
        if (this.mapRenderer != null) {
            this.mapRenderer.setProjection(p);
        }
        this.gridRenderer.setDataProjection(p);
        this.navPanel.setProjectionImpl(p);
    }

    public void setDataMinMaxType(ColorScale.MinMaxType type) {
        this.gridRenderer.setDataMinMaxType(type);
        this.redrawLater();
    }

    public void setGridCollection(GridDataset gcd) {
        this.gridDataset = gcd;
        this.setFields(NamedObjects.getGridNames((Iterable<Grid>)gcd.getGrids()));
        this.startOK = false;
        try {
            this.showDataset();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
        this.datasetNameLabel.setText("Dataset:  " + this.gridDataset.getName());
    }

    void setFieldsFromBeans(List<GridNewTable.GridBean> fields) {
        this.fieldChooser.setCollection(fields.iterator());
    }

    void setFields(Iterable<NamedObject> fields) {
        this.fieldChooser.setCollection(fields.iterator());
    }

    private boolean setField(Object fld) {
        NamedObject no;
        Grid gg = null;
        if (fld instanceof Grid) {
            gg = (Grid)fld;
        } else if (fld instanceof String) {
            gg = this.gridDataset.findGrid((String)fld).orElse(null);
        } else if (fld instanceof NamedObject) {
            gg = this.gridDataset.findGrid(((NamedObject)fld).getName()).orElse(null);
        }
        if (null == gg) {
            return false;
        }
        this.dataState = this.gridRenderer.setGrid(this.gridDataset, gg);
        this.gridRenderer.setDataProjection(this.dataState.gcs.getHorizCoordinateSystem().getProjection());
        this.currentField = gg;
        if (this.dataState.tcs != null && this.dataState.rtaxis != null) {
            List<NamedObject> runtimeNames = this.makeRunTimeNames(this.dataState.tcs, this.dataState.rtaxis);
            this.runtimeChooser.setCollection(runtimeNames.iterator(), true);
            NamedObject no2 = this.findNamedObject(runtimeNames, this.dataState.runtimeCoord);
            if (no2 == null) {
                this.dataState.setRuntimeCoord(runtimeNames.get(0).getValue());
                this.runtimeChooser.setSelectedByIndex(0);
            } else {
                this.runtimeChooser.setSelectedByValue((Object)no2);
            }
            this.setChooserWanted("runtime", true);
        } else {
            this.setChooserWanted("runtime", false);
            this.dataState.setRuntimeCoord(null);
        }
        if (this.dataState.tcs != null) {
            int runtimeIdx = this.dataState.runtimeCoord != null ? this.dataState.runtimeCoord.runtimeIdx : 0;
            GridAxis toaxis1D = this.dataState.tcs.getTimeOffsetAxis(runtimeIdx);
            this.timeNames = NamedObjects.getCoordNames(toaxis1D);
            this.timeChooser.setCollection(this.timeNames.iterator(), true);
            no = this.findNamedObject(this.timeNames, this.dataState.timeCoord);
            if (no == null) {
                this.dataState.setTimeCoord(this.timeNames.get(0).getValue());
                this.timeChooser.setSelectedByIndex(0);
            } else {
                this.timeChooser.setSelectedByValue((Object)no);
            }
            this.setChooserWanted("time", true);
        } else {
            this.timeNames = new ArrayList<NamedObject>();
            this.setChooserWanted("time", false);
            this.dataState.setTimeCoord(null);
        }
        if (this.dataState.ensaxis != null) {
            List<NamedObject> ensembleNames = NamedObjects.getCoordNames(this.dataState.ensaxis);
            this.ensembleChooser.setCollection(ensembleNames.iterator(), true);
            NamedObject no3 = this.findNamedObject(ensembleNames, this.dataState.ensCoord);
            if (no3 == null) {
                this.dataState.setEnsCoord(ensembleNames.get(0).getValue());
                this.ensembleChooser.setSelectedByIndex(0);
            } else {
                this.ensembleChooser.setSelectedByValue((Object)no3);
            }
            this.setChooserWanted("ensemble", true);
        } else {
            this.setChooserWanted("ensemble", false);
            this.dataState.setEnsCoord(null);
        }
        if (this.dataState.zaxis != null) {
            List<NamedObject> levelNames = NamedObjects.getCoordNames(this.dataState.zaxis);
            this.levelChooser.setCollection(levelNames.iterator(), true);
            no = this.findNamedObject(levelNames, this.dataState.vertCoord);
            if (no == null) {
                this.dataState.setVertCoord(levelNames.get(0).getValue());
                this.levelChooser.setSelectedByIndex(0);
            } else {
                this.levelChooser.setSelectedByValue((Object)no);
            }
            this.setChooserWanted("level", true);
        } else {
            this.setChooserWanted("level", false);
            this.dataState.setVertCoord(null);
        }
        this.addChoosers();
        this.fieldChooser.setToolTipText(gg.getName());
        this.colorScalePanel.setUnitString(gg.getUnits());
        return true;
    }

    private List<NamedObject> makeRunTimeNames(GridTimeCoordinateSystem tcs, GridAxisPoint runtimeAxis) {
        if (tcs == null || runtimeAxis == null) {
            return new ArrayList<NamedObject>();
        }
        ArrayList<NamedObject> result = new ArrayList<NamedObject>();
        for (int idx = 0; idx < runtimeAxis.getNominalSize(); ++idx) {
            CalendarDate runtime = tcs.getRuntimeDate(idx);
            result.add(new DataState.RuntimeNamedObject(idx, runtime));
        }
        return result;
    }

    @Nullable
    NamedObject findNamedObject(List<NamedObject> named, Object value) {
        return named.stream().filter(no -> no.getValue().equals(value)).findFirst().orElse(null);
    }

    void setDrawHorizAndVert(boolean drawHoriz, boolean drawVert) {
        this.drawingPanel.removeAll();
        if (drawHoriz && drawVert) {
            this.drawingPanel.add((Component)this.navPanel, "Center");
        } else if (drawHoriz) {
            this.drawingPanel.add((Component)this.navPanel, "Center");
        } else if (drawVert) {
            this.drawingPanel.add((Component)this.navPanel, "Center");
        }
    }

    void start(boolean ok) {
        this.startOK = ok;
    }

    synchronized void draw(boolean immediate) {
        if (!this.startOK) {
            return;
        }
        if (this.drawHorizOn) {
            this.drawH(immediate);
        }
    }

    private void drawH(boolean immediate) {
        long tookTime;
        if (!this.startOK) {
            return;
        }
        boolean already = this.redrawTimer.isRunning();
        if (already) {
            this.redrawTimer.stop();
        }
        long tstart = System.currentTimeMillis();
        Graphics2D gNP = this.navPanel.getBufferedImageGraphics();
        if (gNP == null) {
            return;
        }
        gNP.setBackground(this.navPanel.getBackgroundColor());
        gNP.fill(gNP.getClipBounds());
        long startTime = System.currentTimeMillis();
        try {
            this.gridRenderer.renderPlanView(gNP, this.atI);
        }
        catch (IOException | InvalidRangeException e) {
            e.printStackTrace();
        }
        if (Debug.isSet((String)"timing/GridDraw")) {
            tookTime = System.currentTimeMillis() - startTime;
            System.out.println("timing.GridDraw: " + (double)tookTime * 0.001 + " seconds");
        }
        if (this.mapRenderer != null) {
            startTime = System.currentTimeMillis();
            this.mapRenderer.draw(gNP, this.atI);
            if (Debug.isSet((String)"timing/MapDraw")) {
                tookTime = System.currentTimeMillis() - startTime;
                System.out.println("timing/MapDraw: " + (double)tookTime * 0.001 + " seconds");
            }
        }
        if (immediate) {
            this.navPanel.drawG();
        } else {
            this.navPanel.repaint();
        }
        gNP.dispose();
        if (Debug.isSet((String)"timing/total")) {
            tookTime = System.currentTimeMillis() - tstart;
            System.out.println("timing.total: " + (double)tookTime * 0.001 + " seconds");
        }
    }

    private synchronized void redrawLater() {
        boolean already = this.redrawTimer.isRunning();
        if (already) {
            this.redrawTimer.restart();
        } else {
            this.redrawTimer.start();
        }
    }

    private void addChoosers() {
        this.fieldPanel.removeAll();
        for (Chooser c : this.choosers) {
            if (!c.isWanted) continue;
            this.fieldPanel.add((Component)c.field);
        }
    }

    private void setChooserWanted(String name, boolean want) {
        for (Chooser chooser : this.choosers) {
            if (!chooser.name.equals(name)) continue;
            chooser.isWanted = want;
        }
    }

    private void addActionsToMenus(JMenu datasetMenu, JMenu configMenu, JMenu toolMenu) {
        BAMutil.addActionToMenu((JMenu)datasetMenu, (Action)this.showDatasetInfoAction);
        JMenu toolbarMenu = new JMenu("Toolbars");
        toolbarMenu.setMnemonic('T');
        configMenu.add(toolbarMenu);
        BAMutil.addActionToMenu((JMenu)toolbarMenu, (Action)this.navToolbarAction);
        BAMutil.addActionToMenu((JMenu)toolbarMenu, (Action)this.moveToolbarAction);
        JMenu displayMenu = new JMenu("Display control");
        displayMenu.setMnemonic('D');
        BAMutil.addActionToMenu((JMenu)displayMenu, (Action)this.showGridAction);
        BAMutil.addActionToMenu((JMenu)displayMenu, (Action)this.showContoursAction);
        BAMutil.addActionToMenu((JMenu)displayMenu, (Action)this.showContourLabelsAction);
        BAMutil.addActionToMenu((JMenu)displayMenu, (Action)this.redrawAction);
        toolMenu.add(displayMenu);
        JMenu loopMenu = new JMenu("Loop control");
        loopMenu.setMnemonic('L');
        BAMutil.addActionToMenu((JMenu)loopMenu, (Action)this.fieldLoopAction);
        BAMutil.addActionToMenu((JMenu)loopMenu, (Action)this.levelLoopAction);
        BAMutil.addActionToMenu((JMenu)loopMenu, (Action)this.timeLoopAction);
        BAMutil.addActionToMenu((JMenu)loopMenu, (Action)this.runtimeLoopAction);
        toolMenu.add(loopMenu);
        JMenu mmMenu = new JMenu("ColorScale min/max");
        mmMenu.setMnemonic('C');
        BAMutil.addActionToMenu((JMenu)mmMenu, (Action)this.minmaxHorizAction);
        BAMutil.addActionToMenu((JMenu)mmMenu, (Action)this.minmaxLogAction);
        BAMutil.addActionToMenu((JMenu)mmMenu, (Action)this.minmaxHoldAction);
        toolMenu.add(mmMenu);
        JMenu zoomMenu = new JMenu("Zoom/Pan");
        zoomMenu.setMnemonic('Z');
        this.navPanel.addActionsToMenu(zoomMenu);
        toolMenu.add(zoomMenu);
    }

    private static class LoopControlAction
    extends AbstractAction {
        SuperComboBox scbox;

        LoopControlAction(SuperComboBox cbox) {
            this.scbox = cbox;
            BAMutil.setActionProperties((AbstractAction)this, null, (String)cbox.getName(), (boolean)false, (int)0, (int)0);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.scbox.getLoopControl().show();
        }
    }

    private static class Chooser {
        boolean isWanted;
        String name;
        SuperComboBox field;

        Chooser(String name, SuperComboBox field, boolean want) {
            this.name = name;
            this.field = field;
            this.isWanted = want;
        }
    }
}

