/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.grid;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ucar.nc2.grid.GridAxis;
import ucar.nc2.grid.GridAxisPoint;
import ucar.nc2.grid.GridCoordinateSystem;
import ucar.ui.event.ActionSourceListener;
import ucar.ui.grid.VertScaleSlider;
import ucar.ui.widget.ScaledPanel;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPoints;
import ucar.unidata.geoloc.Projection;

class VertPanel
extends JPanel {
    private static final boolean debugBounds = false;
    private final ScaledPanel drawArea;
    private final VertScaleSlider vslider;
    private final JLabel leftScale;
    private final JLabel midScale;
    private final JLabel rightScale;
    private final JLabel vertUnitsLabel;
    private double yleft;
    private double ymid;
    private double yright;
    private boolean isLatLon = true;
    private Projection proj;
    private GridAxisPoint xaxis;

    public VertPanel() {
        this.setLayout(new BorderLayout());
        JPanel botScale = new JPanel(new BorderLayout());
        this.leftScale = new JLabel("leftScale");
        this.rightScale = new JLabel("rightScale");
        this.midScale = new JLabel("midScale", 0);
        botScale.add((Component)this.leftScale, "West");
        botScale.add((Component)this.midScale, "Center");
        botScale.add((Component)this.rightScale, "East");
        this.drawArea = new ScaledPanel();
        this.vslider = new VertScaleSlider();
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.add((Component)this.vslider, "Center");
        this.vertUnitsLabel = new JLabel(" ");
        rightPanel.add((Component)this.vertUnitsLabel, "South");
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)this.drawArea, "Center");
        leftPanel.add((Component)botScale, "South");
        this.add((Component)leftPanel, "Center");
        this.add((Component)rightPanel, "East");
    }

    public ActionSourceListener getActionSourceListener() {
        return this.vslider.getActionSourceListener();
    }

    public ScaledPanel getDrawArea() {
        return this.drawArea;
    }

    public void setLevels(GridCoordinateSystem gcs, int current) {
        this.vslider.setLevels(gcs, current);
    }

    public void setCoordSys(GridCoordinateSystem geocs, int currentLevel) {
        double zupper;
        double zlower;
        GridAxis zaxis = geocs.getVerticalAxis();
        if (zaxis == null) {
            return;
        }
        this.vslider.setLevels(geocs, currentLevel);
        this.vertUnitsLabel.setText("  " + zaxis.getUnits());
        GridAxisPoint yaxis = geocs.getYHorizAxis();
        if (yaxis == null || zaxis == null) {
            return;
        }
        int nz = zaxis.getNominalSize();
        int ny = yaxis.getNominalSize();
        double zmin = Math.min(zaxis.getCoordDouble(0), zaxis.getCoordDouble(nz - 1));
        double zmax = Math.max(zaxis.getCoordDouble(0), zaxis.getCoordDouble(nz - 1));
        if (geocs.isZPositive()) {
            zlower = zmin;
            zupper = zmax;
        } else {
            zlower = zmax;
            zupper = zmin;
        }
        this.yleft = Math.min(yaxis.getCoordDouble(0), yaxis.getCoordDouble(ny - 1));
        this.yright = Math.max(yaxis.getCoordDouble(0), yaxis.getCoordDouble(ny - 1));
        ScaledPanel.Bounds bounds = new ScaledPanel.Bounds(this.yleft, this.yright, zupper, zlower);
        this.drawArea.setWorldBounds(bounds);
        this.proj = geocs.getHorizCoordinateSystem().getProjection();
        this.isLatLon = geocs.getHorizCoordinateSystem().isLatLon();
        this.ymid = (this.yleft + this.yright) / 2.0;
        this.xaxis = geocs.getHorizCoordinateSystem().getXHorizAxis();
        this.setSlice(0);
    }

    public void setSlice(int slice) {
        if (this.isLatLon) {
            this.leftScale.setText(LatLonPoints.latToString((double)this.yleft, (int)3));
            this.midScale.setText(LatLonPoints.latToString((double)this.ymid, (int)3));
            this.rightScale.setText(LatLonPoints.latToString((double)this.yright, (int)3));
            return;
        }
        if (this.xaxis != null) {
            double xval = this.xaxis.getCoordDouble(slice);
            this.leftScale.setText(this.getYstr(xval, this.yleft));
            this.midScale.setText(this.getYstr(xval, this.ymid));
            this.rightScale.setText(this.getYstr(xval, this.yright));
        }
        this.repaint();
    }

    private String getYstr(double xvalue, double yvalue) {
        LatLonPoint lpt = this.proj.projToLatLon(xvalue, yvalue);
        return LatLonPoints.latToString((double)lpt.getLatitude(), (int)3);
    }
}

