/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.grid;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import ucar.nc2.grid.GridAxis;
import ucar.nc2.grid.GridCoordinateSystem;
import ucar.ui.event.ActionSourceListener;
import ucar.ui.event.ActionValueEvent;

class VertScaleSlider
extends JPanel {
    private static final boolean debugEvent = false;
    private static final boolean debugLevels = false;
    private final JSlider slider;
    private final ActionSourceListener actionSource;
    private final String actionName = "level";
    private boolean eventOK = true;
    private int incrY = 1;
    private int currentIdx = -1;
    private double min;
    private double max;
    private double scale = 1.0;
    private GridAxis<?> zAxis;

    public VertScaleSlider() {
        this.setLayout(new BoxLayout(this, 0));
        this.slider = new JSlider(1, 0, 100, 0);
        this.slider.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.slider.addChangeListener(e -> {
            if (this.eventOK && this.zAxis != null && !this.slider.getValueIsAdjusting()) {
                int pos = this.slider.getValue();
                int idx = this.slider2index(pos);
                if (idx == this.currentIdx) {
                    return;
                }
                this.currentIdx = idx;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VertScaleSlider.this.setSelectedIndex(VertScaleSlider.this.currentIdx);
                        VertScaleSlider.this.actionSource.fireActionValueEvent("level", (Object)VertScaleSlider.this.zAxis.getCoordDouble(VertScaleSlider.this.currentIdx));
                    }
                });
            }
        });
        this.actionSource = new ActionSourceListener("level"){

            public void actionPerformed(ActionValueEvent e) {
                VertScaleSlider.this.setSelectedByName(e.getValue().toString());
            }
        };
        this.slider.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                VertScaleSlider.this.setLabels();
            }
        });
        this.add(this.slider);
    }

    public ActionSourceListener getActionSourceListener() {
        return this.actionSource;
    }

    public void setLevels(GridCoordinateSystem gcs, int current) {
        this.zAxis = gcs.getVerticalAxis();
        if (this.zAxis == null) {
            this.slider.setEnabled(false);
            return;
        }
        this.slider.setEnabled(true);
        this.slider.setInverted(!gcs.isZPositive());
        this.slider.setToolTipText(this.zAxis.getUnits());
        this.setSelectedIndex(current);
        int nz = this.zAxis.getNominalSize();
        this.min = Math.min(this.zAxis.getCoordDouble(0), this.zAxis.getCoordDouble(nz - 1));
        this.max = Math.max(this.zAxis.getCoordDouble(0), this.zAxis.getCoordDouble(nz - 1));
        this.setLabels();
        this.slider.setPaintLabels(true);
    }

    private void setLabels() {
        Rectangle bounds = this.slider.getBounds();
        double h = bounds.getHeight() > 0.0 ? bounds.getHeight() : 100.0;
        double wh = this.max - this.min > 0.0 ? this.max - this.min : 1.0;
        this.scale = 100.0 / wh;
        double slider2pixel = h / 100.0;
        Font font = this.slider.getFont();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        if (fontMetrics != null) {
            this.incrY = fontMetrics.getAscent();
        }
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        if (this.zAxis == null) {
            return;
        }
        int n = this.zAxis.getNominalSize();
        int last = this.world2slider(this.zAxis.getCoordDouble(n - 1));
        labelTable.put(last, new JLabel(this.coordName(n - 1)));
        int next = this.world2slider(this.zAxis.getCoordDouble(0));
        labelTable.put(next, new JLabel(this.coordName(0)));
        for (int i = 1; i < n - 1; ++i) {
            int ival = this.world2slider(this.zAxis.getCoordDouble(i));
            if (!(slider2pixel * (double)Math.abs(ival - last) > (double)this.incrY) || !(slider2pixel * (double)Math.abs(ival - next) > (double)this.incrY)) continue;
            labelTable.put(ival, new JLabel(this.coordName(i)));
            next = ival;
        }
        this.slider.setLabelTable(labelTable);
    }

    private int world2slider(double val) {
        return (int)(this.scale * (val - this.min));
    }

    private String coordName(int index) {
        return Double.toString(this.zAxis.getCoordDouble(index));
    }

    private double slider2world(int pval) {
        return (double)pval / this.scale + this.min;
    }

    private int slider2index(int pval) {
        return pval;
    }

    private void setSelectedByName(String name) {
        if (this.zAxis == null) {
            return;
        }
        for (int i = 0; i < this.zAxis.getNominalSize(); ++i) {
            if (!name.equals(this.coordName(i))) continue;
            this.setSelectedIndex(i);
            return;
        }
        System.out.println("ERROR VertScaleSlider cant find = " + name);
    }

    private void setSelectedIndex(int idx) {
        if (this.zAxis == null) {
            return;
        }
        this.eventOK = false;
        this.currentIdx = idx;
        this.slider.setValue(this.world2slider(this.zAxis.getCoordDouble(this.currentIdx)));
        this.eventOK = true;
    }
}

