/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.image;

import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.stream.ImageInputStream;
import ucar.ui.image.LoadThread;
import ucar.ui.image.PictureCache;
import ucar.ui.image.SourcePictureListener;
import ucar.ui.image.Tools;

public class SourcePicture
implements Cloneable {
    public static final int UNINITIALISED = 0;
    public static final int LOADING = 1;
    public static final int ROTATING = 2;
    public static final int READY = 3;
    public static final int ERROR = 4;
    public static final int LOADING_STARTED = 5;
    public static final int LOADING_PROGRESS = 6;
    public static final int LOADING_COMPLETED = 7;
    public BufferedImage sourcePictureBufferedImage;
    private URL imageUrl;
    private int pictureStatusCode;
    private String pictureStatusMessage;
    private Vector sourcePictureListeners = new Vector();
    private int percentLoaded;
    protected ImageProgressListener imageProgressListener = new ImageProgressListener();
    private ImageReader reader;
    private boolean abortFlag;
    private double rotation;

    SourcePicture() {
        this.setStatus(0, "Uninitialised SourcePicture object.");
    }

    public void loadPictureInThread(URL imageUrl, int priority, double rotation) {
        if (this.pictureStatusCode == 1) {
            this.stopLoadingExcept(imageUrl);
        }
        this.imageUrl = imageUrl;
        this.rotation = rotation;
        LoadThread t = new LoadThread(this);
        t.setPriority(priority);
        t.start();
    }

    public void loadPicture(URL imageUrl, double rotation) {
        if (this.pictureStatusCode == 1) {
            this.stopLoadingExcept(imageUrl);
        }
        this.imageUrl = imageUrl;
        this.rotation = rotation;
        this.loadPicture();
    }

    public void loadPicture() {
        Tools.log("SourcePicture.loadPicture: " + this.imageUrl + " loaded into SourcePicture object: " + this.hashCode());
        this.setStatus(1, "Loading: " + this.imageUrl);
        this.abortFlag = false;
        try {
            ImageInputStream iis = ImageIO.createImageInputStream(this.imageUrl.openStream());
            Iterator<ImageReader> i = ImageIO.getImageReaders(iis);
            if (!i.hasNext()) {
                throw new IOException("No Readers Available!");
            }
            this.reader = i.next();
            this.reader.addIIOReadProgressListener(this.imageProgressListener);
            this.reader.setInput(iis);
            this.sourcePictureBufferedImage = null;
            this.sourcePictureBufferedImage = this.reader.read(0);
            iis.close();
            this.reader.removeIIOReadProgressListener(this.imageProgressListener);
            this.reader.dispose();
            if (!this.abortFlag) {
                if (this.rotation != 0.0) {
                    this.setStatus(2, "Rotating: " + this.imageUrl);
                    int xRot = this.sourcePictureBufferedImage.getWidth() / 2;
                    int yRot = this.sourcePictureBufferedImage.getHeight() / 2;
                    AffineTransform rotateAf = AffineTransform.getRotateInstance(Math.toRadians(this.rotation), xRot, yRot);
                    AffineTransformOp op = new AffineTransformOp(rotateAf, 2);
                    Rectangle2D newBounds = op.getBounds2D(this.sourcePictureBufferedImage);
                    double minX = newBounds.getMinX();
                    double minY = newBounds.getMinY();
                    AffineTransform translateAf = AffineTransform.getTranslateInstance(minX * -1.0, minY * -1.0);
                    rotateAf.preConcatenate(translateAf);
                    op = new AffineTransformOp(rotateAf, 2);
                    newBounds = op.getBounds2D(this.sourcePictureBufferedImage);
                    BufferedImage targetImage = new BufferedImage((int)newBounds.getWidth(), (int)newBounds.getHeight(), 5);
                    this.sourcePictureBufferedImage = op.filter(this.sourcePictureBufferedImage, targetImage);
                }
                this.setStatus(3, "Loaded: " + this.imageUrl);
                PictureCache.add(this.imageUrl, (SourcePicture)this.clone());
            } else {
                this.setStatus(4, "Aborted: " + this.imageUrl);
                this.sourcePictureBufferedImage = null;
            }
        }
        catch (IOException e) {
            this.setStatus(4, "Error while reading " + this.imageUrl);
            this.sourcePictureBufferedImage = null;
        }
    }

    public void stopLoading() {
        if (this.imageUrl == null) {
            return;
        }
        Tools.log("SourcePicture.stopLoading: called on " + this.imageUrl);
        if (this.pictureStatusCode == 1) {
            this.reader.abort();
            this.abortFlag = true;
        }
    }

    public boolean stopLoadingExcept(URL exemptionURL) {
        if (this.imageUrl == null) {
            return false;
        }
        if (this.pictureStatusCode != 1) {
            Tools.log("SourcePicture.stopLoadingExcept: called but pointless since image is not LOADING: " + this.imageUrl);
            return false;
        }
        if (!exemptionURL.toString().equals(this.imageUrl.toString())) {
            Tools.log("SourcePicture.stopLoadingExcept: called with Url " + exemptionURL + " --> stopping loading of " + this.imageUrl);
            this.stopLoading();
            return true;
        }
        return false;
    }

    public Dimension getSize() {
        if (this.sourcePictureBufferedImage != null) {
            return new Dimension(this.sourcePictureBufferedImage.getWidth(), this.sourcePictureBufferedImage.getHeight());
        }
        return new Dimension(0, 0);
    }

    public int getHeight() {
        if (this.sourcePictureBufferedImage != null) {
            return this.sourcePictureBufferedImage.getHeight();
        }
        return 0;
    }

    public int getWidth() {
        if (this.sourcePictureBufferedImage != null) {
            return this.sourcePictureBufferedImage.getWidth();
        }
        return 0;
    }

    public String getUrlString() {
        return this.imageUrl.toString();
    }

    public URL getUrl() {
        return this.imageUrl;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void addListener(SourcePictureListener listener) {
        Tools.log("SourcePicture.addListener: listener added on SourcePicture " + this.hashCode() + " of class: " + listener.getClass());
        this.sourcePictureListeners.add(listener);
    }

    public void removeListener(SourcePictureListener listener) {
        Tools.log("SourcePicture.removeListener: listener removed from SourcePicture " + this.hashCode() + " of class: " + listener.getClass());
        this.sourcePictureListeners.remove(listener);
    }

    public void showListeners() {
        Tools.log("SourcePicture.showListeners: SoucePicture " + this.hashCode());
        Enumeration en = this.sourcePictureListeners.elements();
        while (en.hasMoreElements()) {
            Object obj = en.nextElement();
            Tools.log("    reports to Listener: " + obj.hashCode() + " of class " + obj.getClass());
        }
        Tools.log("    --------");
    }

    public boolean hasNoListeners() {
        return this.sourcePictureListeners.isEmpty();
    }

    private void setStatus(int statusCode, String statusMessage) {
        Tools.log("\nSourcePicture.setStatus: sending status: " + statusMessage);
        this.pictureStatusCode = statusCode;
        this.pictureStatusMessage = statusMessage;
        Vector nonmodifiedVector = (Vector)this.sourcePictureListeners.clone();
        Enumeration e = nonmodifiedVector.elements();
        while (e.hasMoreElements()) {
            SourcePictureListener spl = (SourcePictureListener)e.nextElement();
            spl.sourceStatusChange(this.pictureStatusCode, this.pictureStatusMessage, this);
            Tools.log("\nSourcePicture.setStatus: sending status: " + statusMessage + " to " + spl.getClass());
        }
    }

    public int getStatusCode() {
        return this.pictureStatusCode;
    }

    public String getStatusMessage() {
        return this.pictureStatusMessage;
    }

    public int getPercentLoaded() {
        return this.percentLoaded;
    }

    public BufferedImage getSourceBufferedImage() {
        return this.sourcePictureBufferedImage;
    }

    public void setSourceBufferedImage(BufferedImage img, String statusMessage) {
        this.sourcePictureBufferedImage = img;
        this.setStatus(3, statusMessage);
    }

    public SourcePicture getSourcePicture() {
        return this;
    }

    public Object clone() {
        Object obj = null;
        try {
            obj = super.clone();
        }
        catch (CloneNotSupportedException e) {
            Tools.log("Cloning not supported on SourcePicture!");
        }
        return obj;
    }

    class ImageProgressListener
    implements IIOReadProgressListener {
        private DecimalFormat percentageFormatter = new DecimalFormat("##0");

        ImageProgressListener() {
        }

        private void notifySourceLoadProgressListeners(int statusCode, int percentage) {
            SourcePicture.this.percentLoaded = percentage;
            Enumeration e = SourcePicture.this.sourcePictureListeners.elements();
            while (e.hasMoreElements()) {
                ((SourcePictureListener)e.nextElement()).sourceLoadProgressNotification(statusCode, percentage);
            }
        }

        @Override
        public void imageComplete(ImageReader source) {
            this.notifySourceLoadProgressListeners(7, 100);
            Tools.log("imageComplete");
        }

        @Override
        public void imageProgress(ImageReader source, float percentageDone) {
            this.notifySourceLoadProgressListeners(6, (int)percentageDone);
            Tools.log("imageProgress: " + this.percentageFormatter.format(percentageDone) + "%");
        }

        @Override
        public void imageStarted(ImageReader source, int imageIndex) {
            this.notifySourceLoadProgressListeners(5, 0);
            Tools.log("imageStarted");
        }

        @Override
        public void readAborted(ImageReader source) {
        }

        @Override
        public void sequenceComplete(ImageReader source) {
        }

        @Override
        public void sequenceStarted(ImageReader source, int minIndex) {
        }

        @Override
        public void thumbnailComplete(ImageReader source) {
        }

        @Override
        public void thumbnailProgress(ImageReader source, float percentageDone) {
        }

        @Override
        public void thumbnailStarted(ImageReader source, int imageIndex, int thumbnailIndex) {
        }
    }
}

