/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.menu;

import com.google.common.collect.ImmutableList;
import java.awt.event.ActionEvent;
import java.util.Formatter;
import java.util.Properties;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.internal.cache.FileCacheIF;
import ucar.ui.ToolsUI;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.PLAF;
import ucar.unidata.io.RandomAccessFile;

public class SystemMenu
extends JMenu {
    private final ToolsUI toolsui;
    private static boolean isCacheInit;

    public SystemMenu(ToolsUI tui) {
        super("System");
        this.setMnemonic('S');
        this.toolsui = tui;
        AbstractAction clearHttpStateAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        BAMutil.setActionProperties((AbstractAction)clearHttpStateAction, null, (String)"Clear Http State", (boolean)false, (int)83, (int)-1);
        BAMutil.addActionToMenu((JMenu)this, (Action)clearHttpStateAction);
        AbstractAction showCacheAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter f = new Formatter();
                f.format("RandomAccessFileCache contents%n", new Object[0]);
                FileCacheIF rafCache = RandomAccessFile.getGlobalFileCache();
                if (null != rafCache) {
                    rafCache.showCache(f);
                }
                f.format("%nNetcdfFileCache contents%n", new Object[0]);
                FileCacheIF cache = NetcdfDatasets.getNetcdfFileCache();
                if (null != cache) {
                    cache.showCache(f);
                }
                SystemMenu.this.toolsui.getDatasetViewerPanel().setText(f.toString());
                SystemMenu.this.toolsui.getDatasetViewerPanel().getDetailWindow().show();
            }
        };
        BAMutil.setActionProperties((AbstractAction)showCacheAction, null, (String)"Show Caches", (boolean)false, (int)83, (int)-1);
        BAMutil.addActionToMenu((JMenu)this, (Action)showCacheAction);
        AbstractAction clearRafCacheAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileCacheIF rafCache = RandomAccessFile.getGlobalFileCache();
                if (rafCache != null) {
                    rafCache.clearCache(true);
                }
            }
        };
        BAMutil.setActionProperties((AbstractAction)clearRafCacheAction, null, (String)"Clear RandomAccessFileCache", (boolean)false, (int)67, (int)-1);
        BAMutil.addActionToMenu((JMenu)this, (Action)clearRafCacheAction);
        AbstractAction clearCacheAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileCacheIF cache = NetcdfDatasets.getNetcdfFileCache();
                if (cache != null) {
                    cache.clearCache(true);
                }
            }
        };
        BAMutil.setActionProperties((AbstractAction)clearCacheAction, null, (String)"Clear NetcdfDatasetCache", (boolean)false, (int)67, (int)-1);
        BAMutil.addActionToMenu((JMenu)this, (Action)clearCacheAction);
        AbstractAction enableCache = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = (Boolean)this.getValue("state");
                if (state == isCacheInit) {
                    return;
                }
                isCacheInit = state;
                if (isCacheInit) {
                    FileCacheIF cache = NetcdfDatasets.getNetcdfFileCache();
                    if (cache != null) {
                        cache.enable();
                    } else {
                        NetcdfDatasets.initNetcdfFileCache((int)10, (int)20, (int)600);
                    }
                } else {
                    FileCacheIF cache = NetcdfDatasets.getNetcdfFileCache();
                    if (cache != null) {
                        cache.disable();
                    }
                }
            }
        };
        BAMutil.setActionPropertiesToggle((AbstractAction)enableCache, null, (String)"Enable NetcdfDatasetCache", (boolean)isCacheInit, (int)78, (int)-1);
        BAMutil.addActionToMenu((JMenu)this, (Action)enableCache);
        AbstractAction showPropertiesAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemMenu.this.toolsui.getDatasetViewerPanel().setText("System Properties\n");
                Properties sysp = System.getProperties();
                Set<String> eprops = sysp.stringPropertyNames();
                ImmutableList list = ImmutableList.copyOf(eprops);
                for (Object aList : list) {
                    String name = (String)aList;
                    String value = System.getProperty(name);
                    SystemMenu.this.toolsui.getDatasetViewerPanel().appendLine("  " + name + " = " + value);
                }
                SystemMenu.this.toolsui.getDatasetViewerPanel().getDetailWindow().show();
            }
        };
        BAMutil.setActionProperties((AbstractAction)showPropertiesAction, null, (String)"System Properties", (boolean)false, (int)80, (int)-1);
        BAMutil.addActionToMenu((JMenu)this, (Action)showPropertiesAction);
        this.addPlafSubmenu();
        AbstractAction exitAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolsUI.exit();
            }
        };
        BAMutil.setActionProperties((AbstractAction)exitAction, (String)"Exit", (String)"Exit", (boolean)false, (int)88, (int)-1);
        BAMutil.addActionToMenu((JMenu)this, (Action)exitAction);
    }

    private void addPlafSubmenu() {
        JMenu plafMenu = new JMenu("Look and Feel");
        plafMenu.setMnemonic('L');
        PLAF plaf = new PLAF((JComponent)this.toolsui);
        plaf.addToMenu(plafMenu);
        this.add(plafMenu);
    }
}

