/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.op;

import java.awt.Component;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Paths;
import javax.swing.JOptionPane;
import thredds.featurecollection.FeatureCollectionConfig;
import ucar.ui.OpPanel;
import ucar.ui.ToolsUI;
import ucar.ui.grib.CdmIndexPanel;
import ucar.util.prefs.PreferencesExt;

public class CdmIndexOpPanel
extends OpPanel {
    private final CdmIndexPanel indexPanel;

    public CdmIndexOpPanel(PreferencesExt p) {
        super(p, "index file:", true, false);
        this.indexPanel = new CdmIndexPanel(this.prefs, this.buttPanel);
        this.indexPanel.addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("openGrib2Collection")) {
                String collectionName = (String)e.getNewValue();
                ToolsUI.getToolsUI().openGrib2Collection(collectionName);
            }
        });
        this.add((Component)this.indexPanel, "Center");
    }

    @Override
    public boolean process(Object o) {
        String command = (String)o;
        boolean err = false;
        try {
            this.indexPanel.setIndexFile(Paths.get(command, new String[0]), new FeatureCollectionConfig());
        }
        catch (FileNotFoundException ioe) {
            JOptionPane.showMessageDialog(null, "GribCdmIndexPanel cannot open " + command + "\n" + ioe.getMessage());
            err = true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            StringWriter sw = new StringWriter(5000);
            e.printStackTrace(new PrintWriter(sw));
            this.detailTA.setText(sw.toString());
            this.detailWindow.show();
            err = true;
        }
        return !err;
    }

    @Override
    public void closeOpenFiles() throws IOException {
        this.indexPanel.clear();
    }

    @Override
    public void save() {
        this.indexPanel.save();
        super.save();
    }
}

