/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.op;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import ucar.ui.OpPanel;
import ucar.ui.ToolsUI;
import ucar.ui.grib.CdmIndexScan;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.FileManager;
import ucar.util.prefs.PreferencesExt;

public class CdmIndexScanOp
extends OpPanel {
    private final CdmIndexScan cdmIndexScan;
    final FileManager dirChooser;

    public CdmIndexScanOp(PreferencesExt prefs, final FileManager dirChooser) {
        super(prefs, "dir:", false, false);
        this.dirChooser = dirChooser;
        this.cdmIndexScan = new CdmIndexScan(prefs, this.buttPanel);
        this.add((Component)this.cdmIndexScan, "Center");
        dirChooser.getFileChooser().setFileSelectionMode(2);
        dirChooser.setCurrentDirectory(prefs.get("currDir", "."));
        AbstractAction fileAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String filename = dirChooser.chooseFilename();
                if (filename == null) {
                    return;
                }
                CdmIndexScanOp.this.cb.setSelectedItem((Object)filename);
            }
        };
        BAMutil.setActionProperties((AbstractAction)fileAction, (String)"FileChooser", (String)"open Local dataset...", (boolean)false, (int)76, (int)-1);
        BAMutil.addActionToContainer((Container)this.buttPanel, (Action)fileAction);
        this.cdmIndexScan.addPropertyChangeListener(e -> {
            if (!(e.getNewValue() instanceof String)) {
                return;
            }
            String datasetName = (String)e.getNewValue();
            if ("openIndexFile".equals(e.getPropertyName())) {
                ToolsUI.getToolsUI().openIndexFile(datasetName);
            }
        });
    }

    @Override
    public boolean process(Object o) {
        String command = (String)o;
        return this.cdmIndexScan.setScanDirectory(command);
    }

    @Override
    public void closeOpenFiles() {
        this.cdmIndexScan.clear();
    }

    @Override
    public void save() {
        this.dirChooser.save();
        this.cdmIndexScan.save();
        this.prefs.put("currDir", this.dirChooser.getCurrentDirectory());
        super.save();
    }
}

