/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.op;

import java.awt.Component;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.ui.OpPanel;
import ucar.ui.op.CoordSysTable;
import ucar.ui.widget.BAMutil;
import ucar.util.prefs.PreferencesExt;

public class CoordSysPanel
extends OpPanel {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private NetcdfDataset ds;
    private final CoordSysTable coordSysTable;

    public CoordSysPanel(PreferencesExt p) {
        super(p, "dataset:", true, false);
        this.coordSysTable = new CoordSysTable(this.prefs, this.buttPanel);
        this.add((Component)this.coordSysTable, "Center");
        AbstractButton summaryButton = BAMutil.makeButtcon((String)"Information", (String)"Summary Info", (boolean)false);
        summaryButton.addActionListener(e -> {
            Formatter f = new Formatter();
            this.coordSysTable.summaryInfo(f);
            this.detailTA.setText(f.toString());
            this.detailWindow.show();
        });
        this.buttPanel.add(summaryButton);
        JButton dsButton = new JButton("Object dump");
        dsButton.addActionListener(e -> {
            if (this.ds != null) {
                Formatter f = new Formatter();
                this.debugDump(this.ds, f);
                this.detailTA.setText(f.toString());
                this.detailTA.gotoTop();
                this.detailWindow.show();
            }
        });
        this.buttPanel.add(dsButton);
    }

    private void debugDump(NetcdfDataset ncd, Formatter f) {
        ncd.getDetailInfo(f);
        this.dumpClasses(ncd.getRootGroup(), f);
    }

    private void dumpClasses(Group g, Formatter out) {
        out.format("Dimensions:%n", new Object[0]);
        for (Dimension ds : g.getDimensions()) {
            out.format("  %s %s%n", ds.getShortName(), ds.getClass().getName());
        }
        out.format("Attributes:%n", new Object[0]);
        for (Attribute a : g.attributes()) {
            out.format("  " + a.getShortName() + " " + a.getClass().getName(), new Object[0]);
        }
        out.format("Variables:%n", new Object[0]);
        this.dumpVariables((List<Variable>)g.getVariables(), out);
        out.format("Groups:%n", new Object[0]);
        for (Group nested : g.getGroups()) {
            out.format("  %s %s%n", nested.getFullName(), nested.getClass().getName());
            this.dumpClasses(nested, out);
        }
    }

    private void dumpVariables(List<Variable> vars, Formatter out) {
        for (Variable v : vars) {
            out.format("  %s %s", v.getFullName(), v.getClass().getName());
            if (v instanceof CoordinateAxis) {
                out.format("  %s", ((CoordinateAxis)v).getAxisType());
            }
            out.format("%n", new Object[0]);
            if (!(v instanceof Structure)) continue;
            this.dumpVariables((List<Variable>)((Structure)v).getVariables(), out);
        }
    }

    @Override
    public boolean process(Object o) {
        String command = (String)o;
        boolean err = false;
        try {
            if (this.ds != null) {
                this.ds.close();
            }
        }
        catch (IOException ioe) {
            logger.warn("close failed");
        }
        try {
            this.ds = NetcdfDatasets.openDataset((String)command, (boolean)true, null);
            if (this.ds == null) {
                JOptionPane.showMessageDialog(null, "Failed to open <" + command + ">");
            } else {
                this.coordSysTable.setDataset(this.ds);
            }
        }
        catch (FileNotFoundException ioe) {
            JOptionPane.showMessageDialog(null, "NetcdfDataset cannot open " + command + "\n" + ioe.getMessage());
            err = true;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter(5000);
            e.printStackTrace(new PrintWriter(sw));
            this.detailTA.setText(sw.toString());
            this.detailWindow.show();
            err = true;
            e.printStackTrace();
        }
        return !err;
    }

    @Override
    public void closeOpenFiles() throws IOException {
        if (this.ds != null) {
            this.ds.close();
        }
        this.ds = null;
        this.coordSysTable.clear();
    }

    public void setDataset(NetcdfDataset ncd) {
        try {
            if (this.ds != null) {
                this.ds.close();
            }
            this.ds = null;
        }
        catch (IOException ioe) {
            logger.warn("close failed");
        }
        this.ds = ncd;
        this.coordSysTable.setDataset(this.ds);
        this.setSelectedItem(this.ds.getLocation());
    }

    @Override
    public void save() {
        this.coordSysTable.save();
        super.save();
    }
}

