/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.op;

import com.google.common.collect.ImmutableList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.annotation.Nullable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayObject;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.calendar.Calendar;
import ucar.nc2.calendar.CalendarDateUnit;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis2D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.internal.grid.DatasetClassifier;
import ucar.nc2.write.Ncdump;
import ucar.nc2.write.NcdumpArray;
import ucar.ui.prefs.BeanTable;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public class CoordSysTable
extends JPanel {
    private final PreferencesExt prefs;
    private final BeanTable<VariableBean> varTable;
    private final BeanTable<CoordinateSystemBean> csTable;
    private final BeanTable<AxisBean> axisTable;
    private final JSplitPane split;
    private final JSplitPane split2;
    private final TextHistoryPane infoTA;
    private final IndependentWindow infoWindow;
    private BeanTable<AttributeBean> attTable;
    private IndependentWindow attWindow;
    private NetcdfDataset ds;
    private DatasetClassifier dcl;

    public CoordSysTable(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        if (buttPanel != null) {
            AbstractAction attAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CoordSysTable.this.showAtts();
                }
            };
            BAMutil.setActionProperties((AbstractAction)attAction, (String)"FontDecr", (String)"global attributes", (boolean)false, (int)65, (int)-1);
            BAMutil.addActionToContainer((Container)buttPanel, (Action)attAction);
        }
        this.csTable = new BeanTable(CoordinateSystemBean.class, (PreferencesExt)prefs.node("CoordinateSystemBean"), false);
        this.csTable.addListSelectionListener(e -> {
            CoordinateSystemBean csb = (CoordinateSystemBean)this.csTable.getSelectedBean();
            if (null != csb) {
                this.setSelectedCoordinateAxes(csb.coordSys);
            }
        });
        this.varTable = new BeanTable(VariableBean.class, (PreferencesExt)prefs.node("VariableBeans"), false);
        this.varTable.addListSelectionListener(e -> {
            VariableBean vb = (VariableBean)this.varTable.getSelectedBean();
            if (null != vb) {
                this.csTable.setSelectedBean((Object)vb.coordSysBean);
            }
        });
        this.axisTable = new BeanTable(AxisBean.class, (PreferencesExt)prefs.node("CoordinateAxisBean"), false);
        PopupMenu varPopup = new PopupMenu((JComponent)this.varTable.getJTable(), "Options");
        varPopup.addAction("Show Declaration", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VariableBean vb = (VariableBean)CoordSysTable.this.varTable.getSelectedBean();
                if (vb != null) {
                    Variable v = CoordSysTable.this.ds.findVariable(vb.getName());
                    if (v == null) {
                        return;
                    }
                    CoordSysTable.this.infoTA.clear();
                    CoordSysTable.this.infoTA.appendLine(((VariableEnhanced)v).toString());
                    CoordSysTable.this.infoTA.appendLine(CoordSysTable.this.showMissing(v));
                    CoordSysTable.this.infoTA.gotoTop();
                    CoordSysTable.this.infoWindow.show();
                }
            }
        });
        PopupMenu csPopup = new PopupMenu((JComponent)this.csTable.getJTable(), "Options");
        csPopup.addAction("Show CoordSys", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordinateSystemBean csb = (CoordinateSystemBean)CoordSysTable.this.csTable.getSelectedBean();
                if (csb != null) {
                    CoordinateSystem coordSys = csb.coordSys;
                    CoordSysTable.this.infoTA.clear();
                    CoordSysTable.this.infoTA.appendLine("Coordinate System = " + coordSys.getName());
                    for (CoordinateAxis axis : coordSys.getCoordinateAxes()) {
                        CoordSysTable.this.infoTA.appendLine("  " + axis.getAxisType() + " " + axis.getNameAndDimensions());
                    }
                    CoordSysTable.this.infoTA.appendLine(" Coordinate Transforms");
                    for (CoordinateTransform ct : coordSys.getCoordinateTransforms()) {
                        ProjectionCT pct;
                        CoordSysTable.this.infoTA.appendLine("  " + ct.getTransformType() + ": " + ct.getName());
                        for (Attribute p : ct.getCtvAttributes()) {
                            CoordSysTable.this.infoTA.appendLine("    " + p);
                        }
                        if (ct instanceof ProjectionCT && (pct = (ProjectionCT)ct).getProjection() != null) {
                            CoordSysTable.this.infoTA.appendLine("    impl.class= " + pct.getProjection().getClass().getName());
                        }
                        if (!(ct instanceof VerticalCT)) continue;
                        VerticalCT vct = (VerticalCT)ct;
                        CoordSysTable.this.infoTA.appendLine("  VerticalCT= " + vct);
                    }
                }
                CoordSysTable.this.infoTA.gotoTop();
                CoordSysTable.this.infoWindow.show();
            }
        });
        PopupMenu axisPopup = new PopupMenu((JComponent)this.axisTable.getJTable(), "Options");
        axisPopup.addAction("Show Declaration", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AxisBean bean = (AxisBean)CoordSysTable.this.axisTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                VariableDS axis = (VariableDS)CoordSysTable.this.ds.findVariable(bean.getName());
                if (axis == null) {
                    return;
                }
                CoordSysTable.this.infoTA.clear();
                CoordSysTable.this.infoTA.appendLine(axis.toString());
                CoordSysTable.this.infoTA.appendLine(CoordSysTable.this.showMissing((Variable)axis));
                CoordSysTable.this.infoTA.gotoTop();
                CoordSysTable.this.infoWindow.show();
            }
        });
        axisPopup.addAction("Show Values", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AxisBean bean = (AxisBean)CoordSysTable.this.axisTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                CoordSysTable.this.infoTA.clear();
                CoordSysTable.this.showValues(bean.axis);
                CoordSysTable.this.infoTA.gotoTop();
                CoordSysTable.this.infoWindow.show();
            }
        });
        axisPopup.addAction("Show Value Differences", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AxisBean bean = (AxisBean)CoordSysTable.this.axisTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                CoordSysTable.this.infoTA.clear();
                CoordSysTable.this.showValueDiffs(bean.axis);
                CoordSysTable.this.infoTA.gotoTop();
                CoordSysTable.this.infoWindow.show();
            }
        });
        axisPopup.addAction("Show Values as Date", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AxisBean bean = (AxisBean)CoordSysTable.this.axisTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                CoordSysTable.this.infoTA.clear();
                CoordSysTable.this.showValuesAsDates(bean.axis);
                CoordSysTable.this.infoTA.gotoTop();
                CoordSysTable.this.infoWindow.show();
            }
        });
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 500, 300)));
        this.split = new JSplitPane(0, false, (Component)this.varTable, (Component)this.csTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.split2 = new JSplitPane(0, false, this.split, (Component)this.axisTable);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split2, "Center");
    }

    public void summaryInfo(Formatter f) {
        if (this.ds == null) {
            return;
        }
        f.format("%s%n", this.ds.getLocation());
        int ngrids = 0;
        for (Object varo : this.varTable.getBeans()) {
            VariableBean varBean = (VariableBean)varo;
            if (!varBean.getArrayType().trim().equalsIgnoreCase("grid")) continue;
            ++ngrids;
        }
        int ncoordSys = this.csTable.getBeans().size();
        int ncoords = this.axisTable.getBeans().size();
        int ntrans = this.ds.getCoordinateTransforms().size();
        f.format(" ngrids=%d, ncoords=%d, ncoordSys=%d ntrans=%d%n", ngrids, ncoords, ncoordSys, ntrans);
        f.format("%nCoordinate Transforms%n", new Object[0]);
        for (CoordinateTransform trans : this.ds.getCoordinateTransforms()) {
            f.format("  %-10s %s%n", trans.getTransformType(), trans.getName());
        }
    }

    public void showAtts() {
        if (this.ds == null) {
            return;
        }
        if (this.attTable == null) {
            this.attTable = new BeanTable(AttributeBean.class, (PreferencesExt)this.prefs.node("AttributeBeans"), false);
            PopupMenu varPopup = new PopupMenu((JComponent)this.attTable.getJTable(), "Options");
            varPopup.addAction("Show Attribute", (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributeBean bean = (AttributeBean)CoordSysTable.this.attTable.getSelectedBean();
                    if (bean != null) {
                        CoordSysTable.this.infoTA.setText(bean.att.toString());
                        CoordSysTable.this.infoTA.gotoTop();
                        CoordSysTable.this.infoWindow.show();
                    }
                }
            });
            this.attWindow = new IndependentWindow("Global Attributes", BAMutil.getImage((String)"nj22/NetcdfUI"), this.attTable);
            this.attWindow.setBounds((Rectangle)this.prefs.getBean("AttWindowBounds", (Object)new Rectangle(300, 100, 500, 800)));
        }
        ArrayList<AttributeBean> attlist = new ArrayList<AttributeBean>();
        this.addAttributes(attlist, this.ds.getRootGroup());
        this.attTable.setBeans(attlist);
        this.attWindow.show();
    }

    private void addAttributes(List<AttributeBean> attlist, Group g) {
        for (Attribute att : g.attributes()) {
            attlist.add(new AttributeBean(g, att));
        }
        for (Group nested : g.getGroups()) {
            this.addAttributes(attlist, nested);
        }
    }

    private void showValues(CoordinateAxis axis) {
        try {
            if (axis instanceof CoordinateAxis1D && axis.isNumeric()) {
                CoordinateAxis1D axis1D = (CoordinateAxis1D)axis;
                this.printArray("midpoints=", axis1D.getCoordValues());
                if (!axis1D.isInterval()) {
                    this.printArray("edges=", axis1D.getCoordEdges());
                } else {
                    this.printArray("bound1=", axis1D.getBound1());
                    this.printArray("bound2=", axis1D.getBound2());
                    Formatter f = new Formatter();
                    double[] mid = axis1D.getCoordValues();
                    double[] b1 = axis1D.getBound1();
                    double[] b2 = axis1D.getBound2();
                    for (int i = 0; i < b1.length; ++i) {
                        f.format("%f (%f,%f) = %f%n", mid[i], b1[i], b2[i], b2[i] - b1[i]);
                    }
                    this.infoTA.appendLine(f.toString());
                }
            } else if (axis instanceof CoordinateAxis2D && axis.isNumeric()) {
                this.infoTA.appendLine(Ncdump.printVariableData((Variable)axis, null));
                this.showValues2D((CoordinateAxis2D)axis);
            } else {
                this.infoTA.appendLine(Ncdump.printVariableData((Variable)axis, null));
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            this.infoTA.appendLine(e1.getMessage());
        }
    }

    private void showValues2D(CoordinateAxis2D axis2D) {
        Formatter f = new Formatter();
        if (axis2D.isInterval()) {
            ArrayDouble.D2 coords = axis2D.getCoordValuesArray();
            ArrayDouble.D3 bounds = axis2D.getCoordBoundsArray();
            if (bounds == null) {
                this.infoTA.appendLine("No bounds for interval " + axis2D.getFullName());
                return;
            }
            int count = 0;
            IndexIterator coordIter = coords.getIndexIterator();
            IndexIterator boundsIter = bounds.getIndexIterator();
            while (coordIter.hasNext()) {
                double coordValue = coordIter.getDoubleNext();
                if (!boundsIter.hasNext()) break;
                double bounds1 = boundsIter.getDoubleNext();
                if (boundsIter.hasNext()) {
                    double bounds2 = boundsIter.getDoubleNext();
                    f.format("%3d: %f (%f,%f) len=%f mid=%f%n", count, coordValue, bounds1, bounds2, bounds2 - bounds1, (bounds2 + bounds1) / 2.0);
                    ++count;
                    continue;
                }
                break;
            }
        } else {
            ArrayDouble.D2 coords = axis2D.getCoordValuesArray();
            IndexIterator coordIter = coords.getIndexIterator();
            while (coordIter.hasNext()) {
                double coordValue = coordIter.getDoubleNext();
                f.format("%f%n", coordValue);
            }
        }
        this.infoTA.appendLine(f.toString());
    }

    private void showValueDiffs(CoordinateAxis axis) {
        if (!axis.isNumeric()) {
            return;
        }
        try {
            if (axis instanceof CoordinateAxis1D) {
                CoordinateAxis1D axis1D = (CoordinateAxis1D)axis;
                double[] mids = axis1D.getCoordValues();
                double[] diffs = new double[mids.length];
                for (int i = 0; i < mids.length - 1; ++i) {
                    diffs[i] = mids[i + 1] - mids[i];
                }
                this.printArrays("midpoint differences", mids, diffs);
            } else if (axis instanceof CoordinateAxis2D) {
                CoordinateAxis2D axis2D = (CoordinateAxis2D)axis;
                ArrayDouble.D2 mids = axis2D.getCoordValuesArray();
                int[] shape = mids.getShape();
                ArrayDouble.D2 diffx = (ArrayDouble.D2)Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{shape[0], shape[1] - 1});
                for (int j = 0; j < shape[0]; ++j) {
                    for (int i = 0; i < shape[1] - 1; ++i) {
                        double diff = mids.get(j, i + 1) - mids.get(j, i);
                        diffx.set(j, i, diff);
                    }
                }
                this.infoTA.appendLine(Ncdump.printArray((Array)diffx, (String)"diff in x", null));
                ArrayDouble.D2 diffy = (ArrayDouble.D2)Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{shape[0] - 1, shape[1]});
                for (int j = 0; j < shape[0] - 1; ++j) {
                    for (int i = 0; i < shape[1]; ++i) {
                        double diff = mids.get(j + 1, i) - mids.get(j, i);
                        diffy.set(j, i, diff);
                    }
                }
                this.infoTA.appendLine("\n\n\n");
                this.infoTA.appendLine(Ncdump.printArray((Array)diffy, (String)"diff in y", null));
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            this.infoTA.appendLine(e1.getMessage());
        }
    }

    private void showValuesAsDates(CoordinateAxis axis) {
        String units = axis.getUnitsString();
        String cal = this.getCalendarAttribute((Variable)axis);
        Calendar calt = Calendar.get((String)cal).orElse(null);
        CalendarDateUnit cdu = (CalendarDateUnit)CalendarDateUnit.fromUdunitString((Calendar)calt, (String)units).orElseThrow();
        try {
            this.infoTA.appendLine(units);
            this.infoTA.appendLine(Ncdump.printVariableData((Variable)axis, null));
            if (axis.getArrayType().isNumeric()) {
                if (axis instanceof CoordinateAxis2D) {
                    this.showDates2D((CoordinateAxis2D)axis, cdu);
                } else if (axis instanceof CoordinateAxis1D) {
                    this.showDates1D((CoordinateAxis1D)axis, cdu);
                } else {
                    Array data = axis.read();
                    IndexIterator ii = data.getIndexIterator();
                    while (ii.hasNext()) {
                        double val = ii.getDoubleNext();
                        this.infoTA.appendLine(this.makeCalendarDateStringOrMissing(cdu, val));
                    }
                }
            } else {
                Array data = axis.read();
                Formatter f = new Formatter();
                if (data instanceof ArrayChar) {
                    ArrayChar dataS = (ArrayChar)data;
                    ArrayChar.StringIterator iter = dataS.getStringIterator();
                    while (iter.hasNext()) {
                        f.format(" %s%n", iter.next());
                    }
                    this.infoTA.appendLine(f.toString());
                } else if (data instanceof ArrayObject) {
                    IndexIterator iter = data.getIndexIterator();
                    while (iter.hasNext()) {
                        f.format(" %s%n", iter.next());
                    }
                    this.infoTA.appendLine(f.toString());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.infoTA.appendLine(ex.getMessage());
        }
    }

    private void showDates2D(CoordinateAxis2D axis2D, CalendarDateUnit cdu) {
        Formatter f = new Formatter();
        int count = 0;
        if (axis2D.isInterval()) {
            ArrayDouble.D2 coords = axis2D.getCoordValuesArray();
            ArrayDouble.D3 bounds = axis2D.getCoordBoundsArray();
            if (bounds == null) {
                this.infoTA.appendLine("No bounds for interval " + axis2D.getFullName());
                return;
            }
            IndexIterator coordIter = coords.getIndexIterator();
            IndexIterator boundsIter = bounds.getIndexIterator();
            while (coordIter.hasNext()) {
                double coordValue = coordIter.getDoubleNext();
                if (!boundsIter.hasNext()) break;
                double bounds1 = boundsIter.getDoubleNext();
                if (boundsIter.hasNext()) {
                    double bounds2 = boundsIter.getDoubleNext();
                    f.format("%3d: %s (%s,%s)%n", count++, this.makeCalendarDateStringOrMissing(cdu, coordValue), this.makeCalendarDateStringOrMissing(cdu, bounds1), this.makeCalendarDateStringOrMissing(cdu, bounds2));
                    continue;
                }
                break;
            }
        } else {
            ArrayDouble.D2 coords = axis2D.getCoordValuesArray();
            IndexIterator coordIter = coords.getIndexIterator();
            while (coordIter.hasNext()) {
                double coordValue = coordIter.getDoubleNext();
                f.format("%3d: %s%n", count++, this.makeCalendarDateStringOrMissing(cdu, coordValue));
            }
        }
        this.infoTA.appendLine(f.toString());
    }

    private String makeCalendarDateStringOrMissing(CalendarDateUnit cdu, double value) {
        if (Double.isNaN(value)) {
            return "missing";
        }
        return cdu.makeFractionalCalendarDate(value).toString();
    }

    private String getCalendarAttribute(Variable vds) {
        Attribute cal = vds.findAttribute("calendar");
        return cal == null ? null : cal.getStringValue();
    }

    private void showDates1D(CoordinateAxis1D axis1D, CalendarDateUnit cdu) {
        if (!axis1D.isInterval()) {
            for (double val : axis1D.getCoordValues()) {
                if (Double.isNaN(val)) {
                    this.infoTA.appendLine(" N/A");
                    continue;
                }
                this.infoTA.appendLine(" " + cdu.makeFractionalCalendarDate(val));
            }
        } else {
            Formatter f = new Formatter();
            double[] b1 = axis1D.getBound1();
            double[] b2 = axis1D.getBound2();
            for (int i = 0; i < b1.length; ++i) {
                f.format(" (%f, %f) == (%s, %s)%n", b1[i], b2[i], cdu.makeFractionalCalendarDate(b1[i]), cdu.makeFractionalCalendarDate(b2[i]));
            }
            this.infoTA.appendLine(f.toString());
        }
    }

    private void printArray(String title, double[] vals) {
        Formatter sbuff = new Formatter();
        sbuff.format(" %s=", title);
        for (double val : vals) {
            sbuff.format(" %f", val);
        }
        sbuff.format("%n", new Object[0]);
        this.infoTA.appendLine(sbuff.toString());
    }

    private void printArrays(String title, double[] vals, double[] vals2) {
        Formatter sbuff = new Formatter();
        sbuff.format(" %s%n", title);
        for (int i = 0; i < vals.length; ++i) {
            sbuff.format(" %3d: %10.2f  %10.2f%n", i, vals[i], vals2[i]);
        }
        sbuff.format("%n", new Object[0]);
        this.infoTA.appendLine(sbuff.toString());
    }

    public PreferencesExt getPrefs() {
        return this.prefs;
    }

    public void save() {
        this.varTable.saveState(false);
        this.csTable.saveState(false);
        this.axisTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
        if (this.attWindow != null) {
            this.prefs.putBeanObject("AttWindowBounds", (Object)this.attWindow.getBounds());
        }
    }

    public void clear() {
        this.ds = null;
        this.varTable.clearBeans();
        this.axisTable.clearBeans();
        this.csTable.clearBeans();
    }

    public void setDataset(NetcdfDataset ds) {
        this.ds = ds;
        Formatter infolog = new Formatter();
        this.dcl = new DatasetClassifier(ds, infolog);
        List<CoordinateSystemBean> csList = this.getCoordinateSystemBeans(ds);
        ArrayList<VariableBean> beanList = new ArrayList<VariableBean>();
        ArrayList<AxisBean> axisList = new ArrayList<AxisBean>();
        this.setVariables((List<Variable>)ds.getVariables(), axisList, beanList, csList);
        this.varTable.setBeans(beanList);
        this.axisTable.setBeans(axisList);
        this.csTable.setBeans(csList);
    }

    private void setVariables(List<Variable> varList, List<AxisBean> axisList, List<VariableBean> beanList, List<CoordinateSystemBean> csList) {
        for (Variable aVar : varList) {
            VariableEnhanced v = (VariableEnhanced)aVar;
            if (v instanceof CoordinateAxis) {
                axisList.add(new AxisBean((CoordinateAxis)v));
            } else {
                beanList.add(new VariableBean(v, csList));
            }
            if (!(v instanceof Structure)) continue;
            ImmutableList nested = ((Structure)v).getVariables();
            this.setVariables((List<Variable>)nested, axisList, beanList, csList);
        }
    }

    private List<CoordinateSystemBean> getCoordinateSystemBeans(NetcdfDataset ds) {
        ArrayList<CoordinateSystemBean> vlist = new ArrayList<CoordinateSystemBean>();
        for (CoordinateSystem elem : ds.getCoordinateSystems()) {
            vlist.add(new CoordinateSystemBean(elem));
        }
        return vlist;
    }

    private void setSelectedCoordinateAxes(CoordinateSystem cs) {
        ImmutableList axesList = cs.getCoordinateAxes();
        if (axesList.isEmpty()) {
            return;
        }
        CoordinateAxis axis = (CoordinateAxis)axesList.get(0);
        List beans = this.axisTable.getBeans();
        for (Object bean1 : beans) {
            AxisBean bean = (AxisBean)bean1;
            if (bean.axis != axis) continue;
            this.axisTable.setSelectedBean((Object)bean);
            return;
        }
    }

    private String showMissing(Variable v) {
        if (!(v instanceof VariableDS)) {
            return "";
        }
        VariableDS ve = (VariableDS)v;
        Formatter buff = new Formatter();
        buff.format("%s:", v.getFullName());
        buff.format("enhanceMode= %s%n", ve.getEnhanceMode());
        ve.scaleMissingUnsignedProxy().showInfo(buff);
        return buff.toString();
    }

    public static class AxisBean {
        CoordinateAxis axis;
        CoordinateSystem firstCoordSys;
        String name;
        String desc;
        String units;
        String axisType = "";
        String positive = "";
        String incr = "";
        String dims;
        String shape;
        boolean isIndCoord;
        boolean isLayer;
        boolean isInterval;

        public AxisBean() {
        }

        public AxisBean(CoordinateAxis v) {
            CoordinateAxis1D v1;
            String p;
            this.axis = v;
            this.setName(v.getFullName());
            this.setCoordVar(v.isIndependentCoordinate());
            this.setDescription(v.getDescription());
            this.setUnits(v.getUnitsString());
            StringBuilder lens = new StringBuilder();
            StringBuilder names = new StringBuilder();
            ImmutableList dims = v.getDimensions();
            for (int j = 0; j < dims.size(); ++j) {
                Dimension dim = (Dimension)dims.get(j);
                if (j > 0) {
                    lens.append(",");
                    names.append(",");
                }
                String name = dim.isShared() ? dim.getShortName() : "anon";
                names.append(name);
                lens.append(dim.getLength());
            }
            this.setDims(names.toString());
            this.setShape(lens.toString());
            AxisType at = v.getAxisType();
            if (at != null) {
                this.setAxisType(at.toString());
            }
            if ((p = v.getPositive()) != null) {
                this.setPositive(p);
            }
            if (v instanceof CoordinateAxis1D && (v1 = (CoordinateAxis1D)v).isRegular()) {
                this.setRegular(Double.toString(v1.getIncrement()));
            }
            this.isLayer = null != this.axis.findAttribute("_CoordinateZisLayer");
            this.isInterval = this.axis.isInterval();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isIndCoord() {
            return this.isIndCoord;
        }

        public void setCoordVar(boolean isIndCoord) {
            this.isIndCoord = isIndCoord;
        }

        public boolean isContig() {
            return this.axis.isContiguous();
        }

        public boolean isInterval() {
            return this.isInterval;
        }

        public String getShape() {
            return this.shape;
        }

        public void setShape(String shape) {
            this.shape = shape;
        }

        public String getAxisType() {
            return this.axisType;
        }

        public void setAxisType(String axisType) {
            this.axisType = axisType;
        }

        public String getDims() {
            return this.dims;
        }

        public void setDims(String dims) {
            this.dims = dims;
        }

        public String getDescription() {
            return this.desc;
        }

        public void setDescription(String desc) {
            this.desc = desc;
        }

        public String getUnits() {
            return this.units;
        }

        public void setUnits(String units) {
            this.units = units == null ? "null" : units;
        }

        public String getPositive() {
            return this.positive;
        }

        public void setPositive(String positive) {
            this.positive = positive;
        }

        public String getRegular() {
            return this.incr;
        }

        public void setRegular(String incr) {
            this.incr = incr;
        }
    }

    public static class AttributeBean {
        private final Group group;
        private final Attribute att;

        public AttributeBean(Group group, Attribute att) {
            this.group = group;
            this.att = att;
        }

        public String getName() {
            return this.group.isRoot() ? this.att.getName() : this.group.getFullName() + "/" + this.att.getName();
        }

        public String getValue() {
            ucar.array.Array value = this.att.getArrayValues();
            return NcdumpArray.printArray((ucar.array.Array)value, null, null);
        }
    }

    public class CoordinateSystemBean {
        CoordinateSystem coordSys;
        private String name;
        private String ctNames;
        private String dataType = "";
        private int domainRank;
        private int rangeRank;
        private boolean isGeoXY;
        private boolean isLatLon;
        private boolean isProductSet;
        private boolean isRegular;

        public CoordinateSystemBean() {
        }

        public CoordinateSystemBean(CoordinateSystem cs) {
            this.coordSys = cs;
            this.setCoordSys(cs.getName());
            this.setGeoXY(cs.isGeoXY());
            this.setLatLon(cs.isLatLon());
            this.setProductSet(cs.isProductSet());
            this.setRegular(cs.isRegular());
            this.setDomainRank(cs.getDomain().size());
            this.setRangeRank(cs.getCoordinateAxes().size());
            if (CoordSysTable.this.dcl.getCoordinateSystemsUsed().stream().filter(dsc -> dsc.getCoordinateSystem().equals((Object)cs)).findAny().isPresent()) {
                this.addDataType("grid");
            }
            Formatter buff = new Formatter();
            ImmutableList ctList = cs.getCoordinateTransforms();
            for (CoordinateTransform ct : ctList) {
                if (ct instanceof VerticalCT) {
                    buff.format("V", new Object[0]);
                }
                if (!(ct instanceof ProjectionCT)) continue;
                buff.format("P", new Object[0]);
            }
            this.setCoordTransforms(buff.toString());
        }

        public String getCoordSys() {
            return this.name;
        }

        public void setCoordSys(String name) {
            this.name = name;
        }

        public boolean isGeoXY() {
            return this.isGeoXY;
        }

        public void setGeoXY(boolean isGeoXY) {
            this.isGeoXY = isGeoXY;
        }

        public boolean getLatLon() {
            return this.isLatLon;
        }

        public void setLatLon(boolean isLatLon) {
            this.isLatLon = isLatLon;
        }

        public boolean isProductSet() {
            return this.isProductSet;
        }

        public void setProductSet(boolean isProductSet) {
            this.isProductSet = isProductSet;
        }

        public boolean isRegular() {
            return this.isRegular;
        }

        public void setRegular(boolean isRegular) {
            this.isRegular = isRegular;
        }

        public int getDomainRank() {
            return this.domainRank;
        }

        public void setDomainRank(int domainRank) {
            this.domainRank = domainRank;
        }

        public int getRangeRank() {
            return this.rangeRank;
        }

        public void setRangeRank(int rangeRank) {
            this.rangeRank = rangeRank;
        }

        public String getCoordTransforms() {
            return this.ctNames;
        }

        public void setCoordTransforms(String ctNames) {
            this.ctNames = ctNames;
        }

        public String getDataType() {
            return this.dataType;
        }

        void addDataType(String dt) {
            this.dataType = this.dataType + " " + dt;
        }

        public boolean isImplicit() {
            return this.coordSys.isImplicit();
        }
    }

    public class VariableBean {
        Variable v;
        VariableEnhanced ve;
        CoordinateSystemBean coordSysBean;
        String name;
        String desc;
        String units;
        String dims;
        String shape;

        public VariableBean() {
        }

        public VariableBean(VariableEnhanced ve, List<CoordinateSystemBean> csList) {
            this.v = (Variable)ve;
            this.ve = ve;
            this.name = this.v.getFullName();
            this.desc = this.v.getDescription();
            this.units = this.v.getUnitsString();
            boolean first = true;
            StringBuilder lens = new StringBuilder();
            StringBuilder names = new StringBuilder();
            for (Dimension dim : this.v.getDimensions()) {
                if (!first) {
                    lens.append(",");
                    names.append(",");
                }
                String name = dim.isShared() ? dim.getShortName() : "anon";
                names.append(name);
                lens.append(dim.getLength());
                first = false;
            }
            this.dims = names.toString();
            this.shape = lens.toString();
            if (!ve.getCoordinateSystems().isEmpty()) {
                ArrayList css = new ArrayList(ve.getCoordinateSystems());
                css.sort((o1, o2) -> o2.getCoordinateAxes().size() - o1.getCoordinateAxes().size());
                CoordinateSystem cs = (CoordinateSystem)css.get(0);
                for (CoordinateSystemBean csBean : csList) {
                    if (cs != csBean.coordSys) continue;
                    this.coordSysBean = csBean;
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public String getDims() {
            return this.dims;
        }

        public String getShape() {
            return this.shape;
        }

        public String getDescription() {
            return this.desc == null ? "null" : this.desc;
        }

        public String getUnits() {
            return this.units == null ? "null" : this.units;
        }

        @Nullable
        public String getAbbrev() {
            return this.v.attributes().findAttributeString("abbreviation", null);
        }

        public String getCoordSys() {
            return this.coordSysBean == null ? "" : this.coordSysBean.getCoordSys();
        }

        public String getArrayType() {
            return this.v.getArrayType().toString();
        }
    }
}

