/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.op;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.NetcdfFile;
import ucar.ui.OpPanel;
import ucar.ui.ToolsUI;
import ucar.ui.op.DatasetViewer;
import ucar.ui.widget.BAMutil;
import ucar.util.prefs.PreferencesExt;

public class DatasetViewerPanel
extends OpPanel {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final DatasetViewer dsViewer;
    private NetcdfFile ncfile;

    public DatasetViewerPanel(PreferencesExt dbPrefs) {
        super(dbPrefs, "dataset:");
        this.dsViewer = new DatasetViewer(dbPrefs, fileChooser);
        this.dsViewer.setUseCoords(this.useCoords);
        this.add((Component)this.dsViewer, "Center");
        AbstractButton infoButton = BAMutil.makeButtcon((String)"Information", (String)"Detail Info", (boolean)false);
        infoButton.addActionListener(e -> {
            if (this.ncfile != null) {
                this.detailTA.setText(this.ncfile.getDetailInfo());
                this.detailTA.gotoTop();
                this.detailWindow.show();
            }
        });
        this.buttPanel.add(infoButton);
        AbstractAction dumpAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NetcdfFile ds = DatasetViewerPanel.this.dsViewer.getDataset();
                if (ds != null) {
                    logger.debug("setNCdumpPanel");
                    ToolsUI.setNCdumpPanel(ds);
                }
            }
        };
        BAMutil.setActionProperties((AbstractAction)dumpAction, (String)"Dump", (String)"NCDump", (boolean)false, (int)68, (int)-1);
        BAMutil.addActionToContainer((Container)this.buttPanel, (Action)dumpAction);
        this.dsViewer.addActions(this.buttPanel);
    }

    @Override
    public boolean process(Object o) {
        String location = (String)o;
        boolean err = false;
        try {
            if (this.ncfile != null) {
                this.ncfile.close();
            }
        }
        catch (IOException ioe) {
            logger.warn("close failed");
        }
        try {
            NetcdfFile ncnew = ToolsUI.getToolsUI().openFile(location, this.useCoords, null);
            if (ncnew != null) {
                this.setDataset(ncnew);
            }
        }
        catch (Exception ioe) {
            StringWriter sw = new StringWriter(5000);
            ioe.printStackTrace(new PrintWriter(sw));
            this.detailTA.setText(sw.toString());
            this.detailWindow.show();
            err = true;
        }
        return !err;
    }

    @Override
    public void closeOpenFiles() throws IOException {
        if (this.ncfile != null) {
            this.ncfile.close();
        }
        this.ncfile = null;
        this.dsViewer.clear();
    }

    public void setDataset(NetcdfFile nc) {
        try {
            if (this.ncfile != null) {
                this.ncfile.close();
            }
            this.ncfile = null;
        }
        catch (IOException ioe) {
            logger.warn("close failed");
        }
        this.ncfile = nc;
        if (nc != null) {
            this.dsViewer.setDataset(nc);
            this.setSelectedItem(nc.getLocation());
        }
    }

    @Override
    public void save() {
        super.save();
        this.dsViewer.save();
    }

    @Override
    protected void setUseCoords(boolean useCoords) {
        this.dsViewer.setUseCoords(useCoords);
    }

    public void setText(String text) {
        this.detailTA.setText(text);
    }

    public void appendLine(String text) {
        this.detailTA.appendLine(text);
    }
}

