/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.op;

import java.awt.Component;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.NetcdfFile;
import ucar.ui.OpPanel;
import ucar.ui.ToolsUI;
import ucar.ui.op.DatasetWriter;
import ucar.util.prefs.PreferencesExt;

public class DatasetWriterPanel
extends OpPanel {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final DatasetWriter dsWriter;
    private NetcdfFile ncfile;

    public DatasetWriterPanel(PreferencesExt dbPrefs) {
        super(dbPrefs, "dataset:");
        this.dsWriter = new DatasetWriter(dbPrefs, fileChooser);
        this.add((Component)this.dsWriter, "Center");
        this.dsWriter.addActions(this.buttPanel);
    }

    @Override
    public boolean process(Object o) {
        String command = (String)o;
        boolean err = false;
        try {
            if (this.ncfile != null) {
                this.ncfile.close();
            }
        }
        catch (IOException ioe) {
            logger.warn("close failed");
        }
        try {
            NetcdfFile ncnew = ToolsUI.getToolsUI().openFile(command, this.useCoords, null);
            if (ncnew != null) {
                this.setDataset(ncnew);
            }
        }
        catch (Exception ioe) {
            StringWriter sw = new StringWriter(5000);
            ioe.printStackTrace(new PrintWriter(sw));
            this.detailTA.setText(sw.toString());
            this.detailWindow.show();
            err = true;
        }
        return !err;
    }

    @Override
    public void closeOpenFiles() throws IOException {
        if (this.ncfile != null) {
            this.ncfile.close();
        }
        this.ncfile = null;
    }

    void setDataset(NetcdfFile nc) {
        try {
            if (this.ncfile != null) {
                this.ncfile.close();
            }
            this.ncfile = null;
        }
        catch (IOException ioe) {
            logger.warn("close failed");
        }
        this.ncfile = nc;
        if (nc != null) {
            this.dsWriter.setDataset(nc);
            this.setSelectedItem(nc.getLocation());
        }
    }

    @Override
    public void save() {
        super.save();
        this.dsWriter.save();
    }
}

