/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.op;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.geoloc.vertical.VerticalTransform;
import ucar.nc2.grid.GridCoordinateSystem;
import ucar.nc2.internal.grid.GridNetcdfDataset;

public class FeatureScan {
    private final String top;
    private final boolean subdirs;
    private static final boolean debug = true;

    public FeatureScan(String top, boolean subdirs) {
        this.top = top;
        this.subdirs = subdirs;
    }

    public List<Bean> scan(Formatter errlog) {
        ArrayList<Bean> result = new ArrayList<Bean>();
        File topFile = new File(this.top);
        if (!topFile.exists()) {
            errlog.format("File %s does not exist", this.top);
            return result;
        }
        if (topFile.isDirectory()) {
            this.scanDirectory(topFile, result);
        } else {
            Bean fdb = new Bean(topFile);
            result.add(fdb);
        }
        return result;
    }

    private void scanDirectory(File dir, List<Bean> result) {
        if (dir.getName().equals("exclude") || dir.getName().equals("problem")) {
            return;
        }
        File[] fila = dir.listFiles();
        if (fila == null) {
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (File f : fila) {
            if (f.isDirectory()) continue;
            files.add(f);
        }
        if (!files.isEmpty()) {
            Collections.sort(files);
            ArrayList files2 = new ArrayList(files);
            File prev = null;
            for (File f : files) {
                String name = f.getName();
                String stem = this.stem(name);
                if (name.startsWith(".nfs") || name.contains(".gbx") || name.endsWith(".xml") || name.endsWith(".pdf") || name.endsWith(".txt") || name.endsWith(".tar") || name.endsWith(".tmp") || name.endsWith(".dump") || name.endsWith(".gitignore")) {
                    files2.remove(f);
                } else if (prev != null) {
                    if (name.endsWith(".ncml")) {
                        if (prev.getName().equals(stem) || prev.getName().equals(stem + ".nc")) {
                            files2.remove(prev);
                        }
                    } else if (name.endsWith(".bz2")) {
                        if (prev.getName().equals(stem)) {
                            files2.remove(f);
                        }
                    } else if (name.endsWith(".gz")) {
                        if (prev.getName().equals(stem)) {
                            files2.remove(f);
                        }
                    } else if (name.endsWith(".gzip")) {
                        if (prev.getName().equals(stem)) {
                            files2.remove(f);
                        }
                    } else if (name.endsWith(".zip")) {
                        if (prev.getName().equals(stem)) {
                            files2.remove(f);
                        }
                    } else if (name.endsWith(".Z") && prev.getName().equals(stem)) {
                        files2.remove(f);
                    }
                }
                prev = f;
            }
            for (File f : files2) {
                result.add(new Bean(f));
            }
        }
        if (this.subdirs) {
            for (File f : fila) {
                if (!f.isDirectory() || f.getName().equals("exclude")) continue;
                this.scanDirectory(f, result);
            }
        }
    }

    private String stem(String name) {
        int pos = name.lastIndexOf(46);
        return pos > 0 ? name.substring(0, pos) : name;
    }

    public static void main(String[] arg) {
        String usage = "usage: ucar.nc2.ft.scan.FeatureScan directory [-subdirs]";
        if (arg.length < 1) {
            System.out.println(usage);
            System.exit(0);
        }
        boolean subdirs = false;
        for (int i = 1; i < arg.length; ++i) {
            String s = arg[i];
            if (!s.equalsIgnoreCase("-subdirs")) continue;
            subdirs = true;
        }
        FeatureScan scanner = new FeatureScan(arg[0], subdirs);
        System.out.printf(" %-60s %-20s %-10s %-10s%n", "name", "fileType", "featureType", "featureImpl");
        List<Bean> beans = scanner.scan(new Formatter());
        for (Bean b : beans) {
            System.out.printf(" %-60s %-20s %n", b.getName(), b.getFileType());
        }
    }

    public static class Bean {
        public File f;
        String fileType;
        Formatter gribType = new Formatter();
        StringBuilder info = new StringBuilder();
        Throwable problem;
        String newGridFn = null;
        Set<String> ctNames = new HashSet<String>();
        Set<String> vctNames = new HashSet<String>();

        public Bean() {
        }

        public Bean(File f) {
            this.f = f;
            System.out.printf(" featureScan=%s%n", f.getPath());
            try (NetcdfDataset ds = NetcdfDatasets.openDataset((String)f.getPath());){
                this.fileType = ds.getFileTypeId();
                Formatter errlog = new Formatter();
                this.findGribType(ds.getRootGroup(), this.gribType);
                for (CoordinateTransform ct : ds.getCoordinateTransforms()) {
                    if (!(ct instanceof VerticalCT)) continue;
                    this.ctNames.add(((VerticalCT)ct).transformName());
                }
                try {
                    GridNetcdfDataset gridDataset;
                    errlog = new Formatter();
                    Optional grido = GridNetcdfDataset.create((NetcdfDataset)ds, (Formatter)errlog);
                    if (grido.isPresent() && !Iterables.isEmpty((Iterable)(gridDataset = (GridNetcdfDataset)grido.get()).getGrids())) {
                        for (GridCoordinateSystem gcs : gridDataset.getGridCoordinateSystems()) {
                            VerticalTransform vt = gcs.getVerticalTransform();
                            if (vt == null) continue;
                            this.vctNames.add(vt.getName());
                        }
                        this.newGridFn = ((GridCoordinateSystem)gridDataset.getGridCoordinateSystems().get(0)).showFnSummary();
                    }
                    this.info.append("\nGridNetcdfDataset errlog = ");
                    this.info.append(errlog);
                    this.info.append("\n\n");
                }
                catch (Throwable t) {
                    this.info.append(errlog);
                    this.problem = t;
                }
            }
            catch (Throwable t) {
                this.fileType = " ERR: " + t.getMessage();
                this.problem = t;
            }
        }

        private void findGribType(Group group, Formatter f) {
            Attribute att = group.findAttribute("GribCollectionType");
            if (att != null) {
                f.format("%s ", att.getStringValue());
            }
            for (Group nested : group.getGroups()) {
                this.findGribType(nested, f);
            }
        }

        public String getName() {
            int pos;
            Object path = this.f.getPath();
            if (((String)path).contains("/cdmUnitTest/")) {
                pos = ((String)path).indexOf("/cdmUnitTest/");
                path = ".." + ((String)path).substring(pos);
            }
            if (((String)path).contains("/core/src/test/data/")) {
                pos = ((String)path).indexOf("/core/src/test/data/");
                path = ".." + ((String)path).substring(pos);
            }
            return path;
        }

        public String getFileType() {
            return this.fileType;
        }

        public double getSizeM() {
            return (double)this.f.length() / 1000.0 / 1000.0;
        }

        public String getNewGrid() {
            return this.newGridFn;
        }

        public String getCoordinateVTs() {
            return String.join((CharSequence)",", this.ctNames);
        }

        public String getGridVTs() {
            return String.join((CharSequence)",", this.vctNames);
        }

        public String getGribType() {
            return this.gribType.toString();
        }

        public void toString(Formatter f, boolean showInfo) {
            f.format("%s%n %s%n%n", this.getName(), this.getFileType());
            if (this.newGridFn != null) {
                f.format("GridCoordinateSystem %s%n", this.newGridFn);
            }
            if (showInfo && this.info != null) {
                f.format("%n%s", this.info);
            }
            if (this.problem != null) {
                StringWriter sw = new StringWriter(5000);
                this.problem.printStackTrace(new PrintWriter(sw));
                f.format(sw.toString(), new Object[0]);
            }
        }

        public String toString() {
            Formatter f = new Formatter();
            this.toString(f, true);
            return f.toString();
        }
    }
}

