/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.op;

import java.awt.Component;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.util.CancelTask;
import ucar.nc2.write.Ncdump;
import ucar.ui.GetDataRunnable;
import ucar.ui.GetDataTask;
import ucar.ui.OpPanel;
import ucar.ui.widget.ProgressMonitorTask;
import ucar.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public class NCdumpPanel
extends OpPanel
implements GetDataRunnable {
    private GetDataTask task;
    private NetcdfFile ncfile;
    private String filename;
    private String command;
    private String result;
    private final TextHistoryPane ta = new TextHistoryPane(true);

    public NCdumpPanel(PreferencesExt prefs) {
        super(prefs, "command:");
        this.add((Component)this.ta, "Center");
        this.stopButton.addActionListener(e -> {
            if (this.task.isSuccess()) {
                this.ta.setText(this.result);
            } else {
                this.ta.setText(this.task.getErrorMessage());
            }
            if (this.task.isCancel()) {
                this.ta.appendLine("\n***Cancelled by User");
            }
            this.ta.gotoTop();
        });
    }

    @Override
    public void closeOpenFiles() throws IOException {
        if (this.ncfile != null) {
            this.ncfile.close();
        }
        this.ncfile = null;
    }

    @Override
    public boolean process(Object o) {
        int pos;
        String input = ((String)o).trim();
        if (input.indexOf(34) == 0 && (pos = input.indexOf(34, 1)) > 0) {
            this.filename = input.substring(1, pos);
            this.command = input.substring(pos + 1);
        } else if (input.indexOf(39) == 0 && (pos = input.indexOf(39, 1)) > 0) {
            this.filename = input.substring(1, pos);
            this.command = input.substring(pos + 1);
        } else {
            pos = input.indexOf(32);
            if (pos > 0) {
                this.filename = input.substring(0, pos);
                this.command = input.substring(pos);
            } else {
                this.filename = input;
                this.command = null;
            }
        }
        this.task = new GetDataTask(this, this.filename, null);
        this.stopButton.startProgressMonitorTask((ProgressMonitorTask)this.task);
        return true;
    }

    @Override
    public void run(Object o) throws IOException {
        try {
            if (this.useCoords) {
                this.ncfile = NetcdfDatasets.openDataset((String)this.filename, (boolean)true, null);
            } else {
                DatasetUrl durl = DatasetUrl.findDatasetUrl((String)this.filename);
                this.ncfile = NetcdfDatasets.openFile((DatasetUrl)durl, (int)-1, null, null);
            }
            StringWriter sw = new StringWriter(50000);
            Ncdump.ncdump((NetcdfFile)this.ncfile, (String)this.command, (Writer)sw, (CancelTask)this.task);
            this.result = sw.toString();
        }
        finally {
            try {
                if (this.ncfile != null) {
                    this.ncfile.close();
                }
                this.ncfile = null;
            }
            catch (IOException ioe) {
                System.out.printf("Error closing %n", new Object[0]);
            }
        }
    }

    public void setNetcdfFile(NetcdfFile ncf) {
        this.ncfile = ncf;
        this.filename = ncf.getLocation();
        GetDataRunnable runner = o -> {
            StringWriter sw = new StringWriter(50000);
            Ncdump.ncdump((NetcdfFile)this.ncfile, (String)this.command, (Writer)sw, (CancelTask)this.task);
            this.result = sw.toString();
        };
        this.task = new GetDataTask(runner, this.filename, null);
        this.stopButton.startProgressMonitorTask((ProgressMonitorTask)this.task);
    }
}

