/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.op;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import org.bounce.text.LineNumberMargin;
import org.bounce.text.ScrollableEditorPanel;
import org.bounce.text.xml.XMLEditorKit;
import org.jdom2.Element;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.IO;
import ucar.nc2.write.Nc4Chunking;
import ucar.nc2.write.Nc4ChunkingStrategy;
import ucar.nc2.write.NcmlWriter;
import ucar.nc2.write.NetcdfCopier;
import ucar.nc2.write.NetcdfFormatWriter;
import ucar.ui.dialog.NetcdfOutputChooser;
import ucar.ui.prefs.ComboBox;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.FileManager;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.TextHistoryPane;
import ucar.unidata.io.http.ReadFromUrl;
import ucar.util.prefs.PersistenceManager;
import ucar.util.prefs.PreferencesExt;

public class NcmlEditor
extends JPanel {
    private static final boolean debugNcmlWrite = false;
    private final PreferencesExt prefs;
    private NetcdfDataset ds;
    private String ncmlLocation;
    private JEditorPane editor;
    private final Map<String, String> protoMap = new HashMap<String, String>(10);
    private final ComboBox<String> protoChooser;
    private TextHistoryPane infoTA;
    private IndependentWindow infoWindow;
    private final FileManager fileChooser;
    private NetcdfOutputChooser outChooser;
    private final AbstractButton coordButt;
    private boolean addCoords;

    public NcmlEditor(JPanel buttPanel, PreferencesExt prefs) {
        this.prefs = prefs;
        this.fileChooser = new FileManager(null, null, null, (PreferencesExt)prefs.node("FileManager"));
        AbstractAction coordAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NcmlEditor.this.addCoords = (Boolean)this.getValue("state");
                String tooltip = NcmlEditor.this.addCoords ? "add Coordinates is ON" : "add Coordinates is OFF";
                NcmlEditor.this.coordButt.setToolTipText(tooltip);
            }
        };
        this.addCoords = prefs.getBoolean("coordState", false);
        String tooltip2 = this.addCoords ? "add Coordinates is ON" : "add Coordinates is OFF";
        BAMutil.setActionProperties((AbstractAction)coordAction, (String)"nj22/AddCoords", (String)tooltip2, (boolean)true, (int)67, (int)-1);
        coordAction.putValue("state", this.addCoords);
        this.coordButt = BAMutil.addActionToContainer((Container)buttPanel, (Action)coordAction);
        this.protoChooser = new ComboBox((PersistenceManager)((PreferencesExt)prefs.node("protoChooser")));
        this.addProtoChoices();
        buttPanel.add((Component)this.protoChooser);
        this.protoChooser.addActionListener(e -> {
            String ptype = (String)this.protoChooser.getSelectedItem();
            String proto = this.protoMap.get(ptype);
            if (proto != null) {
                this.editor.setText(proto);
            }
        });
        this.editor = new JEditorPane();
        XMLEditorKit kit = new XMLEditorKit();
        kit.setAutoIndentation(true);
        kit.setTagCompletion(true);
        kit.setStyle("attribute-name", Color.RED, 1);
        this.editor.setEditorKit((EditorKit)kit);
        this.editor.setFont(new Font("Monospaced", 0, 12));
        this.editor.getDocument().putProperty("tabSize", 2);
        ScrollableEditorPanel editorPanel = new ScrollableEditorPanel(this.editor);
        JScrollPane scroller = new JScrollPane((Component)editorPanel);
        scroller.setRowHeaderView((Component)new LineNumberMargin((JTextComponent)this.editor));
        AbstractAction saveAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String filename;
                int pos;
                String location;
                String string = location = NcmlEditor.this.ds == null ? NcmlEditor.this.ncmlLocation : NcmlEditor.this.ds.getLocation();
                if (location == null) {
                    location = "test";
                }
                if ((pos = location.lastIndexOf(".")) > 0) {
                    location = location.substring(0, pos);
                }
                if ((filename = NcmlEditor.this.fileChooser.chooseFilenameToSave(location + ".ncml")) == null) {
                    return;
                }
                if (NcmlEditor.this.doSaveNcml(NcmlEditor.this.editor.getText(), filename)) {
                    NcmlEditor.this.ncmlLocation = filename;
                }
            }
        };
        BAMutil.setActionProperties((AbstractAction)saveAction, (String)"Save", (String)"Save NcML", (boolean)false, (int)83, (int)-1);
        BAMutil.addActionToContainer((Container)buttPanel, (Action)saveAction);
        AbstractAction netcdfAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int pos;
                String location;
                if (NcmlEditor.this.outChooser == null) {
                    NcmlEditor.this.outChooser = new NetcdfOutputChooser((Frame)null);
                    NcmlEditor.this.outChooser.addPropertyChangeListener("OK", evt -> NcmlEditor.this.writeNetcdf((NetcdfOutputChooser.Data)evt.getNewValue()));
                }
                String string = location = NcmlEditor.this.ds == null ? NcmlEditor.this.ncmlLocation : NcmlEditor.this.ds.getLocation();
                if (location == null) {
                    location = "test";
                }
                if ((pos = location.lastIndexOf(".")) > 0) {
                    location = location.substring(0, pos);
                }
                NcmlEditor.this.outChooser.setOutputFilename(location);
                NcmlEditor.this.outChooser.setVisible(true);
            }
        };
        BAMutil.setActionProperties((AbstractAction)netcdfAction, (String)"nj22/Netcdf", (String)"Write netCDF file", (boolean)false, (int)78, (int)-1);
        BAMutil.addActionToContainer((Container)buttPanel, (Action)netcdfAction);
        AbstractAction transAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NcmlEditor.this.doTransform(NcmlEditor.this.editor.getText());
            }
        };
        BAMutil.setActionProperties((AbstractAction)transAction, (String)"Import", (String)"read textArea through NcMLReader\n write NcML back out via resulting dataset", (boolean)false, (int)84, (int)-1);
        BAMutil.addActionToContainer((Container)buttPanel, (Action)transAction);
        AbstractButton compareButton = BAMutil.makeButtcon((String)"Select", (String)"Check NcML", (boolean)false);
        compareButton.addActionListener(e -> {
            Formatter f = new Formatter();
            this.checkNcml(f);
            this.infoTA.setText(f.toString());
            this.infoTA.gotoTop();
            this.infoWindow.show();
        });
        buttPanel.add(compareButton);
        this.setLayout(new BorderLayout());
        this.add((Component)scroller, "Center");
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 500, 300)));
    }

    public void save() {
        this.fileChooser.save();
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
    }

    public void closeOpenFiles() {
        try {
            if (this.ds != null) {
                this.ds.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.ds = null;
    }

    public boolean setNcml(String cmd) {
        if (((String)cmd).endsWith(".xml") || ((String)cmd).endsWith(".ncml")) {
            if (!((String)cmd).startsWith("http:") && !((String)cmd).startsWith("file:")) {
                cmd = "file:" + (String)cmd;
            }
            this.ncmlLocation = cmd;
            try {
                String text = ReadFromUrl.readURLcontents((String)cmd);
                this.editor.setText(text);
            }
            catch (IOException ioe) {
                this.editor.setText(ioe.getMessage());
            }
        } else {
            this.writeNcml((String)cmd);
        }
        return true;
    }

    boolean writeNcml(String location) {
        boolean err = false;
        this.closeOpenFiles();
        try {
            this.ds = this.openDataset(location, this.addCoords, null);
            if (this.ds == null) {
                this.editor.setText("Failed to open <" + location + ">");
            } else {
                NcmlWriter ncmlWriter = new NcmlWriter();
                Element netcdfElem = ncmlWriter.makeNetcdfElement((NetcdfFile)this.ds, null);
                String result = ncmlWriter.writeToString(netcdfElem);
                this.editor.setText(result);
                this.editor.setCaretPosition(0);
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter(10000);
            e.printStackTrace();
            e.printStackTrace(new PrintWriter(sw));
            this.editor.setText(sw.toString());
            err = true;
        }
        return !err;
    }

    private NetcdfDataset openDataset(String location, boolean addCoords, CancelTask task) {
        try {
            return NetcdfDatasets.openDataset((String)location, (boolean)addCoords, (CancelTask)task);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, "NetcdfDatasets.open cannot open " + ioe.getMessage());
            if (!(ioe instanceof FileNotFoundException)) {
                ioe.printStackTrace();
            }
            return null;
        }
    }

    void writeNetcdf(NetcdfOutputChooser.Data data) {
        String text = this.editor.getText();
        try (NetcdfDataset ncd = NetcdfDatasets.openNcmlDataset((Reader)new StringReader(text), null, null);){
            NetcdfFormatWriter.Builder writer = NetcdfFormatWriter.builder().setFormat(data.format).setChunker(Nc4ChunkingStrategy.factory((Nc4Chunking.Strategy)data.chunkerType, (int)data.deflate, (boolean)data.shuffle)).setLocation(data.outputFilename);
            try (NetcdfCopier copier = NetcdfCopier.create((NetcdfFile)ncd, (NetcdfFormatWriter.Builder)writer);){
                copier.write(null);
            }
        }
        catch (Exception exc) {
            JOptionPane.showMessageDialog(this, "ERROR: " + exc.getMessage());
            exc.printStackTrace();
            return;
        }
        JOptionPane.showMessageDialog(this, "File successfully written");
    }

    void doTransform(String text) {
        try (StringReader reader = new StringReader(text);
             NetcdfDataset ncd = NetcdfDatasets.openNcmlDataset((Reader)reader, null, null);
             StringWriter sw = new StringWriter(10000);){
            ncd.writeNcml((Writer)sw, null);
            this.editor.setText(sw.toString());
            this.editor.setCaretPosition(0);
            JOptionPane.showMessageDialog(this, "File successfully transformed");
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
            ioe.printStackTrace();
        }
    }

    private void checkNcml(Formatter f) {
        if (this.ncmlLocation == null) {
            return;
        }
        try (NetcdfDataset ncd = NetcdfDatasets.openDataset((String)this.ncmlLocation);){
            for (Variable v : ncd.getVariables()) {
                Variable orgVar;
                VariableDS vds = (VariableDS)v;
                if (vds.getOriginalArrayType() != vds.getArrayType()) {
                    f.format("Variable %s has type %s, org = %s%n", vds.getFullName(), vds.getOriginalArrayType(), vds.getArrayType());
                }
                if ((orgVar = vds.getOriginalVariable()) == null || orgVar.getRank() == vds.getRank()) continue;
                f.format("Variable %s has rank %d, org = %d%n", vds.getFullName(), vds.getRank(), orgVar.getRank());
            }
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
            ioe.printStackTrace();
        }
    }

    boolean doSaveNcml(String text, String filename) {
        int val;
        File out = new File(filename);
        if (out.exists() && (val = JOptionPane.showConfirmDialog(null, filename + " already exists. Do you want to overwrite?", "WARNING", 0)) != 0) {
            return false;
        }
        try {
            IO.writeToFile((String)text, (File)out);
            JOptionPane.showMessageDialog(this, "File successfully written");
            return true;
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
            ioe.printStackTrace();
            return false;
        }
    }

    void addProtoChoices() {
        String xml = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'>\n  <variable name='time' type='int' shape='time'>\n    <attribute name='long_name' type='string' value='time coordinate' />\n    <attribute name='units' type='string' value='days since 2001-8-31 00:00:00 UTC' />\n    <values start='0' increment='10' />\n  </variable>\n  <aggregation dimName='time' type='joinNew'>\n    <variableAgg name='T'/>\n    <scan location='src/test/data/ncml/nc/' suffix='.nc' subdirs='false'/>\n  </aggregation>\n</netcdf>";
        this.protoMap.put("joinNew", xml);
        this.protoChooser.addItem((Object)"joinNew");
        xml = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'>\n  <aggregation dimName='time' type='joinExisting'>\n    <scan location='ncml/nc/pfeg/' suffix='.nc' />\n  </aggregation>\n</netcdf>";
        this.protoMap.put("joinExisting", xml);
        this.protoChooser.addItem((Object)"joinExisting");
    }
}

