/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import ucar.nc2.util.IO;

public class HttpUtils {
    public static HttpResult putToURL(String urlString, String contents) {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            return new HttpResult(-1, "** MalformedURLException on URL (" + urlString + ")\n" + e.getMessage());
        }
        try {
            HttpURLConnection c = (HttpURLConnection)url.openConnection();
            c.setDoOutput(true);
            c.setRequestMethod("PUT");
            try (OutputStream out = c.getOutputStream();){
                BufferedOutputStream bout = new BufferedOutputStream(out);
                IO.copy((InputStream)new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8)), (OutputStream)bout);
            }
            int code = c.getResponseCode();
            String mess = c.getResponseMessage();
            return new HttpResult(code, mess);
        }
        catch (ConnectException e) {
            return new HttpResult(-2, "** ConnectException on URL: <" + urlString + ">\n" + e.getMessage() + "\nServer probably not running");
        }
        catch (IOException e) {
            return new HttpResult(-3, "** IOException on URL: (" + urlString + ")\n" + e.getMessage());
        }
    }

    public static class HttpResult {
        public int statusCode;
        public String message;

        HttpResult(int code, String message) {
            this.statusCode = code;
            this.message = message;
        }
    }
}

