/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.util;

import java.util.ArrayList;
import java.util.List;
import ucar.nc2.calendar.CalendarDate;
import ucar.nc2.calendar.CalendarDateFormatter;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.grid.Grid;
import ucar.nc2.grid.GridAxis;
import ucar.nc2.grid.GridAxisPoint;
import ucar.nc2.grid.GridTimeCoordinateSystem;
import ucar.ui.util.NamedObject;

public class NamedObjects {
    public static List<NamedObject> getNames(CoordinateAxis1DTime axis) {
        if (axis == null) {
            return new ArrayList<NamedObject>();
        }
        List cdates = axis.getCalendarDates();
        ArrayList<NamedObject> names = new ArrayList<NamedObject>(cdates.size());
        for (CalendarDate cd : cdates) {
            names.add(NamedObject.create((Object)CalendarDateFormatter.toDateTimeStringISO((CalendarDate)cd), (String)axis.getShortName()));
        }
        return names;
    }

    public static List<NamedObject> getNames(CoordinateAxis1D axis) {
        if (axis == null) {
            return new ArrayList<NamedObject>();
        }
        ArrayList<NamedObject> names = new ArrayList<NamedObject>();
        int i = 0;
        while ((long)i < axis.getSize()) {
            names.add(NamedObject.create((Object)axis.getCoordName(i), (String)(axis.getShortName() + " " + axis.getUnitsString())));
            ++i;
        }
        return names;
    }

    public static List<NamedObject> getGridNames(Iterable<Grid> grids) {
        if (grids == null) {
            return new ArrayList<NamedObject>();
        }
        ArrayList<NamedObject> result = new ArrayList<NamedObject>();
        for (Grid grid : grids) {
            result.add(NamedObject.create((String)grid.getName(), (String)grid.getDescription(), (Object)grid));
        }
        return result;
    }

    public static List<NamedObject> getCoordNames(GridAxis<?> axis) {
        if (axis == null) {
            return new ArrayList<NamedObject>();
        }
        ArrayList<NamedObject> result = new ArrayList<NamedObject>();
        for (Object coord : axis) {
            result.add(NamedObject.create(coord, (String)axis.getUnits()));
        }
        return result;
    }

    public static List<NamedObject> getTimeNames(GridTimeCoordinateSystem tcs, int runtimeIdx, GridAxisPoint axis) {
        if (tcs == null || axis == null) {
            return new ArrayList<NamedObject>();
        }
        ArrayList<NamedObject> result = new ArrayList<NamedObject>();
        for (CalendarDate cdate : tcs.getTimesForRuntime(runtimeIdx)) {
            result.add(NamedObject.create((Object)cdate, (String)axis.getAxisType().toString()));
        }
        return result;
    }
}

