/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.widget;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import thredds.client.catalog.DateType;
import thredds.client.catalog.TimeCoverage;
import thredds.client.catalog.TimeDuration;
import thredds.ui.datatype.prefs.DateField;
import thredds.ui.datatype.prefs.DurationField;
import ucar.nc2.calendar.CalendarDate;
import ucar.ui.event.ActionSourceListener;
import ucar.ui.event.ActionValueEvent;
import ucar.ui.event.ActionValueListener;
import ucar.ui.prefs.Field;
import ucar.ui.prefs.FieldValidator;
import ucar.ui.prefs.PrefPanel;
import ucar.ui.widget.HelpWindow;

public class RangeDateSelector
extends JPanel
implements FieldValidator {
    public static final String TIME_START = "start";
    public static final String TIME_END = "end";
    public static final String TIME_DURATION = "duration";
    public static final String TIME_RESOLUTION = "resolution";
    private static final int SLIDER_RESOLUTION = 1000;
    private static final String actionName = "rangeDateSelection";
    private final String title;
    private final String helpMessage;
    private boolean acceptButton;
    private final boolean enableButton;
    private final boolean isPointOnly;
    private final boolean useLimits;
    private DateType minLimit;
    private DateType maxLimit;
    private TimeCoverage dateRange;
    private Scale scale;
    private JSlider minSlider;
    private JSlider maxSlider;
    private DateField minField;
    private DateField maxField;
    private DurationField durationField;
    private DurationField resolutionField;
    private PrefPanel pp;
    private JLabel minLabel;
    private JLabel maxLabel;
    private JButton helpButton;
    private JToggleButton disableButton;
    private HelpWindow helpWindow;
    private ActionSourceListener actionSource;
    private boolean eventOK = true;
    private static boolean debugEvent;
    private static boolean debugEvent2;

    public RangeDateSelector(String title, String start, String end, String durationS, String minInterval, boolean enableButton, boolean acceptButton, String help, boolean pointOnly) throws Exception {
        this(title, TimeCoverage.create((DateType)(start == null ? null : DateType.parse((String)start)), (DateType)(end == null ? null : DateType.parse((String)end)), (TimeDuration)(durationS == null ? null : TimeDuration.parse((String)durationS)), (TimeDuration)(minInterval == null ? null : TimeDuration.parse((String)minInterval))), enableButton, acceptButton, help, pointOnly, true);
    }

    public RangeDateSelector(String title, TimeCoverage range, boolean enableButton, boolean acceptButton, String help, boolean pointOnly, boolean useLimits) {
        this.title = title;
        this.dateRange = range;
        this.acceptButton = acceptButton;
        this.enableButton = enableButton;
        this.helpMessage = help;
        this.isPointOnly = pointOnly;
        this.useLimits = useLimits;
        this.init();
    }

    private void init() {
        JPanel topPanel = new JPanel(new BorderLayout());
        JPanel butts = new JPanel();
        if (this.title != null) {
            topPanel.add("West", new JLabel("  " + this.title + ":"));
        }
        if (this.helpMessage != null) {
            this.helpButton = new JButton("help");
            this.helpButton.addActionListener(e -> {
                if (this.helpWindow == null) {
                    this.helpWindow = new HelpWindow(null, "Help on " + this.title, this.helpMessage);
                }
                this.helpWindow.show((Component)this.helpButton);
            });
            butts.add(this.helpButton);
        }
        if (this.acceptButton) {
            JButton okButton = new JButton("accept");
            okButton.addActionListener(e -> {
                this.pp.accept();
                this.sendEvent();
            });
            butts.add(okButton);
            this.acceptButton = false;
        }
        if (this.enableButton) {
            this.disableButton = new JToggleButton("disable", false);
            this.disableButton.addActionListener(e -> {
                boolean b = !this.disableButton.getModel().isSelected();
                this.minField.setEnabled(b);
                this.maxField.setEnabled(b);
                this.durationField.setEnabled(b);
                this.minSlider.setEnabled(b);
                this.maxSlider.setEnabled(b);
            });
            butts.add(this.disableButton);
        }
        topPanel.add("East", butts);
        JPanel sliderPanel = new JPanel();
        sliderPanel.setLayout(new BoxLayout(sliderPanel, 1));
        sliderPanel.setBorder(new LineBorder(Color.black, 1, true));
        this.minSlider = new JSlider(0, 0, 1000, 0);
        this.maxSlider = new JSlider(0, 0, 1000, 1000);
        Border b = BorderFactory.createEmptyBorder(0, 15, 0, 15);
        this.minSlider.setBorder(b);
        this.maxSlider.setBorder(b);
        this.minLabel = new JLabel();
        this.maxLabel = new JLabel();
        this.minField = new DateField(TIME_START, this.isPointOnly ? "value" : TIME_START, this.dateRange.getStart(), null);
        this.maxField = new DateField(TIME_END, TIME_END, this.dateRange.getEnd(), null);
        this.durationField = new DurationField(TIME_DURATION, TIME_DURATION, this.dateRange.getDuration(), null);
        this.resolutionField = new DurationField(TIME_RESOLUTION, TIME_RESOLUTION, this.dateRange.getResolution(), null);
        this.minField.addValidator(this);
        this.maxField.addValidator(this);
        this.durationField.addValidator(this);
        this.setDateRange(this.dateRange);
        JPanel labelPanel = new JPanel(new BorderLayout());
        labelPanel.add((Component)this.minLabel, "West");
        labelPanel.add((Component)this.maxLabel, "East");
        this.pp = new PrefPanel(null, null);
        int row = 0;
        if (this.isPointOnly) {
            this.pp.addField((Field)this.minField, 0, row, null);
        } else {
            this.pp.addField((Field)this.minField, 0, row++, null);
            this.pp.addField((Field)this.maxField, 0, row++, null);
            this.pp.addField((Field)this.durationField, 0, row++, null);
            this.pp.addField((Field)this.resolutionField, 0, row, null);
        }
        this.pp.finish(this.acceptButton, "East");
        this.setLayout(new BorderLayout());
        sliderPanel.add(topPanel);
        sliderPanel.add((Component)this.pp);
        if (this.useLimits) {
            if (!this.isPointOnly) {
                sliderPanel.add(this.maxSlider);
            }
            sliderPanel.add(this.minSlider);
            sliderPanel.add(labelPanel);
        }
        this.add((Component)sliderPanel, "North");
        this.maxSlider.addChangeListener(e -> {
            if (debugEvent2) {
                System.out.println("maxSlider event= " + this.maxSlider.getValue());
            }
            if (!this.eventOK) {
                return;
            }
            int pos = this.maxSlider.getValue();
            this.dateRange = this.dateRange.toBuilder().setEnd(this.scale.slider2world(pos)).build();
            this.synchUI(false);
            if (this.dateRange.isPoint()) {
                this.minSlider.setValue(pos);
            }
        });
        this.minSlider.addChangeListener(e -> {
            if (debugEvent2) {
                System.out.println("minSlider event= " + this.minSlider.getValue());
            }
            if (!this.eventOK) {
                return;
            }
            int pos = this.minSlider.getValue();
            this.dateRange = this.dateRange.toBuilder().setStart(this.scale.slider2world(pos)).build();
            this.synchUI(false);
            if (this.dateRange.isPoint() && !this.isPointOnly) {
                this.maxSlider.setValue(pos);
            }
        });
        this.minField.addPropertyChangeListener(e -> {
            if (debugEvent) {
                System.out.println("minField event= " + e.getNewValue() + " " + e.getNewValue().getClass().getName());
            }
            if (!this.eventOK) {
                return;
            }
            DateType val = (DateType)this.minField.getValue();
            this.dateRange = this.dateRange.toBuilder().setStart(val).build();
            this.synchUI(true);
        });
        if (this.maxField != null) {
            this.maxField.addPropertyChangeListener(e -> {
                if (debugEvent) {
                    System.out.println("maxField event= " + e.getNewValue());
                }
                if (!this.eventOK) {
                    return;
                }
                DateType val = (DateType)this.maxField.getValue();
                this.dateRange = this.dateRange.toBuilder().setEnd(val).build();
                this.synchUI(true);
            });
        }
        if (this.durationField != null) {
            this.durationField.addPropertyChangeListener(e -> {
                if (debugEvent) {
                    System.out.println("durationField event= " + e.getNewValue());
                }
                if (!this.eventOK) {
                    return;
                }
                TimeDuration val = this.durationField.getTimeDuration();
                this.dateRange = this.dateRange.toBuilder().setDuration(val).build();
                this.synchUI(true);
            });
        }
        if (this.resolutionField != null) {
            this.resolutionField.addPropertyChangeListener(e -> {
                if (debugEvent) {
                    System.out.println("resolutionField event= " + e.getNewValue());
                }
                if (!this.eventOK) {
                    return;
                }
                TimeDuration val = this.resolutionField.getTimeDuration();
                this.dateRange = this.dateRange.toBuilder().setResolution(val).build();
            });
        }
        this.actionSource = new ActionSourceListener(actionName){

            public void actionPerformed(ActionValueEvent e) {
                if (debugEvent) {
                    System.out.println(" actionSource event " + e);
                }
            }
        };
    }

    public boolean validate(Field fld, Object editValue, StringBuffer errMessages) {
        DateType checkVal;
        if (!this.useLimits) {
            return true;
        }
        if (fld == this.durationField) {
            TimeDuration duration = (TimeDuration)editValue;
            checkVal = this.dateRange.getEnd().isPresent() ? this.dateRange.getEnd().subtract(duration) : this.dateRange.getStart().add(duration);
        } else {
            checkVal = (DateType)editValue;
        }
        CalendarDate d = checkVal.toCalendarDate();
        if (d.isAfter(this.maxLimit.toCalendarDate()) || d.isBefore(this.minLimit.toCalendarDate())) {
            errMessages.append("Date ");
            errMessages.append(d.toString());
            errMessages.append(" must be between ");
            errMessages.append(this.minLimit.getText());
            errMessages.append(" and ");
            errMessages.append(this.maxLimit.getText());
            return false;
        }
        return true;
    }

    private void synchUI(boolean slidersOK) {
        this.eventOK = false;
        if (slidersOK) {
            this.minSlider.setValue(this.scale.world2slider(this.dateRange.getStart()));
        }
        this.minField.setValue(this.dateRange.getStart());
        if (this.maxField != null) {
            if (slidersOK) {
                this.maxSlider.setValue(this.scale.world2slider(this.dateRange.getEnd()));
            }
            this.maxField.setValue(this.dateRange.getEnd());
        }
        if (this.durationField != null) {
            this.durationField.setValue(this.dateRange.getDuration());
        }
        this.eventOK = true;
    }

    public void setDateRange(TimeCoverage dateRange) {
        this.dateRange = dateRange;
        this.minLimit = dateRange.getStart();
        this.maxLimit = dateRange.getEnd();
        this.scale = new Scale(dateRange);
        this.minLabel.setText(" " + this.minLimit.getText() + " ");
        this.maxLabel.setText(" " + this.maxLimit.getText() + " ");
        if (this.isPointOnly) {
            this.minField.setValue(dateRange.getStart());
        } else {
            this.minField.setValue(dateRange.getStart());
            this.maxField.setValue(dateRange.getEnd());
            this.durationField.setValue(dateRange.getDuration());
            this.resolutionField.setValue(dateRange.getResolution());
        }
    }

    public DateField getMinDateField() {
        return this.minField;
    }

    public DateField getMaxDateField() {
        return this.maxField;
    }

    public DurationField getDurationField() {
        return this.durationField;
    }

    public DurationField getResolutionField() {
        return this.resolutionField;
    }

    @Override
    public boolean isEnabled() {
        return null == this.disableButton || !this.disableButton.getModel().isSelected();
    }

    public TimeCoverage getDateRange() {
        if (!this.pp.accept()) {
            return null;
        }
        return this.dateRange;
    }

    public void sendEvent() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.out.println("event range= " + RangeDateSelector.this.dateRange);
                RangeDateSelector.this.actionSource.fireActionValueEvent(RangeDateSelector.actionName, (Object)this);
            }
        });
    }

    public void addActionValueListener(ActionValueListener l) {
        this.actionSource.addActionValueListener(l);
    }

    public void removeActionValueListener(ActionValueListener l) {
        this.actionSource.removeActionValueListener(l);
    }

    private static class Scale {
        private final double min;
        private final double scale;

        Scale(TimeCoverage dateRange) {
            this.min = 0.001 * (double)dateRange.getStart().toCalendarDate().getMillisFromEpoch();
            this.scale = 1000.0 / dateRange.getDuration().getValueInSeconds();
        }

        private int world2slider(DateType val) {
            double msecs = 0.001 * (double)val.toCalendarDate().getMillisFromEpoch() - this.min;
            return (int)(this.scale * msecs);
        }

        private DateType slider2world(int pval) {
            double val = (double)pval / this.scale;
            double msecs = 1000.0 * (this.min + val);
            return new DateType(CalendarDate.of((long)((long)msecs)));
        }
    }
}

