/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import ucar.nc2.internal.http.HttpService;
import ucar.nc2.util.IO;
import ucar.ui.prefs.ComboBox;
import ucar.ui.util.HttpUtils;
import ucar.ui.widget.TextHistoryPane;
import ucar.unidata.util.Urlencoded;
import ucar.util.prefs.PersistenceManager;
import ucar.util.prefs.PreferencesExt;

public class URLDumpPane
extends TextHistoryPane {
    private static final int MAX_BODY = 50000;
    private final ComboBox<String> cb;
    private final JComboBox<Library> implCB;
    private HttpURLConnection currentConnection;

    public URLDumpPane(PreferencesExt prefs) {
        super(true);
        this.cb = new ComboBox((PersistenceManager)prefs);
        this.implCB = new JComboBox();
        for (Library e2 : Library.values()) {
            this.implCB.addItem(e2);
        }
        JButton buttHead = new JButton("Head");
        buttHead.setToolTipText("Open URL connection, Headers only");
        buttHead.addActionListener(e -> {
            String urlString = (String)this.cb.getSelectedItem();
            this.process(urlString, Command.HEAD);
            this.gotoTop();
            this.cb.addItem((Object)urlString);
        });
        JButton buttRead = new JButton("Get");
        buttRead.setToolTipText("Open URL connection, Get content");
        buttRead.addActionListener(e -> {
            String urlString = (String)this.cb.getSelectedItem();
            this.process(urlString, Command.GET);
            this.gotoTop();
            this.cb.addItem((Object)urlString);
        });
        JPanel buttPanel = new JPanel(new FlowLayout(0, 5, 0));
        buttPanel.add(this.implCB);
        buttPanel.add(buttHead);
        buttPanel.add(buttRead);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)new JLabel("URL:"), "West");
        topPanel.add((Component)this.cb, "Center");
        topPanel.add((Component)buttPanel, "East");
        this.add(topPanel, "North");
    }

    private void process(String urlString, Command cmd) {
        this.clear();
        Library impl = (Library)((Object)this.implCB.getSelectedItem());
        if (impl == Library.HttpService) {
            this.openWithUcarHttpservices(urlString, cmd);
        } else if (impl == Library.HttpURLConnection) {
            if (cmd == Command.GET) {
                this.readURL(urlString);
            } else {
                this.openURL(urlString, cmd);
            }
        }
    }

    @Urlencoded
    private void openWithUcarHttpservices(String urlString, Command cmd) {
        try {
            HttpRequest request = HttpService.standardGetRequestBuilder((String)urlString).build();
            HttpResponse response = HttpService.standardRequestForString((HttpRequest)request);
            HttpHeaders responseHeaders = response.headers();
            this.appendLine("HttpRequest " + cmd + " " + urlString);
            this.printHeaders("Request Headers = ", request.headers());
            this.appendLine(" ");
            this.appendLine("Status Code = " + response.statusCode());
            this.printHeaders("Response Headers = ", responseHeaders);
            if (cmd == Command.GET) {
                this.appendLine("\nResponseBody---------------");
                String body = (String)response.body();
                this.appendLine("  contents length =" + body.length());
                if (body.length() > 50000) {
                    body = body.substring(0, 50000);
                }
                this.appendLine(body);
            }
        }
        catch (IOException e) {
            StringWriter sw = new StringWriter(5000);
            e.printStackTrace(new PrintWriter(sw));
            this.appendLine(sw.toString());
        }
    }

    private void printHeaders(String title, HttpHeaders headers) {
        this.appendLine(title);
        headers.map().forEach((key, value) -> this.appendLine(String.format("  %s: %s", key, value)));
    }

    private void printHeaders(String title, Collection<Map.Entry<String, String>> headers) {
        if (headers.isEmpty()) {
            return;
        }
        this.appendLine(title);
        for (Map.Entry<String, String> entry : headers) {
            this.appendLine(String.format("  %s = %s", entry.getKey(), entry.getValue()));
        }
    }

    private void printSet(String title, Set<String> en) {
        this.appendLine(title);
        for (String s : en) {
            this.append("  " + s);
        }
        this.appendLine("");
    }

    private void openURL(String urlString, Command command) {
        try {
            URL u = new URL(urlString);
            this.currentConnection = (HttpURLConnection)u.openConnection();
            this.currentConnection.setRequestMethod(command.toString());
            this.currentConnection.setAllowUserInteraction(true);
            this.clear();
            this.appendLine(command + " request for " + urlString);
            Map<String, List<String>> reqs = this.currentConnection.getRequestProperties();
            for (Map.Entry<String, List<String>> ent : reqs.entrySet()) {
                this.append(" " + ent.getKey() + ": ");
                for (String v : ent.getValue()) {
                    this.append(v + " ");
                }
                this.appendLine("");
            }
            this.appendLine("");
            this.appendLine("getFollowRedirects=" + HttpURLConnection.getFollowRedirects());
            this.appendLine("getInstanceFollowRedirects=" + this.currentConnection.getInstanceFollowRedirects());
            this.appendLine("AllowUserInteraction=" + this.currentConnection.getAllowUserInteraction());
            this.appendLine("");
            int code = this.currentConnection.getResponseCode();
            String response = this.currentConnection.getResponseMessage();
            this.appendLine(" HTTP/1.x " + code + " " + response);
            this.appendLine(" content-length: " + this.currentConnection.getContentLength());
            this.appendLine(" content-encoding: " + this.currentConnection.getContentEncoding());
            this.appendLine(" content-type: " + this.currentConnection.getContentType());
            this.appendLine("\nHeaders: ");
            int j = 1;
            while (true) {
                String header = this.currentConnection.getHeaderField(j);
                String key = this.currentConnection.getHeaderFieldKey(j);
                if (header == null || key == null) break;
                this.appendLine(" " + key + ": " + header);
                ++j;
            }
            this.appendLine("");
            this.appendLine("contents:");
            InputStream is = this.currentConnection.getInputStream();
            ByteArrayOutputStream bout = new ByteArrayOutputStream(200000);
            IO.copy((InputStream)is, (OutputStream)bout);
            is.close();
            this.append(new String(bout.toByteArray(), StandardCharsets.UTF_8));
            this.appendLine("end contents");
        }
        catch (MalformedURLException e) {
            this.append(urlString + " is not a parseable URL");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readURL(String urlString) {
        try {
            URL u = new URL(urlString);
            this.currentConnection = (HttpURLConnection)u.openConnection();
            this.clear();
            this.appendLine("GET request for " + urlString);
            Map<String, List<String>> reqs = this.currentConnection.getRequestProperties();
            for (Map.Entry<String, List<String>> ent : reqs.entrySet()) {
                this.append(" " + ent.getKey() + ": ");
                for (String v : ent.getValue()) {
                    this.append(v + " ");
                }
                this.appendLine("");
            }
            this.appendLine("");
            int code = this.currentConnection.getResponseCode();
            String response = this.currentConnection.getResponseMessage();
            this.appendLine(" HTTP/1.x " + code + " " + response);
            int j = 1;
            while (true) {
                String header = this.currentConnection.getHeaderField(j);
                String key = this.currentConnection.getHeaderFieldKey(j);
                if (header == null || key == null) break;
                this.appendLine(" " + key + ": " + header);
                ++j;
            }
            this.appendLine("");
            InputStream is = this.currentConnection.getInputStream();
            ByteArrayOutputStream bout = new ByteArrayOutputStream(200000);
            IO.copy((InputStream)is, (OutputStream)bout);
            is.close();
            this.append(new String(bout.toByteArray(), StandardCharsets.UTF_8));
        }
        catch (MalformedURLException e) {
            this.append(urlString + " is not a parseable URL");
        }
        catch (IOException e) {
            e.printStackTrace();
            this.appendLine(e.getMessage());
        }
    }

    public void setURL(String urlString) {
        if (urlString == null) {
            return;
        }
        this.cb.addItem((Object)urlString);
        this.clear();
    }

    void putURL(String urlString) {
        if (urlString == null) {
            return;
        }
        String contents = this.ta.getText();
        HttpUtils.HttpResult result = HttpUtils.putToURL(urlString, contents);
        JOptionPane.showMessageDialog((Component)((Object)this), "Status code= " + result.statusCode + "\n" + result.message);
    }

    public void save() {
        this.cb.save();
    }

    public void append(String text) {
        this.ta.append(text);
    }

    private static enum Command {
        GET,
        HEAD;

    }

    private static enum Library {
        HttpService,
        HttpURLConnection;

    }
}

