/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.Archive;
import edu.ucar.unidata.sruth.ClearingHouse;
import edu.ucar.unidata.sruth.InetSocketAddressSet;
import edu.ucar.unidata.sruth.NodeId;
import edu.ucar.unidata.sruth.Predicate;
import edu.ucar.unidata.sruth.Server;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
abstract class AbstractNode
implements Callable<Void> {
    protected final ClearingHouse clearingHouse;
    protected final Server localServer;
    protected final NodeId nodeId;
    protected final ExecutorService executorService;

    AbstractNode(Archive archive, Predicate predicate, InetSocketAddressSet inetSockAddrSet, ExecutorService executorService) throws IOException {
        this.clearingHouse = new ClearingHouse(archive, predicate);
        this.localServer = this.createServer(this.clearingHouse, inetSockAddrSet);
        this.nodeId = new NodeId(this.localServer.getInetSocketAddress());
        if (executorService == null) {
            throw new NullPointerException();
        }
        this.executorService = executorService;
    }

    abstract Server createServer(ClearingHouse var1, InetSocketAddressSet var2) throws SocketException, IOException;

    protected InetSocketAddress getServerSocketAddress() {
        return this.localServer.getSocketAddress();
    }

    Predicate getPredicate() {
        return this.clearingHouse.getPredicate();
    }

    Archive getArchive() {
        return this.clearingHouse.getArchive();
    }

    protected int getServletCount() {
        return this.localServer.getServletCount();
    }

    abstract int getClientCount();

    final void awaitCompletion() throws InterruptedException {
        Thread.interrupted();
        this.executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
    }
}

