/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.DataProduct;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.NotThreadSafe;
import net.jcip.annotations.ThreadSafe;

@NotThreadSafe
public abstract class Action {
    abstract void execute(Matcher var1, DataProduct var2) throws IOException, InterruptedException;

    protected static Replacer getReplacer(Matcher matcher) {
        return new Replacer(matcher);
    }

    public abstract String toString();

    @ThreadSafe
    static final class Replacer {
        private final Matcher matcher;

        Replacer(Matcher matcher) {
            this.matcher = matcher;
        }

        String replace(String string) {
            String str = string;
            int groupCount = this.matcher.groupCount();
            for (int groupIndex = 1; groupIndex <= groupCount; ++groupIndex) {
                Pattern capturingGroupPat = Pattern.compile("([^\\\\]?)\\$" + groupIndex + "\\b");
                String replacement = "$1" + Matcher.quoteReplacement(this.matcher.group(groupIndex));
                str = capturingGroupPat.matcher(str).replaceAll(replacement);
            }
            return str;
        }
    }
}

