/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import java.io.File;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ArchivePath
implements Comparable<ArchivePath>,
Serializable {
    static final char SEPARATOR_CHAR = '/';
    static final String SEPARATOR = "/";
    private static final long serialVersionUID = 1L;
    private volatile transient Path path;

    public ArchivePath(Path path, Path rootDir) {
        this(rootDir.relativize(path));
        if (!rootDir.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException();
        }
    }

    public ArchivePath(Path path) {
        if (path.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        this.path = path;
    }

    public ArchivePath(String path) {
        this(Paths.get(path, new String[0]));
    }

    public Path getPath() {
        return this.path;
    }

    int size() {
        return this.path.getNameCount();
    }

    int getNameCount() {
        return this.path.getNameCount();
    }

    Path getName(int i) {
        return this.path.getName(i);
    }

    @Override
    public int compareTo(ArchivePath that) {
        return this.path.compareTo(that.path);
    }

    boolean includes(ArchivePath archivePath) {
        return archivePath.path.startsWith(this.path);
    }

    boolean matches(Pattern pattern) {
        Matcher matcher = pattern.matcher(this.path.toString());
        return matcher.matches();
    }

    Matcher matcher(Pattern pattern) {
        return pattern.matcher(this.path.toString());
    }

    Path getAbsolutePath(Path rootDir) {
        return rootDir.resolve(this.path);
    }

    private ArchivePath resolve(Path relPath) {
        return new ArchivePath(this.path.resolve(relPath));
    }

    ArchivePath resolve(ArchivePath subPath) {
        return this.resolve(subPath.path);
    }

    ArchivePath resolve(String string) {
        Path relPath = Paths.get(string, new String[0]);
        if (relPath.isAbsolute()) {
            throw new IllegalArgumentException(relPath.toString());
        }
        return this.resolve(relPath);
    }

    boolean startsWith(ArchivePath that) {
        return this.path.startsWith(that.path);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchivePath)) {
            return false;
        }
        ArchivePath other = (ArchivePath)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public String toString() {
        return this.path.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.path.toFile());
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, InvalidObjectException, IOException {
        in.defaultReadObject();
        Object obj = in.readObject();
        if (obj == null) {
            throw new InvalidObjectException("Null object");
        }
        if (!(obj instanceof File)) {
            throw new InvalidObjectException("Not a File: " + obj);
        }
        this.path = ((File)obj).toPath();
        if (this.path.isAbsolute()) {
            throw new InvalidObjectException("Absolute pathname: " + this.path);
        }
    }
}

