/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.Immutable;

@Immutable
final class ArchiveTime
implements Serializable,
Comparable<ArchiveTime> {
    private static final long serialVersionUID = 1L;
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    static final ArchiveTime BEGINNING_OF_TIME = new ArchiveTime(FileTime.fromMillis(Long.MIN_VALUE));
    @GuardedBy(value="this")
    private final Long time;

    ArchiveTime() {
        this.time = ArchiveTime.round(System.currentTimeMillis());
    }

    ArchiveTime(FileTime fileTime) {
        long millis = fileTime.toMillis();
        this.time = ArchiveTime.round(millis);
    }

    ArchiveTime(Path path) throws NoSuchFileException, IOException {
        this(Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]));
    }

    ArchiveTime(BasicFileAttributes attributes) {
        this(attributes.lastModifiedTime());
    }

    private static long round(long millis) {
        return (millis + 500L) / 1000L * 1000L;
    }

    void setTime(Path path) throws IOException {
        FileTime fileTime = FileTime.fromMillis(this.time);
        Files.setAttribute(path, "lastModifiedTime", fileTime, new LinkOption[0]);
    }

    static void adjustTime(Path path, BasicFileAttributes attributes) throws IOException {
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        ArchiveTime archiveTime = new ArchiveTime(attributes);
        archiveTime.setTime(path);
    }

    static void adjustTime(Path path) throws IOException {
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        ArchiveTime archiveTime = new ArchiveTime(path);
        archiveTime.setTime(path);
    }

    @Override
    public int compareTo(ArchiveTime that) {
        return Long.compare(this.time, that.time);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArchiveTime other = (ArchiveTime)obj;
        return this.compareTo(other) == 0;
    }

    public int hashCode() {
        return Long.valueOf(this.time).hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Date date = new Date(this.time);
        DateFormat dateFormat = ArchiveTime.dateFormat;
        synchronized (dateFormat) {
            return ArchiveTime.dateFormat.format(date);
        }
    }
}

