/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.UninterruptibleTask;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
class CancellingExecutor
extends ThreadPoolExecutor {
    @GuardedBy(value="itself")
    private final List<UninterruptibleFuture<?>> uninterruptibleFutures = new LinkedList();

    CancellingExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        if (!(callable instanceof UninterruptibleTask)) {
            return super.newTaskFor(callable);
        }
        UninterruptibleFuture uninterruptibleFuture = new UninterruptibleFuture((UninterruptibleTask)callable);
        List<UninterruptibleFuture<?>> list = this.uninterruptibleFutures;
        synchronized (list) {
            this.uninterruptibleFutures.add(uninterruptibleFuture);
        }
        return uninterruptibleFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        if (r instanceof UninterruptibleFuture) {
            List<UninterruptibleFuture<?>> list = this.uninterruptibleFutures;
            synchronized (list) {
                this.uninterruptibleFutures.add((UninterruptibleFuture)r);
            }
        }
        super.beforeExecute(t, r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (r instanceof UninterruptibleFuture) {
            List<UninterruptibleFuture<?>> list = this.uninterruptibleFutures;
            synchronized (list) {
                this.uninterruptibleFutures.remove(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        List<Runnable> list = super.shutdownNow();
        List<UninterruptibleFuture<?>> list2 = this.uninterruptibleFutures;
        synchronized (list2) {
            for (UninterruptibleFuture<?> future : this.uninterruptibleFutures) {
                future.cancel(true);
            }
        }
        return list;
    }

    @ThreadSafe
    private static final class UninterruptibleFuture<T>
    extends FutureTask<T> {
        private final UninterruptibleTask<T> task;

        public UninterruptibleFuture(UninterruptibleTask<T> task) {
            super(task);
            this.task = task;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean wasCancelled = super.cancel(mayInterruptIfRunning);
            if (mayInterruptIfRunning) {
                this.task.cancel();
            }
            return wasCancelled;
        }
    }
}

