/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.Archive;
import edu.ucar.unidata.sruth.ArchivePath;
import edu.ucar.unidata.sruth.FileInfoMismatchException;
import edu.ucar.unidata.sruth.FilePieceSpecSetConsumer;
import edu.ucar.unidata.sruth.Filter;
import edu.ucar.unidata.sruth.Peer;
import edu.ucar.unidata.sruth.Piece;
import edu.ucar.unidata.sruth.PieceSpec;
import edu.ucar.unidata.sruth.Predicate;
import edu.ucar.unidata.sruth.SpecSet;
import edu.ucar.unidata.sruth.Util;
import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;

@ThreadSafe
final class ClearingHouse {
    private static final Logger logger = Util.getLogger();
    private final Archive archive;
    private final Predicate predicate;
    @GuardedBy(value="itself")
    private final SortedSet<Peer> peers = new TreeSet<Peer>(PeerComparator.INSTANCE);
    private final AtomicLong receivedFileCount = new AtomicLong(0L);
    private final SpecSet pendingRequests = new SpecSet();

    ClearingHouse(Archive archive, Predicate predicate) {
        if (null == predicate) {
            throw new NullPointerException();
        }
        this.archive = archive;
        this.predicate = predicate;
    }

    Archive getArchive() {
        return this.archive;
    }

    Path getRootDir() {
        return this.archive.getRootDir();
    }

    Predicate getPredicate() {
        return this.predicate;
    }

    Archive.DistributedTrackerFiles getDistributedTrackerFiles(InetSocketAddress trackerAddress) {
        return this.archive.getDistributedTrackerFiles(trackerAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean add(Peer peer) {
        SortedSet<Peer> sortedSet = this.peers;
        synchronized (sortedSet) {
            return this.peers.add(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(Peer peer) {
        SortedSet<Peer> sortedSet = this.peers;
        synchronized (sortedSet) {
            this.peers.remove(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<Peer> getPeers(Filter filter) {
        LinkedList<Peer> relevantPeers = new LinkedList<Peer>();
        SortedSet<Peer> sortedSet = this.peers;
        synchronized (sortedSet) {
            for (Peer peer : this.peers) {
                if (!peer.getLocalFilter().includes(filter)) continue;
                relevantPeers.add(peer);
            }
        }
        return relevantPeers;
    }

    void process(Peer peer, PieceSpec pieceSpec) throws FileInfoMismatchException, IOException {
        if (this.predicate.matches(pieceSpec) && !this.archive.exists(pieceSpec) && this.pendingRequests.add(pieceSpec)) {
            peer.queueRequest(pieceSpec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean process(Peer peer, Piece piece) throws FileInfoMismatchException, IOException, InterruptedException {
        boolean wasUsed;
        if (!this.predicate.matches(piece.getFileInfo())) {
            wasUsed = false;
        } else {
            try {
                if (this.archive.putPiece(piece)) {
                    this.predicate.removeIfPossible(piece.getFileInfo());
                    this.receivedFileCount.incrementAndGet();
                }
                PieceSpec pieceSpec = piece.getInfo();
                SortedSet<Peer> sortedSet = this.peers;
                synchronized (sortedSet) {
                    for (Peer otherPeer : this.peers) {
                        if (PeerComparator.INSTANCE.compare(peer, otherPeer) == 0) continue;
                        otherPeer.notifyRemoteIfDesired(pieceSpec);
                    }
                }
            }
            catch (FileNotFoundException e) {
                logger.debug("Can't add data to removed file \"{}\"", piece.getArchivePath());
            }
            wasUsed = true;
        }
        this.pendingRequests.remove(piece.getInfo());
        return wasUsed;
    }

    boolean allDataReceived() {
        return this.predicate.matchesNothing();
    }

    Piece getPiece(PieceSpec pieceSpec) throws FileInfoMismatchException, IOException {
        return this.archive.getPiece(pieceSpec);
    }

    void walkArchive(FilePieceSpecSetConsumer consumer, Filter filter) throws IOException, InterruptedException {
        this.archive.walkArchive(consumer, filter);
    }

    long getReceivedFileCount() {
        return this.receivedFileCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getPeerCount() {
        SortedSet<Peer> sortedSet = this.peers;
        synchronized (sortedSet) {
            return this.peers.size();
        }
    }

    void remove(ArchivePath archivePath) throws IOException {
        try {
            this.archive.remove(archivePath);
        }
        catch (IOError e) {
            throw (IOException)e.getCause();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[archive=" + this.archive + ", peers=(" + this.peers.size() + "), pending request=(" + this.pendingRequests.size() + ")]";
    }

    private static final class PeerComparator
    implements Comparator<Peer> {
        static final PeerComparator INSTANCE = new PeerComparator();

        private PeerComparator() {
        }

        @Override
        public int compare(Peer p1, Peer p2) {
            int cmp;
            if (p1 == p2) {
                cmp = 0;
            } else {
                cmp = p1.getConnection().compareTo(p2.getConnection());
                if (cmp == 0) {
                    cmp = p1.getLocalFilter().compareTo(p2.getLocalFilter());
                }
            }
            return cmp;
        }
    }
}

