/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.ClearingHouse;
import edu.ucar.unidata.sruth.Connection;
import edu.ucar.unidata.sruth.ConnectionFactory;
import edu.ucar.unidata.sruth.ConnectionToServer;
import edu.ucar.unidata.sruth.Filter;
import edu.ucar.unidata.sruth.Peer;
import edu.ucar.unidata.sruth.SpecSet;
import edu.ucar.unidata.sruth.UninterruptibleTask;
import edu.ucar.unidata.sruth.Util;
import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;

final class Client
extends UninterruptibleTask<Boolean> {
    private static final Logger logger = Util.getLogger();
    private final ClearingHouse clearingHouse;
    private final InetSocketAddress remoteServer;
    private final Filter filter;
    private final ConnectionFactory connectionFactory;
    @GuardedBy(value="this")
    private Peer peer;
    private final AtomicReference<ConnectionToServer> connectionRef = new AtomicReference();

    Client(InetSocketAddress localServer, InetSocketAddress remoteServer, Filter filter, ClearingHouse clearingHouse) {
        if (null == localServer || null == clearingHouse || null == filter || null == remoteServer) {
            throw new NullPointerException();
        }
        this.remoteServer = remoteServer;
        this.filter = filter;
        this.clearingHouse = clearingHouse;
        this.connectionFactory = new ConnectionFactory(localServer);
    }

    InetSocketAddress getServerAddress() {
        return this.remoteServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() throws ConnectException, EOFException, IOException, SocketTimeoutException, SocketException, InterruptedException {
        logger.debug("Starting up: {}", this);
        String origName = Thread.currentThread().getName();
        Thread currentThread = Thread.currentThread();
        currentThread.setName(this.toString());
        try {
            ConnectionToServer connection = this.connectionFactory.getInstance(this.remoteServer);
            this.connectionRef.set(connection);
            connection.open();
            try {
                Filter serverFilter;
                Connection.Stream requestStream = connection.getRequestStream();
                try {
                    requestStream.send(this.filter);
                }
                catch (IOException e) {
                    throw (ConnectException)new ConnectException("Couldn't send filter on " + connection).initCause(e);
                }
                try {
                    serverFilter = (Filter)requestStream.receiveObject(Connection.SO_TIMEOUT);
                }
                catch (IOException e) {
                    throw (ConnectException)new ConnectException("Couldn't receive filter on " + connection).initCause(e);
                }
                catch (ClassNotFoundException e) {
                    throw (IOException)new IOException("Invalid server response on " + connection).initCause(e);
                }
                catch (ClassCastException e) {
                    throw (IOException)new IOException("Invalid server response on " + connection).initCause(e);
                }
                Client e = this;
                synchronized (e) {
                    this.peer = new Peer(this.clearingHouse, connection, this.filter, serverFilter);
                }
                Boolean isValid = this.peer.call();
                if (!isValid.booleanValue()) {
                    logger.debug("Invalid server: {}", this);
                }
                Boolean bl = isValid;
                connection.close();
                return bl;
            }
            catch (Throwable throwable) {
                connection.close();
                throw throwable;
            }
        }
        finally {
            Thread.currentThread().setName(origName);
            logger.trace("Done: {}", this);
        }
    }

    @Override
    protected void stop() {
        ConnectionToServer connection = this.connectionRef.get();
        if (connection != null) {
            connection.close();
        }
    }

    synchronized long getDownloadAmount() {
        return 0L;
    }

    long getCounter() {
        return this.peer.getCounter();
    }

    void restartCounter() {
        this.peer.restartCounter();
    }

    synchronized SpecSet getPendingRequests() {
        return this.peer == null ? new SpecSet() : this.peer.getPendingRequests();
    }

    synchronized void getIfAppropriate(SpecSet specs) {
        if (this.peer != null && !this.isCancelled()) {
            this.peer.requestNotices(specs);
        }
    }

    public String toString() {
        return "Client [remoteServer=" + this.remoteServer + ", localPredicate=" + this.clearingHouse.getPredicate() + "]";
    }
}

