/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.AddressComparator;
import edu.ucar.unidata.sruth.CancellingExecutor;
import edu.ucar.unidata.sruth.ClearingHouse;
import edu.ucar.unidata.sruth.Client;
import edu.ucar.unidata.sruth.Filter;
import edu.ucar.unidata.sruth.InvalidMessageException;
import edu.ucar.unidata.sruth.Peer;
import edu.ucar.unidata.sruth.SinkNode;
import edu.ucar.unidata.sruth.SpecSet;
import edu.ucar.unidata.sruth.Topology;
import edu.ucar.unidata.sruth.TrackerProxy;
import edu.ucar.unidata.sruth.UninterruptibleTask;
import edu.ucar.unidata.sruth.Util;
import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.prefs.Preferences;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;

@ThreadSafe
final class ClientManager
implements Callable<Void> {
    private static Logger logger = Util.getLogger();
    private static final int MINIMUM_NUMBER_OF_CLIENTS_PER_FILTER;
    private static final String MINIMUM_NUMBER_OF_CLIENTS_PER_FILTER_KEY = "minimum number of clients per filter";
    private static final int MINIMUM_NUMBER_OF_CLIENTS_PER_FILTER_DEFAULT = 8;
    private static final int REPLACEMENT_PERIOD;
    private static final String REPLACEMENT_PERIOD_KEY = "client replacement period in seconds";
    private static final int REPLACEMENT_PERIOD_DEFAULT = 60;
    private static final int CLIENT_THREAD_KEEP_ALIVE_TIME;
    private static final String CLIENT_THREAD_KEEP_ALIVE_TIME_KEY = "client thread keep-alive time in seconds";
    private static final int CLIENT_THREAD_KEEP_ALIVE_TIME_DEFAULT = 60;
    private final TrackerProxy trackerProxy;
    private final CancellingExecutor executor = new CancellingExecutor(0, Integer.MAX_VALUE, CLIENT_THREAD_KEEP_ALIVE_TIME, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private final CompletionService<Void> completionService = new ExecutorCompletionService<Void>(this.executor);
    private final CompletionService<Boolean> clientCompletionService = new ExecutorCompletionService<Boolean>(this.executor);
    @GuardedBy(value="this")
    private final List<Client> clients = new LinkedList<Client>();
    @GuardedBy(value="this")
    private final SortedSet<InetSocketAddress> invalidServers = new TreeSet<InetSocketAddress>(AddressComparator.INSTANCE);
    @GuardedBy(value="this")
    private final SortedSet<RankedClient> rankedClients = new TreeSet<RankedClient>();
    private final ClearingHouse clearingHouse;
    private final Filter filter;
    private final InetSocketAddress localServer;
    private final ClientCreator clientCreator;
    private final ClientReaper clientReaper;

    ClientManager(InetSocketAddress localServer, ClearingHouse clearingHouse, Filter filter, TrackerProxy trackerProxy) throws IOException {
        if (localServer == null) {
            throw new NullPointerException();
        }
        if (clearingHouse == null) {
            throw new NullPointerException();
        }
        if (trackerProxy == null) {
            throw new NullPointerException();
        }
        this.trackerProxy = trackerProxy;
        this.localServer = localServer;
        this.filter = filter;
        this.clearingHouse = clearingHouse;
        this.clientCreator = new ClientCreator();
        this.clientReaper = new ClientReaper();
    }

    public Filter getFilter() {
        return this.filter;
    }

    InetSocketAddress getLocalServerAddress() {
        return this.localServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws InterruptedException, IOException {
        logger.trace("Starting up: {}", this);
        String prevName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.toString());
        try {
            Future<Void> clientCreatorFuture = this.completionService.submit(this.clientCreator);
            Future<Void> clientReaperFuture = this.completionService.submit(this.clientReaper);
            Future<Void> future = this.completionService.take();
            if (future == clientCreatorFuture) {
                if (clientCreatorFuture.isCancelled()) {
                    throw new InterruptedException();
                }
                try {
                    clientCreatorFuture.get();
                    throw new AssertionError();
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof InterruptedException) {
                        throw (InterruptedException)cause;
                    }
                    throw new RuntimeException("Client creator crashed: " + this, cause);
                }
            }
            if (clientReaperFuture.isCancelled()) {
                throw new InterruptedException();
            }
            try {
                clientReaperFuture.get();
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw new RuntimeException("Client crashed", cause);
            }
        }
        finally {
            this.executor.shutdownNow();
            this.awaitCompletion();
            Thread.currentThread().setName(prevName);
            logger.trace("Done: {}", this);
        }
        return null;
    }

    void waitUntilRunning() throws InterruptedException {
        this.clientCreator.waitUntilRunning();
        this.clientReaper.waitUntilRunning();
    }

    void awaitCompletion() throws InterruptedException {
        Thread.interrupted();
        this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
    }

    synchronized int getClientCount() {
        return this.clients.size();
    }

    synchronized void redistributeRequests(SpecSet specs) {
        for (Client client : this.clients) {
            client.getIfAppropriate(specs);
        }
    }

    public String toString() {
        return "ClientManager [trackerProxy=" + this.trackerProxy + ", clients=(" + this.getClientCount() + ")]";
    }

    static {
        Preferences prefs = Preferences.userNodeForPackage(SinkNode.class);
        MINIMUM_NUMBER_OF_CLIENTS_PER_FILTER = prefs.getInt(MINIMUM_NUMBER_OF_CLIENTS_PER_FILTER_KEY, 8);
        if (MINIMUM_NUMBER_OF_CLIENTS_PER_FILTER <= 0) {
            throw new IllegalArgumentException("Invalid preference: \"minimum number of clients per filter\"=" + MINIMUM_NUMBER_OF_CLIENTS_PER_FILTER);
        }
        REPLACEMENT_PERIOD = prefs.getInt(REPLACEMENT_PERIOD_KEY, 60);
        if (REPLACEMENT_PERIOD <= 0) {
            throw new IllegalArgumentException("Invalid preference: \"client replacement period in seconds\"=" + REPLACEMENT_PERIOD);
        }
        CLIENT_THREAD_KEEP_ALIVE_TIME = prefs.getInt(CLIENT_THREAD_KEEP_ALIVE_TIME_KEY, 60);
        if (CLIENT_THREAD_KEEP_ALIVE_TIME < 0) {
            throw new IllegalArgumentException("Invalid preference: \"client thread keep-alive time in seconds\"=" + CLIENT_THREAD_KEEP_ALIVE_TIME);
        }
    }

    @ThreadSafe
    private final class ClientWrapper
    extends UninterruptibleTask<Boolean> {
        private final Client client;

        ClientWrapper(Client client) {
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws IOException {
            boolean allDataReceived;
            block56: {
                allDataReceived = false;
                boolean reportOffline = true;
                try {
                    boolean validServer = this.client.call();
                    reportOffline = false;
                    if (validServer) {
                        logger.debug("All desired-data received");
                        allDataReceived = true;
                        break block56;
                    }
                    ClientManager clientManager = ClientManager.this;
                    synchronized (clientManager) {
                        ClientManager.this.invalidServers.add(this.client.getServerAddress());
                    }
                }
                catch (InterruptedException e) {
                    logger.trace("Interrupted: {}", this.client);
                }
                catch (EOFException e) {
                    logger.info("Connection closed by remote server: {}: {}", this.client.getServerAddress(), (Object)e.toString());
                }
                catch (ConnectException e) {
                    logger.info("Couldn't connect to remote server: {}: {}", this.client.getServerAddress(), (Object)e.toString());
                }
                catch (SocketTimeoutException e) {
                    logger.info("Remote server is inaccessible: {}: {}", this.client.getServerAddress(), (Object)e.toString());
                }
                catch (SocketException e) {
                    logger.info("Remote server is inaccessible: {}: {}", this.client.getServerAddress(), (Object)e.toString());
                }
                catch (IOException e) {
                    reportOffline = false;
                    throw new IOException("Client I/O failure: " + this.client, e);
                }
                catch (Throwable t) {
                    reportOffline = false;
                    throw new RuntimeException("Unexpected error: " + this.client, t);
                }
                finally {
                    Object remoteServerAddress;
                    if (reportOffline) {
                        remoteServerAddress = this.client.getServerAddress();
                        try {
                            ClientManager.this.trackerProxy.reportOffline((InetSocketAddress)remoteServerAddress);
                        }
                        catch (IOException e) {
                            logger.warn("Couldn't report {} as being offline: {}", remoteServerAddress, (Object)e.toString());
                        }
                    }
                    remoteServerAddress = ClientManager.this;
                    synchronized (remoteServerAddress) {
                        SpecSet specs = this.client.getPendingRequests();
                        ClientManager.this.clients.remove(this.client);
                        ClientManager.this.redistributeRequests(specs);
                        ClientManager.this.notifyAll();
                    }
                }
            }
            return allDataReceived;
        }

        @Override
        protected void stop() {
            logger.trace("Stop: {}", this.client);
            this.client.cancel();
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [client=" + this.client + "]";
        }
    }

    @Immutable
    private static final class RankedClient
    implements Comparable<RankedClient> {
        private final Client client;
        private final long rank;

        RankedClient(Client client) {
            this.client = client;
            this.rank = client.getCounter();
        }

        @Override
        public int compareTo(RankedClient that) {
            return this.rank < that.rank ? -1 : (this.rank == that.rank ? 0 : 1);
        }
    }

    @ThreadSafe
    private final class ClientReaper
    implements Callable<Void> {
        private final CountDownLatch isRunningLatch = new CountDownLatch(1);

        private ClientReaper() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public Void call() throws IOException, InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        void waitUntilRunning() throws InterruptedException {
            this.isRunningLatch.await();
        }
    }

    @ThreadSafe
    private final class ClientCreator
    extends UninterruptibleTask<Void> {
        private final TrackerProxy.FilteredProxy filteredProxy;
        private final CountDownLatch isRunningLatch = new CountDownLatch(1);

        ClientCreator() {
            this.filteredProxy = ClientManager.this.trackerProxy.getFilteredProxy(ClientManager.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws InterruptedException, IOException {
            int timeout = 0;
            boolean registered = false;
            while (!registered && !Thread.currentThread().isInterrupted()) {
                try {
                    this.filteredProxy.register();
                    registered = true;
                }
                catch (SocketTimeoutException e) {
                    logger.debug("Connection attempt to tracker timed-out: {}. Continuing...", ClientManager.this.trackerProxy.getAddress(), (Object)e.toString());
                }
                catch (ConnectException e) {
                    logger.debug("Couldn't connect to tracker: {}: {}. Continuing...", ClientManager.this.trackerProxy.getAddress(), (Object)e.toString());
                }
                catch (InvalidMessageException e) {
                    logger.debug("Invalid communication with tracker {}: {}. Continuing...", ClientManager.this.trackerProxy.getAddress(), (Object)e.toString());
                }
                timeout = this.waitUntilDoneOrTimeout(false, timeout);
            }
            try {
                this.isRunningLatch.countDown();
                while (!Thread.currentThread().isInterrupted()) {
                    if (this.enoughClients()) {
                        this.rankClients();
                        do {
                            this.removeWorstClient();
                        } while (!Thread.currentThread().isInterrupted() && this.enoughClients());
                    }
                    while (!Thread.currentThread().isInterrupted() && !this.enoughClients()) {
                        try {
                            if (this.addClient()) continue;
                            timeout = this.waitUntilDoneOrTimeout(false, timeout);
                        }
                        catch (NoSuchFileException e) {
                            timeout = this.waitUntilDoneOrTimeout(false, timeout);
                            logger.debug("Continuing...");
                        }
                        catch (IOException e) {
                            logger.warn("Couldn't add new client: {}", (Object)e.toString());
                            timeout = this.waitUntilDoneOrTimeout(false, timeout);
                        }
                    }
                    if (Thread.currentThread().isInterrupted()) continue;
                    this.restartClientCounters();
                    timeout = this.waitUntilDoneOrTimeout(true, REPLACEMENT_PERIOD);
                }
            }
            finally {
                this.filteredProxy.deregister();
            }
            return null;
        }

        void waitUntilRunning() throws InterruptedException {
            this.isRunningLatch.await();
        }

        @Override
        protected void stop() {
            this.filteredProxy.deregister();
        }

        private boolean enoughClients() {
            return ClientManager.this.getClientCount() >= MINIMUM_NUMBER_OF_CLIENTS_PER_FILTER;
        }

        private synchronized void rankClients() {
            ClientManager.this.rankedClients.clear();
            for (Client client : ClientManager.this.clients) {
                RankedClient rankedClient = new RankedClient(client);
                ClientManager.this.rankedClients.add(rankedClient);
            }
        }

        private synchronized void removeWorstClient() {
            if (!ClientManager.this.rankedClients.isEmpty()) {
                RankedClient rankedClient = (RankedClient)ClientManager.this.rankedClients.first();
                ClientManager.this.rankedClients.remove(rankedClient);
                Client client = rankedClient.client;
                client.cancel();
                ClientManager.this.clients.remove(client);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean addClient() throws NoSuchFileException, IOException {
            boolean clientAdded = false;
            Topology topology = this.filteredProxy.getTopology();
            InetSocketAddress remoteServer = this.computeBestServer(topology);
            if (remoteServer != null) {
                Client client = new Client(ClientManager.this.localServer, remoteServer, ClientManager.this.filter, ClientManager.this.clearingHouse);
                ClientCreator clientCreator = this;
                synchronized (clientCreator) {
                    ClientManager.this.clients.add(client);
                }
                ClientManager.this.clientCompletionService.submit(new ClientWrapper(client));
                clientAdded = true;
            }
            return clientAdded;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private InetSocketAddress computeBestServer(Topology topology) {
            ClientCreator clientCreator = this;
            synchronized (clientCreator) {
                for (Client client : ClientManager.this.clients) {
                    topology.remove(client.getServerAddress());
                }
                topology.remove(ClientManager.this.invalidServers);
                Collection<Peer> extantPeers = ClientManager.this.clearingHouse.getPeers(ClientManager.this.filter);
                for (Peer peer : extantPeers) {
                    topology.remove(peer.getRemoteServerSocketAddress());
                }
            }
            topology.remove(ClientManager.this.localServer);
            InetSocketAddress bestServer = topology.getBestServer(ClientManager.this.filter);
            logger.debug("Best server is {}", bestServer);
            return bestServer;
        }

        private synchronized int waitUntilDoneOrTimeout(boolean returnIfNeedClient, int timeout) throws InterruptedException {
            long delay;
            long start;
            for (delay = (long)(1000 * timeout); !(Thread.currentThread().isInterrupted() || returnIfNeedClient && !this.enoughClients() || delay <= 0L); delay -= System.currentTimeMillis() - start) {
                start = System.currentTimeMillis();
                this.wait(delay);
            }
            return delay > 0L ? 0 : Math.min(Math.max(2 * timeout, 1), REPLACEMENT_PERIOD);
        }

        private synchronized void restartClientCounters() {
            for (Client client : ClientManager.this.clients) {
                client.restartCounter();
            }
        }
    }
}

