/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.Connection;
import java.net.InetAddress;
import java.net.InetSocketAddress;

final class ComparableInetSocketAddress
extends InetSocketAddress
implements Comparable<ComparableInetSocketAddress>,
Connection.Message {
    private static final long serialVersionUID = 1L;

    ComparableInetSocketAddress() {
        this(0);
    }

    ComparableInetSocketAddress(int port) {
        this((InetAddress)null, port);
    }

    ComparableInetSocketAddress(InetAddress inetAddress, int port) {
        super(inetAddress, port);
    }

    protected final InetAddress getInetAddress() {
        return this.getAddress();
    }

    String getShortName() {
        return this.getHostString() + ":" + this.getPort();
    }

    @Override
    public final int compareTo(ComparableInetSocketAddress that) {
        int thatPort;
        byte[] thatBytes;
        byte[] thisBytes = this.getAddress().getAddress();
        if (thisBytes.length < (thatBytes = that.getAddress().getAddress()).length) {
            return -1;
        }
        if (thisBytes.length > thatBytes.length) {
            return 1;
        }
        for (int i = 0; i < thisBytes.length; ++i) {
            if (thisBytes[i] < thatBytes[i]) {
                return -1;
            }
            if (thisBytes[i] <= thatBytes[i]) continue;
            return 1;
        }
        int thisPort = this.getPort();
        return thisPort < (thatPort = that.getPort()) ? -1 : (thisPort == thatPort ? 0 : 1);
    }

    private Object readResolve() {
        return new ComparableInetSocketAddress(this.getAddress(), this.getPort());
    }
}

