/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.AddressComparator;
import edu.ucar.unidata.sruth.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.prefs.Preferences;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;

@ThreadSafe
abstract class Connection
implements Comparable<Connection> {
    private static final Logger logger = Util.getLogger();
    private static final int NOTICE = 0;
    private static final int REQUEST = 1;
    private static final int DATA = 2;
    static final int STREAM_COUNT = 3;
    @GuardedBy(value="this")
    private final List<Stream> streams = new ArrayList<Stream>(3);
    private final InetSocketAddress localServerSocketAddress;
    static final int SO_TIMEOUT;
    static final String SO_TIMEOUT_KEY = "socket timeout in milliseconds";
    static final int SO_TIMEOUT_DEFAULT = 30000;

    protected Connection(InetSocketAddress localServerSocketAddress) {
        if (localServerSocketAddress == null) {
            throw new NullPointerException();
        }
        this.localServerSocketAddress = localServerSocketAddress;
    }

    @GuardedBy(value="this")
    private synchronized void vetStream(Stream stream) {
        if (this.streams.size() > 0) {
            InetAddress expectedInetAddress;
            InetAddress actualInetAddress = stream.socket.getInetAddress();
            if (!actualInetAddress.equals(expectedInetAddress = this.streams.get(0).getInetAddress())) {
                throw new IllegalArgumentException("Different remote Internet addresses: " + actualInetAddress + " != " + expectedInetAddress);
            }
            int actualClientPort = stream.getClientPort();
            for (Stream extantStream : this.streams) {
                int extantClientPort = extantStream.getClientPort();
                if (actualClientPort != extantClientPort) continue;
                throw new IllegalArgumentException("Identical client port number: " + extantClientPort);
            }
        }
    }

    @GuardedBy(value="this")
    protected synchronized void add(Stream stream) {
        if (this.streams.size() >= 3) {
            throw new IndexOutOfBoundsException();
        }
        this.vetStream(stream);
        this.streams.add(stream);
        if (this.streams.size() == 3) {
            Collections.sort(this.streams);
        }
    }

    @GuardedBy(value="this")
    protected synchronized int size() {
        return this.streams.size();
    }

    @GuardedBy(value="this")
    protected synchronized boolean isReady() {
        return this.streams.size() == 3;
    }

    @GuardedBy(value="this")
    protected synchronized Stream getStream(int index) {
        return this.streams.get(index);
    }

    protected Stream getRequestStream() {
        return this.getStream(1);
    }

    protected Stream getNoticeStream() {
        return this.getStream(0);
    }

    protected Stream getDataStream() {
        return this.getStream(2);
    }

    @GuardedBy(value="this")
    synchronized Stream.Output getOutputStream(int i) {
        return this.streams.get(i).getOutput();
    }

    @GuardedBy(value="this")
    synchronized Stream.Input getInputStream(int i) {
        return this.streams.get(i).getInput();
    }

    @GuardedBy(value="this")
    protected synchronized Socket getSocket(int i) {
        return this.streams.get(i).getSocket();
    }

    protected InetAddress getRemoteInetAddress() {
        return this.streams.get(0).socket.getInetAddress();
    }

    protected InetSocketAddress getRemoteServerSocketAddress() {
        return this.streams.get((int)0).remoteServerSocketAddress;
    }

    @GuardedBy(value="this")
    synchronized void close() {
        for (Stream stream : this.streams) {
            stream.close();
        }
    }

    @GuardedBy(value="this")
    public final synchronized int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.streams == null ? 0 : this.getRemoteServerSocketAddress().hashCode());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int compareTo(Connection that) {
        int cmp;
        Connection o2;
        Connection o1;
        if (this == that) {
            return 0;
        }
        if (System.identityHashCode(this) < System.identityHashCode(that)) {
            o1 = this;
            o2 = that;
        } else {
            o1 = that;
            o2 = this;
        }
        Connection connection = o1;
        synchronized (connection) {
            Connection connection2 = o2;
            synchronized (connection2) {
                cmp = AddressComparator.INSTANCE.compare(o1.localServerSocketAddress, o2.localServerSocketAddress);
                if (cmp == 0) {
                    cmp = AddressComparator.INSTANCE.compare(o1.getRemoteServerSocketAddress(), o2.getRemoteServerSocketAddress());
                }
            }
        }
        return this == o1 ? cmp : -cmp;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Connection that = (Connection)obj;
        return this.compareTo(that) == 0;
    }

    public abstract String toString();

    static {
        Preferences prefs = Preferences.userNodeForPackage(Connection.class);
        SO_TIMEOUT = prefs.getInt(SO_TIMEOUT_KEY, 30000);
        if (SO_TIMEOUT < 0) {
            throw new IllegalArgumentException("Invalid preference: \"socket timeout in milliseconds\"=" + SO_TIMEOUT);
        }
    }

    protected static abstract class Stream
    implements Comparable<Stream> {
        private final Socket socket;
        @GuardedBy(value="this")
        protected InetSocketAddress clientSocketAddress;
        @GuardedBy(value="this")
        protected Input input;
        @GuardedBy(value="this")
        protected Output output;
        @GuardedBy(value="this")
        protected InetSocketAddress remoteServerSocketAddress;

        Stream(Socket socket) throws IOException {
            if (socket == null) {
                throw new NullPointerException();
            }
            this.socket = socket;
        }

        Socket getSocket() {
            return this.socket;
        }

        InetAddress getInetAddress() {
            return this.socket.getInetAddress();
        }

        @GuardedBy(value="this")
        synchronized int getClientPort() {
            return this.clientSocketAddress.getPort();
        }

        @GuardedBy(value="this")
        synchronized Output getOutput() {
            return this.output;
        }

        @GuardedBy(value="this")
        synchronized Input getInput() {
            return this.input;
        }

        void send(Message obj) throws IOException {
            this.getOutput().send(obj);
        }

        Object receiveObject() throws IOException, ClassNotFoundException {
            return this.receiveObject(0);
        }

        Object receiveObject(int timeout) throws IOException, ClassNotFoundException {
            return this.getInput().receiveObject(timeout);
        }

        @GuardedBy(value="this")
        synchronized void close() {
            this.input.close();
            this.output.close();
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [socket=" + this.socket + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int compareTo(Stream that) {
            Stream o2;
            Stream o1;
            if (this == that) {
                return 0;
            }
            if (System.identityHashCode(this) < System.identityHashCode(that)) {
                o1 = this;
                o2 = that;
            } else {
                o1 = that;
                o2 = this;
            }
            Stream stream = o1;
            synchronized (stream) {
                Stream stream2 = o2;
                synchronized (stream2) {
                    int cmp = AddressComparator.INSTANCE.compare(o1.remoteServerSocketAddress, o2.remoteServerSocketAddress);
                    if (cmp == 0) {
                        cmp = AddressComparator.INSTANCE.compare(o1.clientSocketAddress, o2.clientSocketAddress);
                    }
                    return o1 == this ? cmp : -cmp;
                }
            }
        }

        @GuardedBy(value="this")
        public synchronized int hashCode() {
            return this.remoteServerSocketAddress.hashCode() ^ this.clientSocketAddress.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Stream that = (Stream)obj;
            return this.compareTo(that) == 0;
        }

        protected final class Input {
            private final ObjectInputStream objectInputStream;
            private final AtomicBoolean isShutdown = new AtomicBoolean();

            Input(ObjectInputStream objectInputStream) {
                if (objectInputStream == null) {
                    throw new NullPointerException();
                }
                this.objectInputStream = objectInputStream;
            }

            Object receiveObject(int timeout) throws ClassNotFoundException, IOException, SocketException, SocketTimeoutException {
                if (timeout < 0) {
                    throw new IllegalArgumentException();
                }
                Stream.this.socket.setSoTimeout(timeout);
                Object obj = this.objectInputStream.readUnshared();
                logger.trace("Received {}", obj);
                return obj;
            }

            void close() {
                if (this.isShutdown.compareAndSet(false, true) && Stream.this.output.isShutdown()) {
                    try {
                        Stream.this.socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }

            boolean isShutdown() {
                return this.isShutdown.get();
            }
        }

        protected final class Output {
            private final ObjectOutputStream objectOutputStream;
            @GuardedBy(value="this")
            private final AtomicBoolean isShutdown = new AtomicBoolean();

            Output(ObjectOutputStream objectOutputStream) {
                if (objectOutputStream == null) {
                    throw new NullPointerException();
                }
                this.objectOutputStream = objectOutputStream;
            }

            void send(Message obj) throws IOException {
                logger.trace("Sending {}", obj);
                this.objectOutputStream.writeObject(obj);
                this.objectOutputStream.reset();
                this.objectOutputStream.flush();
            }

            void close() {
                if (this.isShutdown.compareAndSet(false, true) && Stream.this.input.isShutdown()) {
                    try {
                        Stream.this.socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }

            boolean isShutdown() {
                return this.isShutdown.get();
            }
        }
    }

    static interface Message
    extends Serializable {
    }

    @Immutable
    static final class ConnectionId
    implements Message {
        private static final long serialVersionUID = 1L;
        private final InetSocketAddress serverSocketAddress;
        private final long index;
        private static final AtomicLong connectionCounter = new AtomicLong(0L);

        ConnectionId(InetSocketAddress serverSocketAddress) {
            this.serverSocketAddress = serverSocketAddress;
            this.index = connectionCounter.getAndIncrement();
        }

        InetSocketAddress getServerAddress() {
            return this.serverSocketAddress;
        }

        public int hashCode() {
            return this.serverSocketAddress.hashCode() ^ Long.valueOf(this.index).hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConnectionId other = (ConnectionId)obj;
            if (this.serverSocketAddress == null) {
                if (other.serverSocketAddress != null) {
                    return false;
                }
            } else {
                if (!this.serverSocketAddress.equals(other.serverSocketAddress)) {
                    return false;
                }
                if (this.index != other.index) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            return "ConnectionId [serverSocketAddress=" + this.serverSocketAddress + ", index=" + this.index + "]";
        }
    }
}

