/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.Connection;
import edu.ucar.unidata.sruth.ConnectionToClient;
import edu.ucar.unidata.sruth.ConnectionToServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
final class ConnectionFactory {
    final ConcurrentMap<Object, ConnectionToClient> connections = new ConcurrentHashMap<Object, ConnectionToClient>();
    private final InetSocketAddress localServer;

    ConnectionFactory(InetSocketAddress localServer) {
        if (localServer == null) {
            throw new NullPointerException();
        }
        this.localServer = localServer;
    }

    ConnectionToServer getInstance(InetSocketAddress remoteServer) throws IOException {
        return new ConnectionToServer(this.localServer, remoteServer);
    }

    Connection getInstance(Socket socket) throws IOException {
        socket.setSoLinger(false, 0);
        socket.setTcpNoDelay(false);
        socket.setKeepAlive(true);
        ConnectionToClient connection = new ConnectionToClient(socket);
        ConnectionToClient prevConnection = this.connections.putIfAbsent(connection.getConnectionId(), connection);
        if (prevConnection != null) {
            prevConnection.add(connection);
            connection = prevConnection;
        }
        if (!connection.isReady()) {
            connection = null;
        } else {
            this.connections.remove(connection.getConnectionId());
        }
        return connection;
    }

    int getNumIncomplete() {
        return this.connections.size();
    }
}

