/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.Connection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
final class ConnectionToClient
extends Connection {
    ConnectionToClient(Socket socket) throws IOException {
        super((InetSocketAddress)socket.getLocalSocketAddress());
        ServerSideStream stream = new ServerSideStream(socket);
        this.add(stream);
    }

    Object getConnectionId() {
        return ((ServerSideStream)this.getStream(0)).connectionId;
    }

    void add(ConnectionToClient that) {
        if (that.size() != 1) {
            throw new IllegalArgumentException();
        }
        if (!this.getConnectionId().equals(that.getConnectionId())) {
            throw new IllegalArgumentException();
        }
        this.add(that.getStream(0));
    }

    @Override
    public synchronized String toString() {
        StringBuilder buf = new StringBuilder(this.getClass().getSimpleName());
        buf.append("[localAddress=");
        buf.append(this.getSocket(0).getLocalAddress());
        buf.append(",localPort=");
        buf.append(this.getSocket(0).getLocalPort());
        buf.append(",remoteAddress=");
        buf.append(this.getSocket(0).getInetAddress());
        buf.append(",remotePorts={");
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(this.getSocket(i).getPort());
        }
        buf.append("}]");
        return buf.toString();
    }

    @ThreadSafe
    private static final class ServerSideStream
    extends Connection.Stream {
        private final Connection.ConnectionId connectionId;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ServerSideStream(Socket socket) throws IOException {
            super(socket);
            ServerSideStream serverSideStream = this;
            synchronized (serverSideStream) {
                this.clientSocketAddress = new InetSocketAddress(socket.getInetAddress(), socket.getPort());
                this.input = new Connection.Stream.Input(new ObjectInputStream(socket.getInputStream()));
                try {
                    this.connectionId = (Connection.ConnectionId)this.input.receiveObject(Connection.SO_TIMEOUT);
                    this.remoteServerSocketAddress = this.connectionId.getServerAddress();
                    this.output = new Connection.Stream.Output(new ObjectOutputStream(socket.getOutputStream()));
                }
                catch (ClassNotFoundException e) {
                    this.input.close();
                    throw (IOException)new IOException().initCause(e);
                }
                catch (IOException e) {
                    this.input.close();
                    throw e;
                }
            }
        }
    }
}

