/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.Connection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
final class ConnectionToServer
extends Connection {
    private final Connection.ConnectionId connectionId;
    private final SocketAddress remoteServer;
    private final Socket[] sockets = new Socket[3];

    ConnectionToServer(InetSocketAddress localServer, InetSocketAddress remoteServer) {
        super(localServer);
        if (remoteServer == null) {
            throw new NullPointerException();
        }
        this.remoteServer = remoteServer;
        this.connectionId = new Connection.ConnectionId(localServer);
        for (int i = 0; i < 3; ++i) {
            this.sockets[i] = new Socket();
        }
    }

    void open() throws SocketTimeoutException, SocketException, IOException {
        try {
            for (Socket socket : this.sockets) {
                socket.setSoLinger(false, 0);
                socket.setTcpNoDelay(false);
                socket.setKeepAlive(true);
                socket.connect(this.remoteServer, SO_TIMEOUT);
                this.add(new ClientSideStream(socket));
            }
        }
        catch (IOException e) {
            this.close();
            if (e instanceof SocketTimeoutException) {
                throw (SocketTimeoutException)e;
            }
            if (e instanceof SocketException) {
                throw (SocketException)e;
            }
            throw e;
        }
    }

    @Override
    void close() {
        for (Socket socket : this.sockets) {
            try {
                socket.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        super.close();
    }

    @Override
    public synchronized String toString() {
        StringBuilder buf = new StringBuilder(this.getClass().getSimpleName());
        buf.append("[localAddress=");
        buf.append(this.getSocket(0).getLocalAddress());
        buf.append(",localPorts={");
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(this.getSocket(i).getLocalPort());
        }
        buf.append("},remoteAddress=");
        buf.append(this.getSocket(0).getInetAddress());
        buf.append(",remotePort=");
        buf.append(this.getSocket(0).getPort());
        buf.append("]");
        return buf.toString();
    }

    @ThreadSafe
    private final class ClientSideStream
    extends Connection.Stream {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClientSideStream(Socket socket) throws IOException {
            super(socket);
            ClientSideStream clientSideStream = this;
            synchronized (clientSideStream) {
                this.clientSocketAddress = new InetSocketAddress(socket.getLocalAddress(), socket.getLocalPort());
                this.output = new Connection.Stream.Output(this, new ObjectOutputStream(socket.getOutputStream()));
                try {
                    this.output.send(ConnectionToServer.this.connectionId);
                    this.input = new Connection.Stream.Input(this, new ObjectInputStream(socket.getInputStream()));
                    this.remoteServerSocketAddress = new InetSocketAddress(socket.getInetAddress(), socket.getPort());
                }
                catch (IOException e) {
                    this.output.close();
                    throw e;
                }
            }
        }
    }
}

