/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.FileInfo;
import java.io.File;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
final class DataProduct {
    private final Path archivePath;
    private final FileInfo fileInfo;

    DataProduct(Path archivePath, FileInfo fileInfo) {
        if (!archivePath.isAbsolute()) {
            throw new IllegalArgumentException("Not absolute: " + archivePath);
        }
        if (fileInfo == null) {
            throw new NullPointerException();
        }
        this.archivePath = archivePath;
        this.fileInfo = fileInfo;
    }

    FileInfo getFileInfo() {
        return this.fileInfo;
    }

    long size() {
        return this.fileInfo.getSize();
    }

    boolean matches(Pattern pattern) {
        return this.fileInfo.matches(pattern);
    }

    Matcher matcher(Pattern pattern) {
        return this.fileInfo.matcher(pattern);
    }

    File getAbsolutePath() {
        Path path = this.fileInfo.getAbsolutePath(this.archivePath);
        return new File(path.toString());
    }

    SeekableByteChannel getReadonlyChannel() throws IOException {
        Path path = this.fileInfo.getAbsolutePath(this.archivePath);
        return Files.newByteChannel(path, StandardOpenOption.READ);
    }

    public String toString() {
        return "DataProduct [archivePath=" + this.archivePath + ", fileInfo=" + this.fileInfo + "]";
    }
}

