/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.Action;
import edu.ucar.unidata.sruth.DataProduct;
import edu.ucar.unidata.sruth.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.regex.Matcher;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;

@NotThreadSafe
public final class DecodeAction
extends Action {
    private static Logger logger = Util.getLogger();
    private final String[] command;

    public DecodeAction(String[] command) {
        this.command = (String[])command.clone();
    }

    public DecodeAction(List<String> command) {
        this.command = command.toArray(new String[command.size()]);
    }

    @Override
    protected void execute(Matcher matcher, DataProduct dataProduct) throws IOException, InterruptedException {
        assert (dataProduct.matches(matcher.pattern()));
        Action.Replacer replacer = DecodeAction.getReplacer(matcher);
        String[] cmd = (String[])this.command.clone();
        for (int argIndex = 0; argIndex < cmd.length; ++argIndex) {
            cmd[argIndex] = replacer.replace(cmd[argIndex]);
        }
        this.decode(dataProduct, cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decode(DataProduct dataProduct, String ... decoder) throws IOException, InterruptedException {
        ProcessBuilder builder = new ProcessBuilder(decoder);
        builder.redirectInput(dataProduct.getAbsolutePath());
        builder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        Process process = builder.start();
        try {
            BufferedReader errorStream = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            try {
                String line = errorStream.readLine();
                while (line != null) {
                    logger.error(line);
                    line = errorStream.readLine();
                }
                process.waitFor();
                int status = process.exitValue();
                if (status != 0) {
                    logger.error("Decoder \"{}\" terminated with status {}", (Object)Util.getCommand(builder.command()), (Object)status);
                }
            }
            finally {
                try {
                    errorStream.close();
                }
                catch (IOException ignored) {}
            }
        }
        finally {
            process.destroy();
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [command=\"" + Util.formatCommand(this.command) + "\"]";
    }
}

