/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.PathDelayQueue;
import edu.ucar.unidata.sruth.Util;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;

@ThreadSafe
final class DelayedPathActionQueue {
    private static Logger logger = Util.getLogger();
    private final PathDelayQueue queue;
    private final Path rootDir;
    private final Thread thread;
    private IOException exception = null;
    private static AtomicInteger threadIndex = new AtomicInteger(0);
    private final Action action;
    @GuardedBy(value="this")
    private int pendingCount = 0;
    @GuardedBy(value="this")
    private long actedUponCount = 0L;

    DelayedPathActionQueue(final Path rootDir, final PathDelayQueue queue, final Action action) {
        if (rootDir == null || queue == null || action == null) {
            throw new NullPointerException();
        }
        this.rootDir = rootDir;
        this.queue = queue;
        this.action = action;
        this.thread = new Thread("DelayedPathActionQueue-" + threadIndex.getAndIncrement()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block18: {
                    try {
                        DelayedPathActionQueue.this.run();
                    }
                    catch (InterruptedException e) {
                        logger.trace("Interrupted: {}", this);
                    }
                    catch (IOException e) {
                        if (this.isInterrupted()) break block18;
                        DelayedPathActionQueue delayedPathActionQueue = DelayedPathActionQueue.this;
                        synchronized (delayedPathActionQueue) {
                            DelayedPathActionQueue.this.exception = e;
                        }
                    }
                    finally {
                        try {
                            queue.close();
                        }
                        catch (IOException ignored) {}
                    }
                }
            }

            @Override
            public String toString() {
                return "DelayedPathActionQueue$Thread [rootDir=" + rootDir + ", queue=" + queue + ", action=" + action + "]";
            }
        };
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() throws InterruptedException, IOException {
        while (true) {
            Path path = this.queue.take();
            this.action.act(path);
            DelayedPathActionQueue delayedPathActionQueue = this;
            synchronized (delayedPathActionQueue) {
                ++this.actedUponCount;
                --this.pendingCount;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void actUponEventurally(Path path, long time) throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
        if (!path.startsWith(this.rootDir)) {
            throw new IllegalArgumentException("Path not descendant of root-directory: path=\"" + path + "\", rootDir=\"" + this.rootDir + "\"");
        }
        DelayedPathActionQueue delayedPathActionQueue = this;
        synchronized (delayedPathActionQueue) {
            ++this.pendingCount;
        }
        if (time <= 0L) {
            this.action.act(path);
            delayedPathActionQueue = this;
            synchronized (delayedPathActionQueue) {
                ++this.actedUponCount;
                --this.pendingCount;
                this.notifyAll();
            }
        } else {
            this.queue.add(path, System.currentTimeMillis() + time);
        }
    }

    synchronized int getPendingCount() {
        return this.pendingCount;
    }

    synchronized long getActedUponCount() {
        return this.actedUponCount;
    }

    synchronized void waitUntilEmpty() throws InterruptedException {
        while (this.pendingCount > 0) {
            this.wait();
        }
    }

    void stop() throws InterruptedException, IOException {
        if (this.thread.isAlive()) {
            this.thread.interrupt();
            this.thread.join();
        }
    }

    public String toString() {
        return "DelayedPathActionQueue [queue=" + this.queue + ", actedUponCount=" + this.actedUponCount + ", rootDir=" + this.rootDir + ", action=" + this.action + "]";
    }

    static abstract class Action {
        Action() {
        }

        abstract void act(Path var1) throws IOException;
    }
}

