/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.Action;
import edu.ucar.unidata.sruth.DataProduct;
import edu.ucar.unidata.sruth.Util;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Matcher;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;

@NotThreadSafe
public final class FileAction
extends Action {
    private final String path;
    private static final Logger logger = Util.getLogger();

    public FileAction(String path) {
        if (path == null) {
            throw new NullPointerException();
        }
        this.path = path;
    }

    @Override
    protected void execute(Matcher matcher, DataProduct dataProduct) throws IOException {
        assert (dataProduct.matches(matcher.pattern()));
        Action.Replacer replacer = FileAction.getReplacer(matcher);
        String pathname = replacer.replace(this.path);
        Path destPath = Paths.get(pathname, new String[0]);
        this.write(dataProduct, destPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(DataProduct dataProduct, Path destPath) throws IOException {
        Files.createDirectories(destPath.getParent(), new FileAttribute[0]);
        try (FileChannel outChannel = FileChannel.open(destPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
             SeekableByteChannel inChannel = dataProduct.getReadonlyChannel();){
            logger.info("Filing {}", destPath);
            outChannel.transferFrom(inChannel, 0L, dataProduct.size());
        }
        catch (IOException e) {
            try {
                Files.delete(destPath);
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public String toString() {
        return "FileAction [path=" + this.path + "]";
    }
}

