/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.ArchivePath;
import edu.ucar.unidata.sruth.ArchiveTime;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.Immutable;

@Immutable
final class FileId
implements Serializable,
Comparable<FileId> {
    private static final long serialVersionUID = 1L;
    private final ArchivePath path;
    private final ArchiveTime time;

    FileId(ArchivePath path, ArchiveTime time) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (time == null) {
            throw new NullPointerException();
        }
        this.path = path;
        this.time = time;
    }

    FileId(ArchivePath archivePath) {
        this(archivePath, new ArchiveTime());
    }

    static FileId getInstance(Path path, Path rootDir) throws IOException {
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException(path.toString());
        }
        if (!rootDir.isAbsolute()) {
            throw new IllegalArgumentException(rootDir.toString());
        }
        ArchivePath archivePath = new ArchivePath(path, rootDir);
        ArchiveTime time = new ArchiveTime(path);
        return new FileId(archivePath, time);
    }

    ArchivePath getPath() {
        return this.path;
    }

    ArchiveTime getTime() {
        return this.time;
    }

    boolean matches(Pattern pattern) {
        return this.path.matches(pattern);
    }

    Matcher matcher(Pattern pattern) {
        return this.path.matcher(pattern);
    }

    @Override
    public int compareTo(FileId that) {
        if (this == that) {
            return 0;
        }
        int cmp = -this.time.compareTo(that.time);
        if (cmp == 0) {
            cmp = this.path.compareTo(that.path);
        }
        return cmp;
    }

    Path getAbsolutePath(Path rootDir) {
        return this.path.getAbsolutePath(rootDir);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileId)) {
            return false;
        }
        FileId other = (FileId)obj;
        return this.compareTo(other) == 0;
    }

    public int hashCode() {
        return this.path.hashCode() ^ this.time.hashCode();
    }

    public String toString() {
        return "FileId [path=" + this.path + ", time=" + this.time + "]";
    }

    private Object readResolve() throws ObjectStreamException {
        try {
            return new FileId(this.path, this.time);
        }
        catch (NullPointerException e) {
            throw (ObjectStreamException)new InvalidObjectException("Invalid argument").initCause(e);
        }
    }
}

