/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.ArchivePath;
import edu.ucar.unidata.sruth.ArchiveTime;
import edu.ucar.unidata.sruth.FileId;
import edu.ucar.unidata.sruth.PieceSpec;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class FileInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int PIECE_SIZE = 131072;
    public static final String TIME_TO_LIVE_KEY = "timeToLive";
    public static final int TIME_TO_LIVE;
    public static final int TIME_TO_LIVE_DEFAULT = 3600;
    private final FileId fileId;
    private final long fileSize;
    private final int pieceSize;
    private final transient int lastIndex;
    private final int timeToLive;

    FileInfo(FileId fileId, long fileSize) {
        this(fileId, fileSize, 131072);
    }

    FileInfo(FileId fileId, long fileSize, int pieceSize) {
        this(fileId, fileSize, pieceSize, TIME_TO_LIVE);
    }

    FileInfo(FileId fileId, long fileSize, int pieceSize, int timeToLive) {
        if (null == fileId) {
            throw new NullPointerException();
        }
        if (0L > fileSize) {
            throw new IllegalArgumentException("Invalid file-size: " + fileSize);
        }
        if (0L == fileSize) {
            this.lastIndex = 0;
            pieceSize = 131072;
        } else {
            if (pieceSize <= 0) {
                throw new IllegalArgumentException("Invalid piece-size: pieceSize=" + pieceSize + ", fileSize=" + fileSize + ", fileId=" + fileId);
            }
            this.lastIndex = (int)((fileSize - 1L) / (long)pieceSize);
        }
        if (timeToLive < -1 || timeToLive == 0) {
            throw new IllegalArgumentException("Invalid time-to-live: " + timeToLive);
        }
        this.fileId = fileId;
        this.fileSize = fileSize;
        this.pieceSize = pieceSize;
        this.timeToLive = timeToLive;
    }

    static int getDefaultPieceSize() {
        return 131072;
    }

    int getPieceSize() {
        return this.pieceSize;
    }

    private int lastSize() {
        return 0L == this.fileSize ? 0 : (int)((this.fileSize - 1L) % (long)this.pieceSize) + 1;
    }

    void vet(long index) {
        if (0L > index || (long)this.lastIndex < index) {
            throw new IllegalArgumentException("Index lies outside valid range for " + this + ": " + index);
        }
    }

    void vet(long index, byte[] data) {
        long size;
        this.vet(index);
        long l = size = (long)this.lastIndex == index ? (long)this.lastSize() : (long)this.pieceSize;
        if ((long)data.length != size) {
            throw new IllegalArgumentException("Invalid data-size.  Should have " + size + " bytes; has " + data.length);
        }
    }

    FileId getFileId() {
        return this.fileId;
    }

    ArchivePath getPath() {
        return this.fileId.getPath();
    }

    ArchiveTime getTime() {
        return this.fileId.getTime();
    }

    Path getAbsolutePath(Path rootDir) {
        return this.fileId.getAbsolutePath(rootDir);
    }

    long getSize() {
        return this.fileSize;
    }

    int getSize(long index) {
        this.vet(index);
        return (long)this.lastIndex == index ? this.lastSize() : this.pieceSize;
    }

    int getPieceCount() {
        return this.lastIndex + 1;
    }

    int getTimeToLive() {
        return this.timeToLive;
    }

    long getOffset(long index) {
        this.vet(index);
        return this.fileSize == 0L ? 0L : (long)this.pieceSize * index;
    }

    void vet(PieceSpec pieceSpec) {
        if (!this.equals(pieceSpec.getFileInfo())) {
            throw new IllegalArgumentException();
        }
    }

    Iterator<PieceSpec> getPieceInfoIterator() {
        class PieceInfoIterator
        implements Iterator<PieceSpec> {
            private int index = 0;

            PieceInfoIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.index <= FileInfo.this.lastIndex;
            }

            @Override
            public PieceSpec next() {
                return new PieceSpec(FileInfo.this, this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
        return new PieceInfoIterator();
    }

    boolean matches(Pattern pattern) {
        return this.fileId.matches(pattern);
    }

    Matcher matcher(Pattern pattern) {
        return this.fileId.matcher(pattern);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fileId == null ? 0 : this.fileId.hashCode());
        result = 31 * result + (int)(this.fileSize ^ this.fileSize >>> 32);
        result = 31 * result + this.pieceSize;
        result = 31 * result + this.timeToLive;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileInfo)) {
            return false;
        }
        FileInfo other = (FileInfo)obj;
        if (this.fileId == null ? other.fileId != null : !this.fileId.equals(other.fileId)) {
            return false;
        }
        if (this.fileSize != other.fileSize) {
            return false;
        }
        if (this.pieceSize != other.pieceSize) {
            return false;
        }
        return this.timeToLive == other.timeToLive;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [filedId=" + this.fileId + ",fileSize=" + this.fileSize + ",pieceSize=" + this.pieceSize + ",timeToLive=" + this.timeToLive + "]";
    }

    private Object readResolve() throws InvalidObjectException {
        try {
            return new FileInfo(this.fileId, this.fileSize, this.pieceSize, this.timeToLive);
        }
        catch (Exception e) {
            throw (InvalidObjectException)new InvalidObjectException("Read invalid " + this.getClass().getSimpleName()).initCause(e);
        }
    }

    static {
        Preferences prefs = Preferences.userNodeForPackage(FileInfo.class);
        TIME_TO_LIVE = prefs.getInt(TIME_TO_LIVE_KEY, 3600);
        if (TIME_TO_LIVE <= 0) {
            throw new IllegalArgumentException("Invalid \"timeToLive\" preference: " + TIME_TO_LIVE);
        }
    }
}

