/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.ArchivePath;
import edu.ucar.unidata.sruth.FileId;
import edu.ucar.unidata.sruth.FileInfo;
import edu.ucar.unidata.sruth.FilePieceSpecs;
import edu.ucar.unidata.sruth.PieceSpec;
import edu.ucar.unidata.sruth.PieceSpecSetIface;
import java.io.Serializable;

abstract class FilePieceSpecSet
implements PieceSpecSetIface,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final FileInfo fileInfo;

    protected FilePieceSpecSet(FileInfo fileInfo) {
        if (null == fileInfo) {
            throw new NullPointerException();
        }
        this.fileInfo = fileInfo;
    }

    static FilePieceSpecSet newInstance(FileInfo fileInfo, boolean allPieces) {
        return allPieces ? (fileInfo.getPieceCount() == 1 ? new PieceSpec(fileInfo, 0) : new FilePieceSpecs(fileInfo, true)) : new FilePieceSpecs(fileInfo);
    }

    final FileInfo getFileInfo() {
        return this.fileInfo;
    }

    FileId getFileId() {
        return this.fileInfo.getFileId();
    }

    ArchivePath getArchivePath() {
        return this.fileInfo.getPath();
    }

    @Override
    public FilePieceSpecSet clone() {
        try {
            return (FilePieceSpecSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fileInfo == null ? 0 : this.fileInfo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilePieceSpecSet other = (FilePieceSpecSet)obj;
        return !(this.fileInfo == null ? other.fileInfo != null : !this.fileInfo.equals(other.fileInfo));
    }
}

