/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.FileInfo;
import edu.ucar.unidata.sruth.FilePieceSpecSet;
import edu.ucar.unidata.sruth.FiniteBitSet;
import edu.ucar.unidata.sruth.PieceSpec;
import edu.ucar.unidata.sruth.PieceSpecSet;
import edu.ucar.unidata.sruth.PieceSpecSetIface;
import edu.ucar.unidata.sruth.SimpleIterator;
import java.io.InvalidObjectException;
import java.util.Iterator;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
final class FilePieceSpecs
extends FilePieceSpecSet {
    private static final long serialVersionUID = 1L;
    @GuardedBy(value="this")
    private FiniteBitSet indexes;

    protected FilePieceSpecs(FileInfo fileInfo) {
        this(fileInfo, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FilePieceSpecs(FileInfo fileInfo, boolean allPieces) {
        super(fileInfo);
        FilePieceSpecs filePieceSpecs = this;
        synchronized (filePieceSpecs) {
            this.indexes = FiniteBitSet.newInstance(fileInfo.getPieceCount(), allPieces);
        }
    }

    @Override
    public PieceSpecSetIface merge(PieceSpecSetIface specs) {
        return specs.merge(this);
    }

    @Override
    public PieceSpecSetIface merge(PieceSpecSet specs) {
        return specs.merge(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PieceSpecSetIface merge(FilePieceSpecs that) {
        PieceSpecSetIface result;
        if (this == that) {
            return this;
        }
        if (!this.getFileId().equals(that.getFileId())) {
            result = new PieceSpecSet(this).merge(that);
        } else {
            FilePieceSpecs o2;
            FilePieceSpecs o1;
            this.vet(that.getFileInfo());
            if (System.identityHashCode(this) < System.identityHashCode(that)) {
                o1 = this;
                o2 = that;
            } else {
                o1 = that;
                o2 = this;
            }
            FilePieceSpecs filePieceSpecs = o1;
            synchronized (filePieceSpecs) {
                FilePieceSpecs filePieceSpecs2 = o2;
                synchronized (filePieceSpecs2) {
                    if (this.indexes.areAllSet()) {
                        result = this;
                    } else if (that.indexes.areAllSet()) {
                        result = that;
                    } else {
                        FiniteBitSet newIndexes = this.indexes.merge(that.indexes);
                        if (newIndexes.areAllSet()) {
                            result = new FilePieceSpecs(this.fileInfo, true);
                        } else {
                            this.indexes = newIndexes;
                            result = this;
                        }
                    }
                }
            }
        }
        return result;
    }

    private void vet(FileInfo actual) {
        FileInfo expected = this.getFileInfo();
        if (!expected.equals(actual)) {
            throw new IllegalArgumentException("expected=" + expected + ", actual=" + actual);
        }
    }

    @Override
    public synchronized PieceSpecSetIface merge(PieceSpec that) {
        if (this.getFileId().equals(that.getFileId())) {
            this.vet(that.getFileInfo());
            this.indexes = this.indexes.setBit(that.getIndex());
            return this;
        }
        return new PieceSpecSet(this).merge(that);
    }

    @Override
    public synchronized PieceSpecSetIface remove(PieceSpec spec) {
        if (this.fileInfo.equals(spec.fileInfo)) {
            this.indexes.clearBit(spec.getIndex());
        }
        return this;
    }

    @Override
    public synchronized boolean contains(PieceSpec spec) {
        return this.fileInfo.equals(spec.fileInfo) && this.indexes.isSet(spec.getIndex());
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.indexes.getSetCount() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized FilePieceSpecs clone() {
        FilePieceSpecs clone;
        FilePieceSpecs filePieceSpecs = clone = (FilePieceSpecs)super.clone();
        synchronized (filePieceSpecs) {
            clone.indexes = this.indexes.clone();
        }
        return clone;
    }

    @Override
    public Iterator<PieceSpec> iterator() {
        return new SimpleIterator<PieceSpec>(){
            private int index = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected PieceSpec getNext() {
                FilePieceSpecs filePieceSpecs = FilePieceSpecs.this;
                synchronized (filePieceSpecs) {
                    PieceSpec pieceSpec;
                    this.index = FilePieceSpecs.this.indexes.nextSetBit(this.index);
                    if (-1 == this.index) {
                        pieceSpec = null;
                    } else {
                        int n = this.index++;
                        pieceSpec = new PieceSpec(FilePieceSpecs.this.fileInfo, n);
                    }
                    return pieceSpec;
                }
            }
        };
    }

    public synchronized String toString() {
        return this.getClass().getSimpleName() + "{fileInfo=" + this.fileInfo + ",indexes=" + this.indexes + "}";
    }

    private Object readResolve() throws InvalidObjectException {
        if (this.fileInfo.getPieceCount() != this.indexes.getSize()) {
            throw new InvalidObjectException(this.toString());
        }
        return this;
    }
}

