/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.ArchivePath;
import edu.ucar.unidata.sruth.Connection;
import net.jcip.annotations.Immutable;

@Immutable
public class Filter
implements Comparable<Filter>,
Connection.Message {
    private static final long serialVersionUID = 1L;
    public static final Filter EVERYTHING = new Filter(new String[0]){
        private static final long serialVersionUID = 1L;

        @Override
        boolean matches(ArchivePath path) {
            return true;
        }

        @Override
        boolean matchesOnly(ArchivePath archivePath) {
            return false;
        }

        @Override
        boolean includes(Filter filter) {
            return true;
        }

        @Override
        public int compareTo(Filter that) {
            return this == that ? 0 : -1;
        }

        @Override
        public String toString() {
            return "EVERYTHING";
        }
    };
    public static final Filter NOTHING = new Filter(null){
        private static final long serialVersionUID = 1L;

        @Override
        boolean matches(ArchivePath path) {
            return false;
        }

        @Override
        boolean matchesOnly(ArchivePath archivePath) {
            return false;
        }

        @Override
        boolean includes(Filter filter) {
            return false;
        }

        @Override
        public int compareTo(Filter that) {
            return this == that ? 0 : 1;
        }

        @Override
        public String toString() {
            return "NOTHING";
        }
    };
    private final String glob;
    private final transient String[] components;
    private final transient boolean containsMeta;

    public static Filter getInstance(String glob) {
        if (glob == null) {
            return NOTHING;
        }
        if (glob.length() == 0) {
            return EVERYTHING;
        }
        String[] components = glob.split("/");
        return (components = Filter.canonicalize(components)).length == 0 ? EVERYTHING : new Filter(components);
    }

    private static String[] canonicalize(String[] components) {
        int i = components.length;
        while (--i >= 0 && (components[i].length() == 0 || components[i].equals("*"))) {
        }
        if (i == components.length - 1) {
            return components;
        }
        String[] newComponents = new String[i + 1];
        for (int j = 0; j <= i; ++j) {
            newComponents[j] = components[j];
        }
        return newComponents;
    }

    private Filter(String[] components) {
        if (components == null) {
            this.containsMeta = false;
            this.glob = null;
            this.components = null;
        } else {
            StringBuilder buf = new StringBuilder();
            boolean containsMeta = false;
            for (int i = 0; i < components.length; ++i) {
                String component = components[i];
                if (component.length() == 0) {
                    throw new IllegalArgumentException("component[" + i + "]=\"" + component + "\"");
                }
                if (component.contains("*")) {
                    if (component.length() == 1) {
                        containsMeta = true;
                    } else {
                        throw new IllegalArgumentException();
                    }
                }
                if (i > 0) {
                    buf.append("/");
                }
                buf.append(component);
            }
            this.containsMeta = containsMeta;
            this.glob = buf.toString();
            this.components = components;
        }
    }

    boolean matches(ArchivePath archivePath) {
        if (archivePath.getNameCount() < this.components.length) {
            return false;
        }
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i].equals("*") || this.components[i].equals(archivePath.getName(i).toString())) continue;
            return false;
        }
        return true;
    }

    boolean matchesOnly(ArchivePath archivePath) {
        if (this.containsMeta) {
            return false;
        }
        if (archivePath.getNameCount() != this.components.length) {
            return false;
        }
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i].equals(archivePath.getName(i).toString())) continue;
            return false;
        }
        return true;
    }

    boolean includes(Filter that) {
        if (that == EVERYTHING) {
            return false;
        }
        if (that == NOTHING) {
            return false;
        }
        if (this.components.length > that.components.length) {
            return false;
        }
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i].equals(that.components[i]) || this.components[i].equals("*")) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.glob == null ? 0 : this.glob.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Filter other = (Filter)obj;
        return this.compareTo(other) == 0;
    }

    @Override
    public int compareTo(Filter that) {
        if (this == that) {
            return 0;
        }
        if (this.glob == null) {
            return that.glob == null ? 0 : 1;
        }
        if (that.glob == null) {
            return -1;
        }
        for (int i = 0; i < this.components.length; ++i) {
            if (i >= that.components.length) {
                return 1;
            }
            if (this.components[i].equals(that.components[i])) continue;
            return this.components[i].equals("*") ? -1 : (that.components[i].equals("*") ? 1 : this.components[i].compareTo(that.components[i]));
        }
        return this.components.length == that.components.length ? 0 : -1;
    }

    public String toString() {
        return "Filter [glob=" + this.glob + "]";
    }

    protected Object readResolve() {
        return Filter.getInstance(this.glob);
    }
}

