/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.CompleteBitSet;
import edu.ucar.unidata.sruth.PartialBitSet;
import java.io.Serializable;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
abstract class FiniteBitSet
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected final int size;

    protected FiniteBitSet(int size) {
        if (0 > size) {
            throw new IllegalArgumentException();
        }
        this.size = size;
    }

    public static FiniteBitSet newInstance(int size) {
        return FiniteBitSet.newInstance(size, false);
    }

    static FiniteBitSet newInstance(int size, boolean setAll) {
        return 0 == size || setAll ? new CompleteBitSet(size) : new PartialBitSet(size);
    }

    final int getSize() {
        return this.size;
    }

    protected final void vetIndex(int index) {
        if (0 > index || this.size <= index) {
            throw new IllegalArgumentException("numBits=" + this.size + ", index=" + index);
        }
    }

    abstract FiniteBitSet setBit(int var1);

    abstract FiniteBitSet clearBit(int var1);

    abstract FiniteBitSet setAll();

    abstract int getSetCount();

    abstract boolean isSet(int var1);

    abstract boolean areAllSet();

    abstract int nextSetBit(int var1);

    protected final void vetForMerger(FiniteBitSet that) {
        if (this.size != that.size) {
            throw new IllegalArgumentException();
        }
    }

    abstract FiniteBitSet merge(FiniteBitSet var1);

    protected abstract FiniteBitSet merge(PartialBitSet var1);

    protected final FiniteBitSet merge(CompleteBitSet that) {
        this.vetForMerger(that);
        return that;
    }

    public FiniteBitSet clone() {
        try {
            return (FiniteBitSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

