/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.PortNumberSet;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
final class InetSocketAddressSet {
    private final InetAddress inetAddress;
    private final PortNumberSet portSet;

    InetSocketAddressSet() throws UnknownHostException {
        this(null, null);
    }

    InetSocketAddressSet(InetAddress inetAddress) throws UnknownHostException {
        this(inetAddress, null);
    }

    InetSocketAddressSet(PortNumberSet portSet) throws UnknownHostException {
        this(null, portSet);
    }

    InetSocketAddressSet(InetAddress inetAddress, PortNumberSet portSet) throws UnknownHostException {
        if (inetAddress == null) {
            inetAddress = InetAddress.getLocalHost();
        }
        if (portSet == null) {
            portSet = PortNumberSet.EPHEMERAL;
        }
        this.inetAddress = inetAddress;
        this.portSet = portSet;
    }

    InetAddress getInetAddress() {
        return this.inetAddress;
    }

    PortNumberSet getPortNumberSet() {
        return this.portSet;
    }

    boolean bind(ServerSocket socket) {
        PortNumberSet portSet = this.getPortNumberSet();
        InetAddress inetAddress = this.getInetAddress();
        for (int port : portSet) {
            try {
                InetSocketAddress inetSocketAddress = inetAddress == null ? new InetSocketAddress(port) : new InetSocketAddress(inetAddress, port);
                socket.bind(inetSocketAddress);
                return true;
            }
            catch (IOException ignored) {
            }
        }
        return false;
    }

    public String toString() {
        return "InetSocketAddressSet [inetAddress=" + (this.inetAddress == null ? "ANY" : this.inetAddress) + ", portSet=" + this.portSet + "]";
    }
}

