/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
final class MinHeapFile<E extends Element>
implements Iterable<E> {
    private final Class<E> type;
    private final Header header;
    private final IoHandler ioHandler;
    private final Heap<E> elements;
    @GuardedBy(value="this")
    private int capacity;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MinHeapFile(Path path, int eltSize, Class<E> type) throws IOException {
        if (eltSize <= 0) {
            throw new IllegalArgumentException("Non-positive maximum element size: " + eltSize);
        }
        if (type == null) {
            throw new NullPointerException();
        }
        this.type = type;
        this.ioHandler = new IoHandler(path);
        this.header = new Header(this.ioHandler, 0, eltSize);
        this.elements = new Heap<E>(this.ioHandler, this.header, this.header.getSize(), type);
        MinHeapFile minHeapFile = this;
        synchronized (minHeapFile) {
            this.capacity = (this.ioHandler.size() - this.header.getSize()) / this.header.getEltSize();
        }
    }

    synchronized void add(E elt) throws IOException, InstantiationException, IllegalAccessException {
        int parentIndex;
        E parent;
        int eltCount = this.header.getEltCount();
        this.ensureCapacity(this.header.getEltCount() + 1);
        int childIndex = eltCount;
        while (childIndex > 0 && (parent = this.elements.getElt(parentIndex = (childIndex - 1) / 2)).compareTo(elt) > 0) {
            ((Heap)this.elements).setElt(childIndex, parent);
            childIndex = parentIndex;
        }
        ((Heap)this.elements).setElt(childIndex, elt);
        this.header.setEltCount(eltCount + 1);
    }

    private synchronized void ensureCapacity(int eltCount) throws IOException {
        if (eltCount < 0) {
            throw new IllegalArgumentException("Invalid capacity: " + eltCount);
        }
        if (eltCount > this.capacity) {
            int newCapacity = (int)Math.round((double)eltCount * 1.61803399);
            this.ioHandler.ensureSize(this.header.getSize() + newCapacity * this.header.getEltSize());
            this.capacity = newCapacity;
        }
    }

    synchronized E peek() throws ClosedByInterruptException, InstantiationException, IllegalAccessException, IOException {
        return this.header.getEltCount() > 0 ? (E)this.elements.getElt(0) : null;
    }

    synchronized E remove() throws ClosedChannelException, IOException, InstantiationException, IllegalAccessException {
        E firstElt;
        int eltCount = this.header.getEltCount();
        if (eltCount <= 0) {
            firstElt = null;
        } else {
            firstElt = this.elements.getElt(0);
            E elt = this.elements.getElt(--eltCount);
            int parentIndex = 0;
            int childIndex = 1;
            while (childIndex < eltCount) {
                E otherChild;
                E child = this.elements.getElt(childIndex);
                if (childIndex + 1 < eltCount && child.compareTo(otherChild = this.elements.getElt(childIndex + 1)) > 0) {
                    child = otherChild;
                    ++childIndex;
                }
                if (child.compareTo(elt) >= 0) break;
                ((Heap)this.elements).setElt(parentIndex, child);
                parentIndex = childIndex;
                childIndex = 2 * parentIndex + 1;
            }
            ((Heap)this.elements).setElt(parentIndex, elt);
            this.header.setEltCount(eltCount);
        }
        return firstElt;
    }

    int size() {
        return this.header.getEltCount();
    }

    void close() throws IOException {
        this.ioHandler.close();
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int index = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                MinHeapFile heap;
                MinHeapFile minHeapFile = heap = MinHeapFile.this;
                synchronized (minHeapFile) {
                    return this.index < MinHeapFile.this.header.getEltCount();
                }
            }

            @Override
            public E next() {
                try {
                    return MinHeapFile.this.elements.getElt(this.index++);
                }
                catch (Exception e) {
                    throw (NoSuchElementException)new NoSuchElementException("Index=" + this.index).initCause(e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public synchronized String toString() {
        return "MinHeapFile [eltCount=" + this.size() + ", type=" + this.type + ", eltSize=" + this.header.getEltSize() + "]";
    }

    @Immutable
    static abstract class Element
    implements Comparable<Element> {
        Element() {
        }

        public abstract void write(ByteBuffer var1) throws IOException;

        public abstract void read(ByteBuffer var1) throws IOException;
    }

    private static class Heap<E extends Element> {
        private final IoHandler ioHandler;
        private final Header header;
        private final int position;
        private final Class<E> type;

        Heap(IoHandler ioHandler, Header header, int position, Class<E> type) throws IOException {
            this.ioHandler = ioHandler;
            this.header = header;
            this.position = position;
            this.type = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        E getElt(int index) throws ClosedChannelException, InstantiationException, IllegalAccessException, IOException {
            FileLock lock = this.ioHandler.lock(this.offsetToElement(index), this.header.getEltSize(), true);
            try {
                Element instance = (Element)this.type.newInstance();
                instance.read(this.getEltBuffer(index));
                Element element = instance;
                return (E)element;
            }
            finally {
                lock.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setElt(int index, E elt) throws IOException {
            FileLock lock = this.ioHandler.lock(this.offsetToElement(index), this.header.getEltSize(), false);
            try {
                ByteBuffer buffer = this.getEltBuffer(index);
                ((Element)elt).write(buffer);
                this.ioHandler.force(buffer);
            }
            finally {
                lock.release();
            }
        }

        private int offsetToElement(int index) {
            if (index < 0) {
                throw new IllegalArgumentException("Invalid index: " + index);
            }
            return this.position + index * this.header.getEltSize();
        }

        private ByteBuffer getEltBuffer(int index) throws ClosedChannelException, IOException {
            IoHandler.MyBuffer buf = this.ioHandler.getBuffer(this.offsetToElement(index), this.header.getEltSize());
            return buf.getByteBuffer();
        }
    }

    private static class Header {
        private static final short VERSION = 1;
        private static final int HEADER_SIZE = 12;
        private final IoHandler.MyBuffer eltCountBuffer;
        private final int eltSize;
        @GuardedBy(value="this")
        private int eltCount;

        Header(IoHandler ioHandler, int position, int eltSize) throws IOException {
            int eltCountPosition;
            if (position + 12 > ioHandler.size()) {
                ioHandler.ensureSize(position + 12);
                IoHandler.MyBuffer headBuf = ioHandler.getBuffer(position, 12);
                headBuf.putInt(1);
                headBuf.putInt(eltSize);
                eltCountPosition = headBuf.position();
                headBuf.putInt(0);
                headBuf.force();
            } else {
                IoHandler.MyBuffer headBuf = ioHandler.getBuffer(position, 12);
                int version = headBuf.getInt();
                if (version != 1) {
                    throw new IllegalStateException("Corrupt file: unexpected version: " + version + " != " + 1);
                }
                int actualEltSize = headBuf.getInt();
                if (actualEltSize != eltSize) {
                    throw new IllegalArgumentException("Element size inconsistancy: " + actualEltSize + " != " + eltSize);
                }
                eltCountPosition = headBuf.position();
                this.eltCount = headBuf.getInt();
                if (this.eltCount < 0) {
                    throw new IllegalStateException("Corrupt file: negative element count: " + this.eltCount);
                }
            }
            this.eltCountBuffer = ioHandler.getBuffer(eltCountPosition, 4);
            this.eltSize = eltSize;
        }

        int getSize() {
            return 12;
        }

        int getEltSize() {
            return this.eltSize;
        }

        synchronized void setEltCount(int eltCount) {
            this.eltCount = eltCount;
            this.eltCountBuffer.rewind();
            this.eltCountBuffer.putInt(eltCount);
            this.eltCountBuffer.force();
        }

        synchronized int getEltCount() {
            return this.eltCount;
        }
    }

    @ThreadSafe
    private static class IoHandler {
        private final FileChannel channel;
        @GuardedBy(value="this")
        private MappedByteBuffer buf;

        IoHandler(Path path) throws IOException {
            this.channel = FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
            this.initMappedBuffer();
        }

        private synchronized void initMappedBuffer() throws IOException {
            this.buf = this.channel.map(FileChannel.MapMode.READ_WRITE, 0L, this.channel.size());
        }

        private synchronized void force() {
            this.buf.force();
        }

        int size() throws IOException {
            return (int)this.channel.size();
        }

        synchronized MyBuffer getBuffer(int position, int length) throws IOException {
            this.buf.position(position);
            ByteBuffer regBuf = this.buf.slice();
            regBuf.limit(length);
            return new MyBuffer(regBuf);
        }

        synchronized void ensureSize(long size) throws IOException {
            if (size < 0L) {
                throw new IllegalArgumentException("Invalid size: " + size);
            }
            if (this.channel.size() < size) {
                this.channel.position(size - 1L);
                this.channel.write(ByteBuffer.wrap(new byte[]{0}));
                this.channel.force(false);
                this.initMappedBuffer();
            }
        }

        synchronized FileLock lock(long position, int size, boolean shared) throws IOException {
            return this.channel.lock(position, size, shared);
        }

        void force(ByteBuffer buffer) {
            this.force();
        }

        synchronized void close() throws IOException {
            if (this.channel.isOpen()) {
                this.channel.close();
            }
        }

        private class MyBuffer {
            private final ByteBuffer buf;

            MyBuffer(ByteBuffer buf) {
                this.buf = buf;
            }

            void putInt(int value) {
                this.buf.putInt(value);
            }

            int position() {
                return this.buf.position();
            }

            void force() {
                IoHandler.this.force();
            }

            int getInt() {
                return this.buf.getInt();
            }

            void rewind() {
                this.buf.rewind();
            }

            ByteBuffer getByteBuffer() {
                return this.buf;
            }
        }
    }
}

