/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.Connection;
import edu.ucar.unidata.sruth.Filter;
import edu.ucar.unidata.sruth.Predicate;
import java.net.InetSocketAddress;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
final class NodeInfo
implements Connection.Message {
    private static final long serialVersionUID = 1L;
    private final Predicate predicate;
    private final InetSocketAddress inetSocketAddress;

    NodeInfo(InetSocketAddress comparableInetSocketAddress, Predicate predicate) {
        if (comparableInetSocketAddress == null) {
            throw new NullPointerException();
        }
        if (predicate == null) {
            throw new NullPointerException();
        }
        this.inetSocketAddress = comparableInetSocketAddress;
        this.predicate = predicate;
    }

    Predicate getPredicate() {
        return this.predicate;
    }

    Set<Filter> getFilters() {
        return this.predicate.getFilters();
    }

    InetSocketAddress getServerInfo() {
        return this.inetSocketAddress;
    }

    boolean isBetterThan(NodeInfo that) {
        return this.predicate.isMoreInclusiveThan(that.predicate);
    }

    public String toString() {
        return "NodeInfo [predicate=" + this.predicate + ", inetSocketAddress=" + this.inetSocketAddress + "]";
    }
}

