/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
final class ObjectLock<T> {
    @GuardedBy(value="this")
    private T content;
    @GuardedBy(value="this")
    private boolean isEmpty = true;

    ObjectLock() {
    }

    synchronized T put(T next) {
        T prev = this.content;
        this.content = next;
        this.isEmpty = false;
        this.notify();
        return prev;
    }

    synchronized T take() throws InterruptedException {
        while (this.isEmpty) {
            this.wait();
        }
        this.isEmpty = true;
        return this.content;
    }

    public synchronized String toString() {
        return this.getClass().getSimpleName() + " [content=" + this.content + "]";
    }
}

