/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.CompleteBitSet;
import edu.ucar.unidata.sruth.FiniteBitSet;
import java.io.InvalidObjectException;
import java.util.BitSet;
import net.jcip.annotations.GuardedBy;

final class PartialBitSet
extends FiniteBitSet {
    private static final long serialVersionUID = 1L;
    @GuardedBy(value="this")
    private BitSet bitSet;
    @GuardedBy(value="this")
    private int setCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PartialBitSet(int size) {
        super(size);
        PartialBitSet partialBitSet = this;
        synchronized (partialBitSet) {
            this.bitSet = new BitSet();
            this.setCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PartialBitSet(int size, int index) {
        super(size);
        PartialBitSet partialBitSet = this;
        synchronized (partialBitSet) {
            this.bitSet = new BitSet(size);
            this.bitSet.set(0, size - 1);
            this.setCount = size - 1;
        }
    }

    @Override
    synchronized FiniteBitSet setBit(int index) {
        FiniteBitSet result;
        this.vetIndex(index);
        if (this.bitSet.get(index)) {
            result = this;
        } else if (this.setCount == this.size - 1) {
            result = new CompleteBitSet(this.size);
        } else {
            this.bitSet.set(index);
            ++this.setCount;
            result = this;
        }
        return result;
    }

    @Override
    synchronized FiniteBitSet clearBit(int index) {
        this.vetIndex(index);
        if (this.bitSet.get(index)) {
            this.bitSet.clear(index);
            --this.setCount;
        }
        return this;
    }

    @Override
    FiniteBitSet setAll() {
        return new CompleteBitSet(this.size);
    }

    @Override
    synchronized boolean isSet(int index) {
        return this.bitSet.get(index);
    }

    @Override
    synchronized boolean areAllSet() {
        return this.size == this.setCount;
    }

    @Override
    synchronized int nextSetBit(int i) {
        return this.bitSet.nextSetBit(i);
    }

    @Override
    synchronized int getSetCount() {
        return this.setCount;
    }

    @Override
    FiniteBitSet merge(FiniteBitSet that) {
        return that.merge(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FiniteBitSet merge(PartialBitSet that) {
        FiniteBitSet result;
        PartialBitSet set2;
        PartialBitSet set1;
        if (this == that) {
            return this;
        }
        this.vetForMerger(that);
        if (System.identityHashCode(this) < System.identityHashCode(that)) {
            set1 = this;
            set2 = that;
        } else {
            set1 = that;
            set2 = this;
        }
        PartialBitSet partialBitSet = set1;
        synchronized (partialBitSet) {
            PartialBitSet partialBitSet2 = set2;
            synchronized (partialBitSet2) {
                BitSet newBitSet = (BitSet)this.bitSet.clone();
                int newSetCount = newBitSet.cardinality();
                if (this.size == newSetCount) {
                    result = new CompleteBitSet(this.size);
                } else {
                    this.bitSet = newBitSet;
                    this.setCount = newSetCount;
                    result = this;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized PartialBitSet clone() {
        PartialBitSet clone;
        PartialBitSet partialBitSet = clone = (PartialBitSet)super.clone();
        synchronized (partialBitSet) {
            clone.bitSet.and(this.bitSet);
        }
        return clone;
    }

    public synchronized String toString() {
        return this.getClass().getSimpleName() + "{size=" + this.size + ", setCount=" + this.setCount + "}";
    }

    private Object readResolve() throws InvalidObjectException {
        if (0 > this.size) {
            throw new InvalidObjectException("Invalid size: " + this.size);
        }
        if (0 > this.setCount) {
            throw new InvalidObjectException("Invalid setCount: " + this.size);
        }
        if (this.size <= this.setCount) {
            throw new InvalidObjectException("Size (" + this.size + ") <= setCount (" + this.setCount + ")");
        }
        if (this.bitSet.cardinality() != this.setCount) {
            throw new InvalidObjectException("Cardinality (" + this.bitSet.cardinality() + ") != setCount (" + this.setCount + ")");
        }
        return this;
    }
}

