/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.MinHeapFile;
import edu.ucar.unidata.sruth.Util;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import net.jcip.annotations.NotThreadSafe;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;

@ThreadSafe
final class PathDelayQueue {
    private static Logger logger = Util.getLogger();
    static final int MAX_PATH_LEN = 255;
    private final MinHeapFile<Entry> heap;

    PathDelayQueue(Path path) throws IOException {
        this.heap = new MinHeapFile<Entry>(path, Entry.getMaxSize(), Entry.class);
    }

    synchronized void add(Path path, long time) throws IOException {
        try {
            this.heap.add(new Entry(path, (Long)time));
            this.notifyAll();
        }
        catch (InstantiationException impossible) {
            throw new AssertionError((Object)impossible);
        }
        catch (IllegalAccessException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }

    int size() {
        return this.heap.size();
    }

    synchronized Path take() throws InterruptedException, IOException {
        try {
            long sleep;
            while (this.heap.peek() == null) {
                this.wait();
            }
            while ((sleep = this.heap.peek().getTime() - System.currentTimeMillis()) > 0L) {
                this.wait(sleep);
            }
            Entry entry = this.heap.remove();
            this.notifyAll();
            logger.trace("Returned {}", entry);
            return entry.getPath();
        }
        catch (InstantiationException impossible) {
            throw new AssertionError((Object)impossible);
        }
        catch (IllegalAccessException impossible) {
            throw new AssertionError((Object)impossible);
        }
        catch (ClosedByInterruptException e) {
            throw (InterruptedException)new InterruptedException().initCause(e);
        }
    }

    synchronized void waitUntilEmpty() throws InterruptedException {
        while (this.size() > 0) {
            this.wait();
        }
    }

    synchronized void close() throws IOException {
        this.heap.close();
    }

    public String toString() {
        return "PathDelayQueue [heap=" + this.heap + "]";
    }

    public static void main(String[] args) throws IOException {
        boolean INVALID_INVOCATION = true;
        Path path = null;
        try {
            String arg;
            int iarg = 0;
            if (iarg < args.length) {
                arg = args[iarg];
                try {
                    if (arg.charAt(0) == '-') {
                        String optString = arg.substring(1);
                        arg = args[++iarg];
                        logger.error("Invalid option: \"{}\"", (Object)optString);
                        throw new IllegalArgumentException();
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    logger.error("Invalid argument: \"{}\"", (Object)arg);
                    throw new IllegalArgumentException();
                }
            }
            if (iarg >= args.length) {
                logger.error("The path argument is missing");
                throw new IllegalArgumentException();
            }
            arg = args[iarg++];
            path = Paths.get(arg, new String[0]);
            if (iarg < args.length) {
                logger.error("Too many arguments");
                throw new IllegalArgumentException();
            }
        }
        catch (IllegalArgumentException e) {
            logger.error("Usage: " + PathDelayQueue.class.getCanonicalName() + " pathname");
            System.exit(1);
        }
        PathDelayQueue queue = new PathDelayQueue(path);
        DateFormat dateFormat = DateFormat.getInstance();
        Calendar calendar = dateFormat.getCalendar();
        for (Entry entry : queue.heap) {
            System.out.println(entry.toString());
        }
    }

    @NotThreadSafe
    private static class Entry
    extends MinHeapFile.Element {
        private long time;
        private byte[] path;

        Entry() {
        }

        Entry(Path path, Long time) {
            this(path.toString().getBytes(), (long)time);
        }

        private Entry(byte[] path, long time) {
            if (path.length > 255) {
                throw new IllegalArgumentException("Pathname too long: \"" + new String(path) + "\"");
            }
            this.path = path;
            this.time = time;
        }

        Path getPath() {
            return Paths.get(new String(this.path), new String[0]);
        }

        long getTime() {
            return this.time;
        }

        @Override
        public void write(ByteBuffer out) throws IOException {
            out.putLong(this.time);
            out.putShort((short)this.path.length);
            out.put(this.path);
        }

        @Override
        public void read(ByteBuffer in) throws IOException {
            this.time = in.getLong();
            if (this.time < 0L) {
                throw new InvalidObjectException("Invalid time: " + new Date(this.time));
            }
            short len = in.getShort();
            if (len <= 0 || len > 255) {
                throw new InvalidObjectException("Invalid pathname length: " + len);
            }
            this.path = new byte[len];
            in.get(this.path);
        }

        @Override
        public int compareTo(MinHeapFile.Element o) {
            Entry that = (Entry)o;
            return this.time < that.time ? -1 : (this.time > that.time ? 1 : this.compare(this.path, that.path));
        }

        private int compare(byte[] ba1, byte[] ba2) {
            int minLen = ba1.length < ba2.length ? ba1.length : ba2.length;
            for (int i = 0; i < minLen; ++i) {
                if (ba1[i] < ba2[i]) {
                    return -1;
                }
                if (ba1[i] <= ba2[i]) continue;
                return 1;
            }
            return ba1.length < ba2.length ? -1 : (ba1.length == ba2.length ? 0 : 1);
        }

        static int getMaxSize() {
            return 265;
        }

        public String toString() {
            DateFormat dateFormat = DateFormat.getInstance();
            Calendar calendar = dateFormat.getCalendar();
            calendar.setTimeInMillis(this.time);
            Date date = calendar.getTime();
            String timestamp = dateFormat.format(date);
            return this.getClass().getSimpleName() + "[when=" + timestamp + ", path=" + new String(this.path) + "]";
        }
    }
}

